/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic.utils;

import java.util.ArrayList;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.ml.genetic.Chromosome;
import org.apache.ignite.ml.genetic.Gene;
import org.apache.ignite.ml.genetic.cache.PopulationCacheConfig;

public class GAGridUtils {
    public static List<Chromosome> getChromosomes(Ignite ignite, String query) {
        ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
        IgniteCache populationCache = ignite.getOrCreateCache(PopulationCacheConfig.populationCache());
        SqlQuery sql = new SqlQuery(Chromosome.class, query);
        try (QueryCursor cursor = populationCache.query((Query)sql);){
            for (Cache.Entry e : cursor) {
                chromosomes.add((Chromosome)e.getValue());
            }
        }
        return chromosomes;
    }

    public static List<Gene> getGenesInOrderForChromosome(Ignite ignite, Chromosome chromosome) {
        ArrayList<Gene> genes = new ArrayList<Gene>();
        IgniteCache cache = ignite.cache("geneCache");
        long[] primaryKeys = chromosome.getGenes();
        for (int k = 0; k < primaryKeys.length; ++k) {
            StringBuffer sbSqlClause = new StringBuffer();
            sbSqlClause.append("_key IN ");
            sbSqlClause.append("(");
            sbSqlClause.append(primaryKeys[k]);
            sbSqlClause.append(")");
            SqlQuery sql = new SqlQuery(Gene.class, sbSqlClause.toString());
            try (QueryCursor cursor = cache.query((Query)sql);){
                for (Cache.Entry e : cursor) {
                    genes.add((Gene)e.getValue());
                }
                continue;
            }
        }
        return genes;
    }
}

