/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.ml.genetic.FitnessJob;
import org.apache.ignite.ml.genetic.parameter.GAConfiguration;
import org.apache.ignite.resources.IgniteInstanceResource;

public class FitnessTask
extends ComputeTaskAdapter<List<Long>, Boolean> {
    @IgniteInstanceResource
    private Ignite ignite = null;
    private GAConfiguration config = null;

    public FitnessTask(GAConfiguration config) {
        this.config = config;
    }

    public Map map(List<ClusterNode> nodes, List<Long> chromosomeKeys) throws IgniteException {
        HashMap<FitnessJob, ClusterNode> map = new HashMap<FitnessJob, ClusterNode>();
        Affinity affinity = this.ignite.affinity("populationCache");
        for (Long key : chromosomeKeys) {
            FitnessJob ajob = new FitnessJob(key, this.config.getFitnessFunction());
            ClusterNode primary = affinity.mapKeyToNode((Object)key);
            map.put(ajob, primary);
        }
        return map;
    }

    public Boolean reduce(List<ComputeJobResult> list) throws IgniteException {
        return Boolean.TRUE;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        IgniteException err = res.getException();
        if (err != null) {
            return ComputeJobResultPolicy.FAILOVER;
        }
        return ComputeJobResultPolicy.WAIT;
    }
}

