/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.osgi.classloaders;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.osgi.classloaders.BundleDelegatingClassLoader;
import org.osgi.framework.Bundle;

public class ContainerSweepClassLoader
extends BundleDelegatingClassLoader {
    private final ConcurrentMap<String, Bundle> resolved = new ConcurrentHashMap<String, Bundle>();
    private final Set<String> nonResolvable = new GridConcurrentHashSet();

    public ContainerSweepClassLoader(Bundle bundle) {
        super(bundle);
    }

    public ContainerSweepClassLoader(Bundle bundle, ClassLoader classLoader) {
        super(bundle, classLoader);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.nonResolvable.contains(name)) {
            throw this.classNotFoundException(name);
        }
        try {
            Class<?> cls = super.loadClass(name, resolve);
            return cls;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.resolved.containsKey(name)) {
                return ((Bundle)this.resolved.get(name)).loadClass(name);
            }
            Class<?> cls = this.sweepContainer(name);
            if (cls == null) {
                throw this.classNotFoundException(name);
            }
            return cls;
        }
    }

    protected Class<?> sweepContainer(String name) {
        int bundleIdx;
        Class cls = null;
        Bundle[] bundles = this.bundle.getBundleContext().getBundles();
        for (bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
            Bundle b = bundles[bundleIdx];
            if (b.getState() <= 4 || b.getHeaders().get("Fragment-Host") != null) continue;
            try {
                cls = b.loadClass(name);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (cls == null) {
            this.nonResolvable.add(name);
        } else {
            this.resolved.put(name, bundles[bundleIdx]);
        }
        return cls;
    }
}

