/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.StatefulTask;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.runtime.plugable.NonReusingDeserializationDelegate;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.BarrierBuffer;
import org.apache.flink.streaming.runtime.io.BarrierTracker;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.InputGateUtil;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StatusWatermarkValve;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamTwoInputProcessor<IN1, IN2> {
    private final RecordDeserializer<DeserializationDelegate<StreamElement>>[] recordDeserializers;
    private RecordDeserializer<DeserializationDelegate<StreamElement>> currentRecordDeserializer;
    private final DeserializationDelegate<StreamElement> deserializationDelegate1;
    private final DeserializationDelegate<StreamElement> deserializationDelegate2;
    private final CheckpointBarrierHandler barrierHandler;
    private final Object lock;
    private StreamStatus firstStatus;
    private StreamStatus secondStatus;
    private StatusWatermarkValve statusWatermarkValve1;
    private StatusWatermarkValve statusWatermarkValve2;
    private final int numInputChannels1;
    private final int numInputChannels2;
    private int currentChannel = -1;
    private final StreamStatusMaintainer streamStatusMaintainer;
    private final TwoInputStreamOperator<IN1, IN2, ?> streamOperator;
    private long lastEmittedWatermark1;
    private long lastEmittedWatermark2;
    private Counter numRecordsIn;
    private boolean isFinished;

    public StreamTwoInputProcessor(Collection<InputGate> inputGates1, Collection<InputGate> inputGates2, TypeSerializer<IN1> inputSerializer1, TypeSerializer<IN2> inputSerializer2, StatefulTask checkpointedTask, CheckpointingMode checkpointMode, Object lock, IOManager ioManager, Configuration taskManagerConfig, StreamStatusMaintainer streamStatusMaintainer, TwoInputStreamOperator<IN1, IN2, ?> streamOperator) throws IOException {
        InputGate inputGate = InputGateUtil.createInputGate(inputGates1, inputGates2);
        if (checkpointMode == CheckpointingMode.EXACTLY_ONCE) {
            long maxAlign = taskManagerConfig.getLong(TaskManagerOptions.TASK_CHECKPOINT_ALIGNMENT_BYTES_LIMIT);
            if (maxAlign != -1L && maxAlign <= 0L) {
                throw new IllegalConfigurationException(TaskManagerOptions.TASK_CHECKPOINT_ALIGNMENT_BYTES_LIMIT.key() + " must be positive or -1 (infinite)");
            }
            this.barrierHandler = new BarrierBuffer(inputGate, ioManager, maxAlign);
        } else if (checkpointMode == CheckpointingMode.AT_LEAST_ONCE) {
            this.barrierHandler = new BarrierTracker(inputGate);
        } else {
            throw new IllegalArgumentException("Unrecognized CheckpointingMode: " + (Object)((Object)checkpointMode));
        }
        if (checkpointedTask != null) {
            this.barrierHandler.registerCheckpointEventHandler(checkpointedTask);
        }
        this.lock = Preconditions.checkNotNull((Object)lock);
        StreamElementSerializer<IN1> ser1 = new StreamElementSerializer<IN1>(inputSerializer1);
        this.deserializationDelegate1 = new NonReusingDeserializationDelegate(ser1);
        StreamElementSerializer<IN2> ser2 = new StreamElementSerializer<IN2>(inputSerializer2);
        this.deserializationDelegate2 = new NonReusingDeserializationDelegate(ser2);
        this.recordDeserializers = new SpillingAdaptiveSpanningRecordDeserializer[inputGate.getNumberOfInputChannels()];
        for (int i = 0; i < this.recordDeserializers.length; ++i) {
            this.recordDeserializers[i] = new SpillingAdaptiveSpanningRecordDeserializer(ioManager.getSpillingDirectoriesPaths());
        }
        int numInputChannels1 = 0;
        for (InputGate gate : inputGates1) {
            numInputChannels1 += gate.getNumberOfInputChannels();
        }
        this.numInputChannels1 = numInputChannels1;
        this.numInputChannels2 = inputGate.getNumberOfInputChannels() - numInputChannels1;
        this.lastEmittedWatermark1 = Long.MIN_VALUE;
        this.lastEmittedWatermark2 = Long.MIN_VALUE;
        this.firstStatus = StreamStatus.ACTIVE;
        this.secondStatus = StreamStatus.ACTIVE;
        this.streamStatusMaintainer = (StreamStatusMaintainer)Preconditions.checkNotNull((Object)streamStatusMaintainer);
        this.streamOperator = (TwoInputStreamOperator)Preconditions.checkNotNull(streamOperator);
        this.statusWatermarkValve1 = new StatusWatermarkValve(numInputChannels1, new ForwardingValveOutputHandler1(streamOperator, lock));
        this.statusWatermarkValve2 = new StatusWatermarkValve(this.numInputChannels2, new ForwardingValveOutputHandler2(streamOperator, lock));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processInput() throws Exception {
        block27: {
            AbstractEvent event;
            if (this.isFinished) {
                return false;
            }
            if (this.numRecordsIn == null) {
                this.numRecordsIn = ((OperatorMetricGroup)this.streamOperator.getMetricGroup()).getIOMetricGroup().getNumRecordsInCounter();
            }
            while (true) {
                BufferOrEvent bufferOrEvent;
                if (this.currentRecordDeserializer != null) {
                    RecordDeserializer.DeserializationResult result = this.currentChannel < this.numInputChannels1 ? this.currentRecordDeserializer.getNextRecord(this.deserializationDelegate1) : this.currentRecordDeserializer.getNextRecord(this.deserializationDelegate2);
                    if (result.isBufferConsumed()) {
                        this.currentRecordDeserializer.getCurrentBuffer().recycle();
                        this.currentRecordDeserializer = null;
                    }
                    if (result.isFullRecord()) {
                        Object record;
                        StreamElement recordOrWatermark;
                        if (this.currentChannel < this.numInputChannels1) {
                            recordOrWatermark = (StreamElement)this.deserializationDelegate1.getInstance();
                            if (recordOrWatermark.isWatermark()) {
                                this.statusWatermarkValve1.inputWatermark(recordOrWatermark.asWatermark(), this.currentChannel);
                                continue;
                            }
                            if (recordOrWatermark.isStreamStatus()) {
                                this.statusWatermarkValve1.inputStreamStatus(recordOrWatermark.asStreamStatus(), this.currentChannel);
                                continue;
                            }
                            if (recordOrWatermark.isLatencyMarker()) {
                                Object object = this.lock;
                                synchronized (object) {
                                    this.streamOperator.processLatencyMarker1(recordOrWatermark.asLatencyMarker());
                                }
                            }
                            record = recordOrWatermark.asRecord();
                            Object object = this.lock;
                            synchronized (object) {
                                this.numRecordsIn.inc();
                                this.streamOperator.setKeyContextElement1((StreamRecord<?>)record);
                                this.streamOperator.processElement1((StreamRecord<IN1>)record);
                            }
                            return true;
                        }
                        recordOrWatermark = (StreamElement)this.deserializationDelegate2.getInstance();
                        if (recordOrWatermark.isWatermark()) {
                            this.statusWatermarkValve2.inputWatermark(recordOrWatermark.asWatermark(), this.currentChannel - this.numInputChannels1);
                            continue;
                        }
                        if (recordOrWatermark.isStreamStatus()) {
                            this.statusWatermarkValve2.inputStreamStatus(recordOrWatermark.asStreamStatus(), this.currentChannel - this.numInputChannels1);
                            continue;
                        }
                        if (recordOrWatermark.isLatencyMarker()) {
                            record = this.lock;
                            synchronized (record) {
                                this.streamOperator.processLatencyMarker2(recordOrWatermark.asLatencyMarker());
                            }
                        }
                        record = recordOrWatermark.asRecord();
                        Object object = this.lock;
                        synchronized (object) {
                            this.numRecordsIn.inc();
                            this.streamOperator.setKeyContextElement2((StreamRecord<?>)record);
                            this.streamOperator.processElement2((StreamRecord<IN2>)record);
                        }
                        return true;
                    }
                }
                if ((bufferOrEvent = this.barrierHandler.getNextNonBlocked()) == null) break block27;
                if (bufferOrEvent.isBuffer()) {
                    this.currentChannel = bufferOrEvent.getChannelIndex();
                    this.currentRecordDeserializer = this.recordDeserializers[this.currentChannel];
                    this.currentRecordDeserializer.setNextBuffer(bufferOrEvent.getBuffer());
                    continue;
                }
                event = bufferOrEvent.getEvent();
                if (event.getClass() != EndOfPartitionEvent.class) break;
            }
            throw new IOException("Unexpected event: " + event);
        }
        this.isFinished = true;
        if (!this.barrierHandler.isEmpty()) {
            throw new IllegalStateException("Trailing data in checkpoint barrier handler.");
        }
        return false;
    }

    public void setMetricGroup(TaskIOMetricGroup metrics) {
        metrics.gauge("currentLowWatermark", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return Math.min(StreamTwoInputProcessor.this.lastEmittedWatermark1, StreamTwoInputProcessor.this.lastEmittedWatermark2);
            }
        });
        metrics.gauge("checkpointAlignmentTime", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return StreamTwoInputProcessor.this.barrierHandler.getAlignmentDurationNanos();
            }
        });
    }

    public void cleanup() throws IOException {
        for (RecordDeserializer<DeserializationDelegate<StreamElement>> deserializer : this.recordDeserializers) {
            Buffer buffer = deserializer.getCurrentBuffer();
            if (buffer == null || buffer.isRecycled()) continue;
            buffer.recycle();
        }
        this.barrierHandler.cleanup();
    }

    private class ForwardingValveOutputHandler2
    implements StatusWatermarkValve.ValveOutputHandler {
        private final TwoInputStreamOperator<IN1, IN2, ?> operator;
        private final Object lock;

        private ForwardingValveOutputHandler2(TwoInputStreamOperator<IN1, IN2, ?> operator, Object lock) {
            this.operator = (TwoInputStreamOperator)Preconditions.checkNotNull(operator);
            this.lock = Preconditions.checkNotNull((Object)lock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleWatermark(Watermark watermark) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    StreamTwoInputProcessor.this.lastEmittedWatermark2 = watermark.getTimestamp();
                    this.operator.processWatermark2(watermark);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occurred while processing valve output watermark: ", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleStreamStatus(StreamStatus streamStatus) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    StreamTwoInputProcessor.this.secondStatus = streamStatus;
                    if (!streamStatus.equals(StreamTwoInputProcessor.this.streamStatusMaintainer.getStreamStatus())) {
                        if (streamStatus.isActive()) {
                            StreamTwoInputProcessor.this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.ACTIVE);
                        } else if (StreamTwoInputProcessor.this.firstStatus.isIdle()) {
                            StreamTwoInputProcessor.this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.IDLE);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occurred while processing valve output stream status: ", e);
            }
        }
    }

    private class ForwardingValveOutputHandler1
    implements StatusWatermarkValve.ValveOutputHandler {
        private final TwoInputStreamOperator<IN1, IN2, ?> operator;
        private final Object lock;

        private ForwardingValveOutputHandler1(TwoInputStreamOperator<IN1, IN2, ?> operator, Object lock) {
            this.operator = (TwoInputStreamOperator)Preconditions.checkNotNull(operator);
            this.lock = Preconditions.checkNotNull((Object)lock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleWatermark(Watermark watermark) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    StreamTwoInputProcessor.this.lastEmittedWatermark1 = watermark.getTimestamp();
                    this.operator.processWatermark1(watermark);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occurred while processing valve output watermark: ", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleStreamStatus(StreamStatus streamStatus) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    StreamTwoInputProcessor.this.firstStatus = streamStatus;
                    if (!streamStatus.equals(StreamTwoInputProcessor.this.streamStatusMaintainer.getStreamStatus())) {
                        if (streamStatus.isActive()) {
                            StreamTwoInputProcessor.this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.ACTIVE);
                        } else if (StreamTwoInputProcessor.this.secondStatus.isIdle()) {
                            StreamTwoInputProcessor.this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.IDLE);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occurred while processing valve output stream status: ", e);
            }
        }
    }
}

