/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.ArrayDeque;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.decline.CheckpointDeclineOnCancellationBarrierException;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.StatefulTask;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BarrierTracker
implements CheckpointBarrierHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BarrierTracker.class);
    private static final int MAX_CHECKPOINTS_TO_TRACK = 50;
    private final InputGate inputGate;
    private final int totalNumberOfInputChannels;
    private final ArrayDeque<CheckpointBarrierCount> pendingCheckpoints;
    private StatefulTask toNotifyOnCheckpoint;
    private long latestPendingCheckpointID = -1L;

    public BarrierTracker(InputGate inputGate) {
        this.inputGate = inputGate;
        this.totalNumberOfInputChannels = inputGate.getNumberOfInputChannels();
        this.pendingCheckpoints = new ArrayDeque();
    }

    @Override
    public BufferOrEvent getNextNonBlocked() throws Exception {
        BufferOrEvent next;
        while (true) {
            if ((next = this.inputGate.getNextBufferOrEvent()) == null || next.isBuffer()) {
                return next;
            }
            if (next.getEvent().getClass() == CheckpointBarrier.class) {
                this.processBarrier((CheckpointBarrier)next.getEvent(), next.getChannelIndex());
                continue;
            }
            if (next.getEvent().getClass() != CancelCheckpointMarker.class) break;
            this.processCheckpointAbortBarrier((CancelCheckpointMarker)next.getEvent(), next.getChannelIndex());
        }
        return next;
    }

    @Override
    public void registerCheckpointEventHandler(StatefulTask toNotifyOnCheckpoint) {
        if (this.toNotifyOnCheckpoint != null) {
            throw new IllegalStateException("BarrierTracker already has a registered checkpoint notifyee");
        }
        this.toNotifyOnCheckpoint = toNotifyOnCheckpoint;
    }

    @Override
    public void cleanup() {
        this.pendingCheckpoints.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.pendingCheckpoints.isEmpty();
    }

    @Override
    public long getAlignmentDurationNanos() {
        return 0L;
    }

    private void processBarrier(CheckpointBarrier receivedBarrier, int channelIndex) throws Exception {
        long barrierId = receivedBarrier.getId();
        if (this.totalNumberOfInputChannels == 1) {
            this.notifyCheckpoint(barrierId, receivedBarrier.getTimestamp(), receivedBarrier.getCheckpointOptions());
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received barrier for checkpoint {} from channel {}", (Object)barrierId, (Object)channelIndex);
        }
        CheckpointBarrierCount cbc = null;
        int pos = 0;
        for (CheckpointBarrierCount next : this.pendingCheckpoints) {
            if (next.checkpointId == barrierId) {
                cbc = next;
                break;
            }
            ++pos;
        }
        if (cbc != null) {
            int numBarriersNew = cbc.incrementBarrierCount();
            if (numBarriersNew == this.totalNumberOfInputChannels) {
                for (int i = 0; i <= pos; ++i) {
                    this.pendingCheckpoints.pollFirst();
                }
                if (!cbc.isAborted()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received all barriers for checkpoint {}", (Object)barrierId);
                    }
                    this.notifyCheckpoint(receivedBarrier.getId(), receivedBarrier.getTimestamp(), receivedBarrier.getCheckpointOptions());
                }
            }
        } else if (barrierId > this.latestPendingCheckpointID) {
            this.latestPendingCheckpointID = barrierId;
            this.pendingCheckpoints.addLast(new CheckpointBarrierCount(barrierId));
            if (this.pendingCheckpoints.size() > 50) {
                this.pendingCheckpoints.pollFirst();
            }
        }
    }

    private void processCheckpointAbortBarrier(CancelCheckpointMarker barrier, int channelIndex) throws Exception {
        CheckpointBarrierCount cbc;
        long checkpointId = barrier.getCheckpointId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received cancellation barrier for checkpoint {} from channel {}", (Object)checkpointId, (Object)channelIndex);
        }
        if (this.totalNumberOfInputChannels == 1) {
            this.notifyAbort(checkpointId);
            return;
        }
        while ((cbc = this.pendingCheckpoints.peekFirst()) != null && cbc.checkpointId() < checkpointId) {
            this.pendingCheckpoints.removeFirst();
            if (!cbc.markAborted()) continue;
            this.notifyAbort(cbc.checkpointId());
        }
        if (cbc != null && cbc.checkpointId() == checkpointId) {
            if (cbc.markAborted()) {
                this.notifyAbort(checkpointId);
            }
            if (cbc.incrementBarrierCount() == this.totalNumberOfInputChannels) {
                this.pendingCheckpoints.removeFirst();
            }
        } else if (checkpointId > this.latestPendingCheckpointID) {
            this.notifyAbort(checkpointId);
            this.latestPendingCheckpointID = checkpointId;
            CheckpointBarrierCount abortedMarker = new CheckpointBarrierCount(checkpointId);
            abortedMarker.markAborted();
            this.pendingCheckpoints.addFirst(abortedMarker);
        }
    }

    private void notifyCheckpoint(long checkpointId, long timestamp, CheckpointOptions checkpointOptions) throws Exception {
        if (this.toNotifyOnCheckpoint != null) {
            CheckpointMetaData checkpointMetaData = new CheckpointMetaData(checkpointId, timestamp);
            CheckpointMetrics checkpointMetrics = new CheckpointMetrics().setBytesBufferedInAlignment(0L).setAlignmentDurationNanos(0L);
            this.toNotifyOnCheckpoint.triggerCheckpointOnBarrier(checkpointMetaData, checkpointOptions, checkpointMetrics);
        }
    }

    private void notifyAbort(long checkpointId) throws Exception {
        if (this.toNotifyOnCheckpoint != null) {
            this.toNotifyOnCheckpoint.abortCheckpointOnBarrier(checkpointId, (Throwable)new CheckpointDeclineOnCancellationBarrierException());
        }
    }

    private static final class CheckpointBarrierCount {
        private final long checkpointId;
        private int barrierCount;
        private boolean aborted;

        CheckpointBarrierCount(long checkpointId) {
            this.checkpointId = checkpointId;
            this.barrierCount = 1;
        }

        public long checkpointId() {
            return this.checkpointId;
        }

        public int incrementBarrierCount() {
            return ++this.barrierCount;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public boolean markAborted() {
            boolean firstAbort = !this.aborted;
            this.aborted = true;
            return firstAbort;
        }

        public String toString() {
            return this.isAborted() ? String.format("checkpointID=%d - ABORTED", this.checkpointId) : String.format("checkpointID=%d, count=%d", this.checkpointId, this.barrierCount);
        }
    }
}

