/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.collector.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.XORShiftRandom;

public class DirectedOutput<OUT>
implements Output<StreamRecord<OUT>> {
    protected final OutputSelector<OUT>[] outputSelectors;
    protected final Output<StreamRecord<OUT>>[] selectAllOutputs;
    protected final HashMap<String, Output<StreamRecord<OUT>>[]> outputMap;
    protected final Output<StreamRecord<OUT>>[] allOutputs;
    private final Random random = new XORShiftRandom();

    public DirectedOutput(List<OutputSelector<OUT>> outputSelectors, List<Tuple2<Output<StreamRecord<OUT>>, StreamEdge>> outputs) {
        this.outputSelectors = outputSelectors.toArray(new OutputSelector[outputSelectors.size()]);
        this.allOutputs = new Output[outputs.size()];
        for (int i = 0; i < outputs.size(); ++i) {
            this.allOutputs[i] = (Output)outputs.get((int)i).f0;
        }
        HashSet<Output> selectAllOutputs = new HashSet<Output>();
        HashMap outputMap = new HashMap();
        for (Tuple2<Output<StreamRecord<OUT>>, StreamEdge> tuple2 : outputs) {
            Output output = (Output)tuple2.f0;
            StreamEdge edge = (StreamEdge)tuple2.f1;
            List<String> selectedNames = edge.getSelectedNames();
            if (selectedNames.isEmpty()) {
                selectAllOutputs.add(output);
                continue;
            }
            for (String selectedName : selectedNames) {
                if (!outputMap.containsKey(selectedName)) {
                    outputMap.put(selectedName, new ArrayList());
                    ((ArrayList)outputMap.get(selectedName)).add(output);
                    continue;
                }
                if (((ArrayList)outputMap.get(selectedName)).contains(output)) continue;
                ((ArrayList)outputMap.get(selectedName)).add(output);
            }
        }
        this.selectAllOutputs = selectAllOutputs.toArray(new Output[selectAllOutputs.size()]);
        this.outputMap = new HashMap();
        for (Map.Entry entry : outputMap.entrySet()) {
            Output[] arr = ((ArrayList)entry.getValue()).toArray(new Output[((ArrayList)entry.getValue()).size()]);
            this.outputMap.put((String)entry.getKey(), arr);
        }
    }

    @Override
    public void emitWatermark(Watermark mark) {
        for (Output<StreamRecord<OUT>> out : this.allOutputs) {
            out.emitWatermark(mark);
        }
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        this.allOutputs[this.random.nextInt(this.allOutputs.length)].emitLatencyMarker(latencyMarker);
    }

    protected Set<Output<StreamRecord<OUT>>> selectOutputs(StreamRecord<OUT> record) {
        HashSet<Output<StreamRecord<OUT>>> selectedOutputs = new HashSet<Output<StreamRecord<OUT>>>(this.selectAllOutputs.length);
        Collections.addAll(selectedOutputs, this.selectAllOutputs);
        for (OutputSelector<OUT> outputSelector : this.outputSelectors) {
            Iterable<String> outputNames = outputSelector.select(record.getValue());
            for (String outputName : outputNames) {
                Output<StreamRecord<OUT>>[] outputList = this.outputMap.get(outputName);
                if (outputList == null) continue;
                Collections.addAll(selectedOutputs, outputList);
            }
        }
        return selectedOutputs;
    }

    public void collect(StreamRecord<OUT> record) {
        Set<Output<StreamRecord<OUT>>> selectedOutputs = this.selectOutputs(record);
        for (Output<StreamRecord<OUT>> out : selectedOutputs) {
            out.collect(record);
        }
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        throw new UnsupportedOperationException("Cannot use split/select with side outputs.");
    }

    public void close() {
        for (Output<StreamRecord<OUT>> out : this.allOutputs) {
            out.close();
        }
    }
}

