/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.impurity.mse;

import org.apache.ignite.ml.tree.impurity.ImpurityMeasure;

public class MSEImpurityMeasure
implements ImpurityMeasure<MSEImpurityMeasure> {
    private static final long serialVersionUID = 4536394578628409689L;
    private final double leftY;
    private final double leftY2;
    private final long leftCnt;
    private final double rightY;
    private final double rightY2;
    private final long rightCnt;

    public MSEImpurityMeasure(double leftY, double leftY2, long leftCnt, double rightY, double rightY2, long rightCnt) {
        this.leftY = leftY;
        this.leftY2 = leftY2;
        this.leftCnt = leftCnt;
        this.rightY = rightY;
        this.rightY2 = rightY2;
        this.rightCnt = rightCnt;
    }

    @Override
    public double impurity() {
        double impurity = 0.0;
        if (this.leftCnt > 0L) {
            impurity += this.leftY2 - 2.0 * this.leftY / (double)this.leftCnt * this.leftY + Math.pow(this.leftY / (double)this.leftCnt, 2.0) * (double)this.leftCnt;
        }
        if (this.rightCnt > 0L) {
            impurity += this.rightY2 - 2.0 * this.rightY / (double)this.rightCnt * this.rightY + Math.pow(this.rightY / (double)this.rightCnt, 2.0) * (double)this.rightCnt;
        }
        return impurity;
    }

    @Override
    public MSEImpurityMeasure add(MSEImpurityMeasure b) {
        return new MSEImpurityMeasure(this.leftY + b.leftY, this.leftY2 + b.leftY2, this.leftCnt + b.leftCnt, this.rightY + b.rightY, this.rightY2 + b.rightY2, this.rightCnt + b.rightCnt);
    }

    @Override
    public MSEImpurityMeasure subtract(MSEImpurityMeasure b) {
        return new MSEImpurityMeasure(this.leftY - b.leftY, this.leftY2 - b.leftY2, this.leftCnt - b.leftCnt, this.rightY - b.rightY, this.rightY2 - b.rightY2, this.rightCnt - b.rightCnt);
    }

    public double getLeftY() {
        return this.leftY;
    }

    public double getLeftY2() {
        return this.leftY2;
    }

    public long getLeftCnt() {
        return this.leftCnt;
    }

    public double getRightY() {
        return this.rightY;
    }

    public double getRightY2() {
        return this.rightY2;
    }

    public long getRightCnt() {
        return this.rightCnt;
    }
}

