/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.impls.storage.vector.SingleElementVectorDelegateStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractVector;

public class SingleElementVectorView
extends AbstractVector {
    public SingleElementVectorView() {
    }

    public SingleElementVectorView(Vector vec, int idx) {
        super(new SingleElementVectorDelegateStorage(vec, idx));
    }

    private SingleElementVectorDelegateStorage storage() {
        return (SingleElementVectorDelegateStorage)this.getStorage();
    }

    @Override
    public Vector.Element minElement() {
        return this.makeElement(this.storage().index());
    }

    @Override
    public Vector.Element maxElement() {
        return this.makeElement(this.storage().index());
    }

    @Override
    public double sum() {
        return this.getX(this.storage().index());
    }

    @Override
    public int nonZeroElements() {
        return this.isZero(this.getX(this.storage().index())) ? 0 : 1;
    }

    @Override
    public Vector copy() {
        SingleElementVectorDelegateStorage sto = this.storage();
        return new SingleElementVectorView(sto.delegate(), sto.index());
    }

    @Override
    public Vector times(double x) {
        if (x == 0.0) {
            return this.copy().map(Functions.mult(x));
        }
        return super.times(x);
    }

    @Override
    public Vector like(int crd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        throw new UnsupportedOperationException();
    }
}

