/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.offheap.GridOffHeapMap;
import org.apache.ignite.internal.util.offheap.GridOffHeapMapFactory;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;

public class SparseLocalOffHeapVectorStorage
implements VectorStorage {
    private static final int INIT_DENSITY = 10;
    private int size;
    private GridOffHeapMap gridOffHeapMap;

    public SparseLocalOffHeapVectorStorage() {
    }

    public SparseLocalOffHeapVectorStorage(int cap) {
        assert (cap > 0);
        this.gridOffHeapMap = GridOffHeapMapFactory.unsafeMap((long)(cap / 10));
        this.size = cap;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        byte[] bytes = this.gridOffHeapMap.get(this.hash(i), this.intToByteArray(i));
        return bytes == null ? 0.0 : ByteBuffer.wrap(bytes).getDouble();
    }

    @Override
    public void set(int i, double v) {
        if (v != 0.0) {
            this.gridOffHeapMap.put(this.hash(i), this.intToByteArray(i), this.doubleToByteArray(v));
        } else if (this.gridOffHeapMap.contains(this.hash(i), this.intToByteArray(i))) {
            this.gridOffHeapMap.remove(this.hash(i), this.intToByteArray(i));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public void destroy() {
        this.gridOffHeapMap.destruct();
    }

    private int hash(int h) {
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        return (h *= -1028477387) >>> 16 ^ h;
    }

    private byte[] intToByteArray(int val) {
        return new byte[]{(byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
    }

    private byte[] doubleToByteArray(double val) {
        long l = Double.doubleToRawLongBits(val);
        return new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
    }
}

