/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;

public class SingleElementVectorStorage
implements VectorStorage {
    private int idx;
    private double val;
    private int size;

    public SingleElementVectorStorage() {
    }

    public SingleElementVectorStorage(int size, int idx, double val) {
        assert (size > 0);
        assert (idx >= 0);
        this.size = size;
        this.idx = idx;
        this.val = val;
    }

    public int index() {
        return this.idx;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        return i == this.idx ? this.val : 0.0;
    }

    @Override
    public void set(int i, double v) {
        if (i != this.idx) {
            throw new UnsupportedOperationException("Can't set element outside of index: " + this.idx);
        }
        this.val = v;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.idx);
        out.writeDouble(this.val);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.idx = in.readInt();
        this.val = in.readDouble();
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleElementVectorStorage that = (SingleElementVectorStorage)o;
        return this.idx == that.idx && Double.compare(that.val, this.val) == 0 && this.size == that.size;
    }

    public int hashCode() {
        int res = this.idx;
        long temp = Double.doubleToLongBits(this.val);
        res = 31 * res + (int)(temp ^ temp >>> 32);
        res = 31 * res + this.size;
        return res;
    }
}

