/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.ignite.ml.math.VectorStorage;

public class PivotedVectorStorage
implements VectorStorage {
    private VectorStorage sto;
    private int[] pivot;
    private int[] unpivot;

    private static int[] reverse(int[] pivot) {
        int[] res = new int[pivot.length];
        for (int i = 0; i < pivot.length; ++i) {
            res[pivot[i]] = i;
        }
        return res;
    }

    public int[] pivot() {
        return this.pivot;
    }

    public int[] unpivot() {
        return this.unpivot;
    }

    public PivotedVectorStorage(VectorStorage sto, int[] pivot, int[] unpivot) {
        assert (sto != null);
        assert (pivot != null);
        assert (unpivot != null);
        this.sto = sto;
        this.pivot = pivot;
        this.unpivot = unpivot;
    }

    public PivotedVectorStorage(VectorStorage sto, int[] pivot) {
        this(sto, pivot, PivotedVectorStorage.reverse(pivot));
    }

    public PivotedVectorStorage() {
    }

    @Override
    public int size() {
        return this.sto.size();
    }

    @Override
    public double get(int i) {
        return this.sto.get(this.pivot[i]);
    }

    @Override
    public void set(int i, double v) {
        this.sto.set(this.pivot[i], v);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sto);
        out.writeObject(this.pivot);
        out.writeObject(this.unpivot);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sto = (VectorStorage)in.readObject();
        this.pivot = (int[])in.readObject();
        this.unpivot = (int[])in.readObject();
    }

    @Override
    public boolean isSequentialAccess() {
        return this.sto.isSequentialAccess();
    }

    @Override
    public boolean isDense() {
        return this.sto.isDense();
    }

    @Override
    public boolean isRandomAccess() {
        return this.sto.isRandomAccess();
    }

    @Override
    public boolean isDistributed() {
        return this.sto.isDistributed();
    }

    @Override
    public boolean isArrayBased() {
        return this.sto.isArrayBased();
    }

    @Override
    public double[] data() {
        return this.isArrayBased() ? this.sto.data() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PivotedVectorStorage that = (PivotedVectorStorage)o;
        return (this.sto != null ? this.sto.equals(that.sto) : that.sto == null) && Arrays.equals(this.pivot, that.pivot) && Arrays.equals(this.unpivot, that.unpivot);
    }

    public int hashCode() {
        int res = this.sto != null ? this.sto.hashCode() : 0;
        res = 31 * res + Arrays.hashCode(this.pivot);
        res = 31 * res + Arrays.hashCode(this.unpivot);
        return res;
    }
}

