/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.functions.IntDoubleToVoidFunction;

public class FunctionVectorStorage
implements VectorStorage {
    private IgniteFunction<Integer, Double> getFunc;
    private IntDoubleToVoidFunction setFunc;
    private int size;

    public FunctionVectorStorage() {
    }

    public FunctionVectorStorage(int size, IgniteFunction<Integer, Double> getFunc, IntDoubleToVoidFunction setFunc) {
        assert (size > 0);
        assert (getFunc != null);
        this.size = size;
        this.getFunc = getFunc;
        this.setFunc = setFunc;
    }

    public IgniteFunction<Integer, Double> getFunction() {
        return this.getFunc;
    }

    public IntDoubleToVoidFunction setFunction() {
        return this.setFunc;
    }

    public FunctionVectorStorage(int size, IgniteFunction<Integer, Double> getFunc) {
        this(size, getFunc, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        return (Double)this.getFunc.apply(i);
    }

    @Override
    public void set(int i, double v) {
        if (this.setFunc == null) {
            throw new UnsupportedOperationException("Cannot set into read-only vector.");
        }
        this.setFunc.accept(i, v);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.setFunc);
        out.writeObject(this.getFunc);
        out.writeInt(this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setFunc = (IntDoubleToVoidFunction)in.readObject();
        this.getFunc = (IgniteFunction)in.readObject();
        this.size = in.readInt();
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return false;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }
}

