/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.matrix;

import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleRBTreeMap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.ml.math.MatrixStorage;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.distributed.CacheUtils;
import org.apache.ignite.ml.math.distributed.DistributedStorage;
import org.apache.ignite.ml.math.distributed.keys.RowColMatrixKey;
import org.apache.ignite.ml.math.distributed.keys.impl.SparseMatrixKey;

public class SparseDistributedMatrixStorage
extends CacheUtils
implements MatrixStorage,
StorageConstants,
DistributedStorage<RowColMatrixKey> {
    private static final String CACHE_NAME = "ML_SPARSE_MATRICES_CONTAINER";
    private int rows;
    private int cols;
    private int stoMode;
    private int acsMode;
    private UUID uuid;
    private IgniteCache<RowColMatrixKey, Map<Integer, Double>> cache = null;

    public SparseDistributedMatrixStorage() {
    }

    public SparseDistributedMatrixStorage(int rows, int cols, int stoMode, int acsMode) {
        assert (rows > 0);
        assert (cols > 0);
        this.assertAccessMode(acsMode);
        this.assertStorageMode(stoMode);
        this.rows = rows;
        this.cols = cols;
        this.stoMode = stoMode;
        this.acsMode = acsMode;
        this.cache = this.newCache();
        this.uuid = UUID.randomUUID();
    }

    private IgniteCache<RowColMatrixKey, Map<Integer, Double>> newCache() {
        CacheConfiguration cfg = new CacheConfiguration();
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.PRIMARY_SYNC);
        cfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        cfg.setEvictionPolicy(null);
        cfg.setCopyOnRead(false);
        cfg.setCacheMode(CacheMode.PARTITIONED);
        cfg.setName(CACHE_NAME);
        return Ignition.localIgnite().getOrCreateCache(cfg);
    }

    public IgniteCache<RowColMatrixKey, Map<Integer, Double>> cache() {
        return this.cache;
    }

    @Override
    public int accessMode() {
        return this.acsMode;
    }

    @Override
    public double get(int x, int y) {
        if (this.stoMode == 2001) {
            return this.matrixGet(x, y);
        }
        return this.matrixGet(y, x);
    }

    @Override
    public void set(int x, int y, double v) {
        if (this.stoMode == 2001) {
            this.matrixSet(x, y, v);
        } else {
            this.matrixSet(y, x, v);
        }
    }

    private double matrixGet(int a, int b) {
        return (Double)SparseDistributedMatrixStorage.ignite().compute(SparseDistributedMatrixStorage.getClusterGroupForGivenKey(CACHE_NAME, a)).call((IgniteCallable & Serializable)() -> {
            IgniteCache cache = Ignition.localIgnite().getOrCreateCache(CACHE_NAME);
            Map map = (Map)cache.localPeek((Object)this.getCacheKey(a), new CachePeekMode[]{CachePeekMode.PRIMARY});
            if (map == null) {
                map = (Map)cache.get((Object)this.getCacheKey(a));
            }
            return map == null || !map.containsKey(b) ? Double.valueOf(0.0) : (Double)map.get(b);
        });
    }

    private void matrixSet(int a, int b, double v) {
        SparseDistributedMatrixStorage.ignite().compute(SparseDistributedMatrixStorage.getClusterGroupForGivenKey(CACHE_NAME, a)).run((IgniteRunnable & Serializable)() -> {
            IgniteCache cache = Ignition.localIgnite().getOrCreateCache(CACHE_NAME);
            Map map = (Map)cache.localPeek((Object)this.getCacheKey(a), new CachePeekMode[]{CachePeekMode.PRIMARY});
            if (map == null && (map = (Map)cache.get((Object)this.getCacheKey(a))) == null) {
                Object object = map = this.acsMode == 1001 ? new Int2DoubleRBTreeMap() : new Int2DoubleOpenHashMap();
            }
            if (v != 0.0) {
                map.put(b, v);
            } else if (map.containsKey(b)) {
                map.remove(b);
            }
            cache.put((Object)this.getCacheKey(a), (Object)map);
        });
    }

    public RowColMatrixKey getCacheKey(int idx) {
        return new SparseMatrixKey(idx, this.uuid, idx);
    }

    @Override
    public int columnSize() {
        return this.cols;
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public int storageMode() {
        return this.stoMode;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.cols);
        out.writeInt(this.acsMode);
        out.writeInt(this.stoMode);
        out.writeObject(this.uuid);
        out.writeUTF(this.cache.getName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.cols = in.readInt();
        this.acsMode = in.readInt();
        this.stoMode = in.readInt();
        this.uuid = (UUID)in.readObject();
        this.cache = SparseDistributedMatrixStorage.ignite().getOrCreateCache(in.readUTF());
    }

    @Override
    public boolean isSequentialAccess() {
        return this.acsMode == 1001;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return this.acsMode == 1002;
    }

    @Override
    public boolean isDistributed() {
        return true;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public void destroy() {
        Set keyset = IntStream.range(0, this.rows).mapToObj(this::getCacheKey).collect(Collectors.toSet());
        this.cache.clearAll(keyset);
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.cols;
        res = res * 37 + this.rows;
        res = res * 37 + this.acsMode;
        res = res * 37 + this.stoMode;
        res = res * 37 + this.uuid.hashCode();
        res = res * 37 + this.cache.hashCode();
        return res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SparseDistributedMatrixStorage that = (SparseDistributedMatrixStorage)obj;
        return this.rows == that.rows && this.cols == that.cols && this.acsMode == that.acsMode && this.stoMode == that.stoMode && this.uuid.equals(that.uuid) && (this.cache != null ? this.cache.equals(that.cache) : that.cache == null);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Set<RowColMatrixKey> getAllKeys() {
        int range = this.stoMode == 2001 ? this.rows : this.cols;
        return IntStream.range(0, range).mapToObj(i -> new SparseMatrixKey(i, this.getUUID(), i)).collect(Collectors.toSet());
    }

    @Override
    public String cacheName() {
        return CACHE_NAME;
    }
}

