/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.ignite.ml.math.MatrixStorage;

public class PivotedMatrixStorage
implements MatrixStorage {
    private MatrixStorage sto;
    private int[] rowPivot;
    private int[] colPivot;
    private int[] rowUnpivot;
    private int[] colUnpivot;

    public PivotedMatrixStorage() {
    }

    public PivotedMatrixStorage(MatrixStorage sto, int[] rowPivot, int[] colPivot) {
        assert (sto != null);
        assert (rowPivot != null);
        assert (colPivot != null);
        this.sto = sto;
        this.rowPivot = rowPivot;
        this.colPivot = colPivot;
        this.rowUnpivot = PivotedMatrixStorage.invert(rowPivot);
        this.colUnpivot = PivotedMatrixStorage.invert(colPivot);
    }

    public int[] rowPivot() {
        return this.rowPivot;
    }

    public int[] columnPivot() {
        return this.colPivot;
    }

    public int[] rowUnpivot() {
        return this.rowUnpivot;
    }

    public int[] columnUnpivot() {
        return this.colUnpivot;
    }

    public PivotedMatrixStorage(MatrixStorage sto, int[] pivot) {
        this(sto, pivot, pivot == null ? null : Arrays.copyOf(pivot, pivot.length));
    }

    public PivotedMatrixStorage(MatrixStorage sto) {
        this(sto, sto == null ? null : PivotedMatrixStorage.identityPivot(sto.rowSize()), sto == null ? null : PivotedMatrixStorage.identityPivot(sto.columnSize()));
    }

    public void swapRows(int i, int j) {
        if (i != j) {
            int tmp = this.rowPivot[i];
            this.rowPivot[i] = this.rowPivot[j];
            this.rowPivot[j] = tmp;
            this.rowUnpivot[this.rowPivot[i]] = i;
            this.rowUnpivot[this.rowPivot[j]] = j;
        }
    }

    public void swapColumns(int i, int j) {
        if (i != j) {
            int tmp = this.colPivot[i];
            this.colPivot[i] = this.colPivot[j];
            this.colPivot[j] = tmp;
            this.colUnpivot[this.colPivot[i]] = i;
            this.colUnpivot[this.colPivot[j]] = j;
        }
    }

    @Override
    public double get(int x, int y) {
        return this.sto.get(this.rowPivot[x], this.colPivot[y]);
    }

    @Override
    public void set(int x, int y, double v) {
        this.sto.set(this.rowPivot[x], this.colPivot[y], v);
    }

    @Override
    public int columnSize() {
        return this.sto.columnSize();
    }

    @Override
    public int rowSize() {
        return this.sto.rowSize();
    }

    @Override
    public int storageMode() {
        return this.sto.storageMode();
    }

    @Override
    public int accessMode() {
        return this.sto.accessMode();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sto);
        out.writeObject(this.rowPivot);
        out.writeObject(this.colPivot);
        out.writeObject(this.rowUnpivot);
        out.writeObject(this.colUnpivot);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sto = (MatrixStorage)in.readObject();
        this.rowPivot = (int[])in.readObject();
        this.colPivot = (int[])in.readObject();
        this.rowUnpivot = (int[])in.readObject();
        this.colUnpivot = (int[])in.readObject();
    }

    @Override
    public boolean isSequentialAccess() {
        return this.sto.isSequentialAccess();
    }

    @Override
    public boolean isDense() {
        return this.sto.isDense();
    }

    @Override
    public boolean isRandomAccess() {
        return this.sto.isRandomAccess();
    }

    @Override
    public boolean isDistributed() {
        return this.sto.isDistributed();
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.sto.hashCode();
        res = res * 37 + Arrays.hashCode(this.rowPivot);
        res = res * 37 + Arrays.hashCode(this.rowUnpivot);
        res = res * 37 + Arrays.hashCode(this.colPivot);
        res = res * 37 + Arrays.hashCode(this.colUnpivot);
        return res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PivotedMatrixStorage that = (PivotedMatrixStorage)obj;
        return Arrays.equals(this.rowPivot, that.rowPivot) && Arrays.equals(this.rowUnpivot, that.rowUnpivot) && Arrays.equals(this.colPivot, that.colPivot) && Arrays.equals(this.colUnpivot, that.colUnpivot) && (this.sto != null ? this.sto.equals(that.sto) : that.sto == null);
    }

    private static int[] identityPivot(int n) {
        int[] pivot = new int[n];
        for (int i = 0; i < n; ++i) {
            pivot[i] = i;
        }
        return pivot;
    }

    private static int[] invert(int[] pivot) {
        int[] x = new int[pivot.length];
        for (int i = 0; i < pivot.length; ++i) {
            x[pivot[i]] = i;
        }
        return x;
    }
}

