/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.MatrixStorage;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;

public class DiagonalMatrixStorage
implements MatrixStorage {
    private Vector diagonal;

    public DiagonalMatrixStorage() {
    }

    public DiagonalMatrixStorage(Vector diagonal) {
        assert (diagonal != null);
        this.diagonal = diagonal;
    }

    public Vector diagonal() {
        return this.diagonal;
    }

    @Override
    public double get(int x, int y) {
        return x == y ? this.diagonal.get(x) : 0.0;
    }

    @Override
    public void set(int x, int y, double v) {
        if (x != y) {
            throw new UnsupportedOperationException("Can't set off-diagonal element.");
        }
        this.diagonal.set(x, v);
    }

    @Override
    public int columnSize() {
        return this.diagonal.size();
    }

    @Override
    public int rowSize() {
        return this.diagonal.size();
    }

    @Override
    public int storageMode() {
        return 3001;
    }

    @Override
    public int accessMode() {
        return 1002;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.diagonal);
    }

    @Override
    public double[] data() {
        int size = this.diagonal.size();
        double[] res = new double[size * size];
        for (int i = 0; i < size; ++i) {
            res[i * size + i % size] = this.diagonal.getX(i);
        }
        return res;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.diagonal = (Vector)in.readObject();
    }

    @Override
    public boolean isSequentialAccess() {
        return this.diagonal.isSequentialAccess();
    }

    @Override
    public boolean isDense() {
        return this.diagonal.isDense();
    }

    @Override
    public boolean isRandomAccess() {
        return this.diagonal.isRandomAccess();
    }

    @Override
    public boolean isDistributed() {
        return this.diagonal.isDistributed();
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.diagonal.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagonalMatrixStorage that = (DiagonalMatrixStorage)o;
        return this.diagonal.equals(that.diagonal);
    }
}

