/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.ml.math.MatrixStorage;

public class DenseOffHeapMatrixStorage
implements MatrixStorage {
    private int rows;
    private int cols;
    private transient long ptr;
    private int ptrInitHash;

    public DenseOffHeapMatrixStorage() {
    }

    public DenseOffHeapMatrixStorage(int rows, int cols) {
        assert (rows > 0);
        assert (cols > 0);
        this.rows = rows;
        this.cols = cols;
        this.allocateMemory(rows, cols);
    }

    public DenseOffHeapMatrixStorage(double[][] data) {
        assert (data != null);
        assert (data[0] != null);
        this.rows = data.length;
        this.cols = data[0].length;
        assert (this.rows > 0);
        assert (this.cols > 0);
        this.allocateMemory(this.rows, this.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.set(i, j, data[i][j]);
            }
        }
    }

    @Override
    public double get(int x, int y) {
        return GridUnsafe.getDouble((long)this.pointerOffset(x, y));
    }

    @Override
    public void set(int x, int y, double v) {
        GridUnsafe.putDouble((long)this.pointerOffset(x, y), (double)v);
    }

    @Override
    public int columnSize() {
        return this.cols;
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public int storageMode() {
        return 2001;
    }

    @Override
    public int accessMode() {
        return 1002;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public double[] data() {
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.cols);
        out.writeInt(this.ptrInitHash);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                out.writeDouble(this.get(i, j));
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.cols = in.readInt();
        this.allocateMemory(this.rows, this.cols);
        this.ptrInitHash = in.readInt();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.set(i, j, in.readDouble());
            }
        }
    }

    @Override
    public void destroy() {
        GridUnsafe.freeMemory((long)this.ptr);
    }

    private long pointerOffset(int x, int y) {
        return this.ptr + (long)(x * this.cols * 8) + (long)(y * 8);
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass()) && this.rows == ((DenseOffHeapMatrixStorage)obj).rows && this.cols == ((DenseOffHeapMatrixStorage)obj).cols && (this.rows == 0 || this.cols == 0 || this.ptr == ((DenseOffHeapMatrixStorage)obj).ptr || this.isMemoryEquals((DenseOffHeapMatrixStorage)obj));
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.rows;
        res = res * 37 + this.cols;
        res = res * 37 + this.ptrInitHash;
        return res;
    }

    private boolean isMemoryEquals(DenseOffHeapMatrixStorage otherStorage) {
        boolean res = true;
        block0: for (int i = 0; i < otherStorage.rows; ++i) {
            for (int j = 0; j < otherStorage.cols; ++j) {
                if (Double.compare(this.get(i, j), otherStorage.get(i, j)) == 0) continue;
                res = false;
                continue block0;
            }
        }
        return res;
    }

    private void allocateMemory(int rows, int cols) {
        this.ptr = GridUnsafe.allocateMemory((long)((long)rows * (long)cols * 8L));
        this.ptrInitHash = Long.hashCode(this.ptr);
    }
}

