/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.ml.math.MatrixStorage;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.distributed.CacheUtils;
import org.apache.ignite.ml.math.distributed.DistributedStorage;
import org.apache.ignite.ml.math.distributed.keys.impl.MatrixBlockKey;
import org.apache.ignite.ml.math.impls.matrix.MatrixBlockEntry;

public class BlockMatrixStorage
extends CacheUtils
implements MatrixStorage,
StorageConstants,
DistributedStorage<MatrixBlockKey> {
    private static final String CACHE_NAME = "ML_BLOCK_SPARSE_MATRICES_CONTAINER";
    private int blocksInCol;
    private int blocksInRow;
    private int rows;
    private int cols;
    private UUID uuid;
    private int maxBlockEdge = 32;
    private IgniteCache<MatrixBlockKey, MatrixBlockEntry> cache = null;

    public BlockMatrixStorage() {
    }

    public BlockMatrixStorage(int rows, int cols) {
        assert (rows > 0);
        assert (cols > 0);
        this.rows = rows;
        this.cols = cols;
        this.blocksInRow = rows % this.maxBlockEdge == 0 ? rows / this.maxBlockEdge : rows / this.maxBlockEdge + 1;
        this.blocksInCol = cols % this.maxBlockEdge == 0 ? cols / this.maxBlockEdge : cols / this.maxBlockEdge + 1;
        this.cache = this.newCache();
        this.uuid = UUID.randomUUID();
    }

    public IgniteCache<MatrixBlockKey, MatrixBlockEntry> cache() {
        return this.cache;
    }

    @Override
    public double get(int x, int y) {
        return this.matrixGet(x, y);
    }

    @Override
    public void set(int x, int y, double v) {
        this.matrixSet(x, y, v);
    }

    @Override
    public int columnSize() {
        return this.cols;
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public int storageMode() {
        return 3001;
    }

    @Override
    public int accessMode() {
        return 1002;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.cols);
        out.writeInt(this.blocksInRow);
        out.writeInt(this.blocksInCol);
        out.writeObject(this.uuid);
        out.writeUTF(this.cache.getName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.cols = in.readInt();
        this.blocksInRow = in.readInt();
        this.blocksInCol = in.readInt();
        this.uuid = (UUID)in.readObject();
        this.cache = BlockMatrixStorage.ignite().getOrCreateCache(in.readUTF());
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return true;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public void destroy() {
        this.cache.clearAll(this.getAllKeys());
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public MatrixBlockKey getCacheKey(long blockIdRow, long blockIdCol) {
        return new MatrixBlockKey(blockIdRow, blockIdCol, this.uuid, this.getAffinityKey(blockIdRow, blockIdCol));
    }

    private MatrixBlockKey getCacheKey(IgnitePair<Long> blockId) {
        return new MatrixBlockKey((Long)blockId.get1(), (Long)blockId.get2(), this.uuid, this.getAffinityKey((Long)blockId.get1(), (Long)blockId.get2()));
    }

    @Override
    public Set<MatrixBlockKey> getAllKeys() {
        int maxRowIdx = this.rows - 1;
        int maxColIdx = this.cols - 1;
        IgnitePair<Long> maxBlockId = this.getBlockId(maxRowIdx, maxColIdx);
        HashSet<MatrixBlockKey> keyset = new HashSet<MatrixBlockKey>();
        int i = 0;
        while ((long)i <= (Long)maxBlockId.get1()) {
            int j = 0;
            while ((long)j <= (Long)maxBlockId.get2()) {
                keyset.add(this.getCacheKey(i, j));
                ++j;
            }
            ++i;
        }
        return keyset;
    }

    @Override
    public String cacheName() {
        return CACHE_NAME;
    }

    public List<MatrixBlockEntry> getRowForBlock(IgnitePair<Long> blockId) {
        LinkedList<MatrixBlockEntry> res = new LinkedList<MatrixBlockEntry>();
        for (int i = 0; i < this.blocksInCol; ++i) {
            res.add(this.getEntryById((IgnitePair<Long>)new IgnitePair(blockId.get1(), (Object)i)));
        }
        return res;
    }

    public List<MatrixBlockEntry> getColForBlock(IgnitePair<Long> blockId) {
        LinkedList<MatrixBlockEntry> res = new LinkedList<MatrixBlockEntry>();
        for (int i = 0; i < this.blocksInRow; ++i) {
            res.add(this.getEntryById((IgnitePair<Long>)new IgnitePair((Object)i, blockId.get2())));
        }
        return res;
    }

    public int hashCode() {
        int res = this.blocksInCol;
        res = 31 * res + this.blocksInRow;
        res = 31 * res + this.rows;
        res = 31 * res + this.cols;
        res = 31 * res + this.uuid.hashCode();
        res = 31 * res + this.maxBlockEdge;
        res = 31 * res + this.cache.getName().hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockMatrixStorage that = (BlockMatrixStorage)o;
        return this.blocksInCol == that.blocksInCol && this.blocksInRow == that.blocksInRow && this.rows == that.rows && this.cols == that.cols && this.maxBlockEdge == that.maxBlockEdge && this.uuid.equals(that.uuid) && this.cache.getName().equals(that.cache.getName());
    }

    private MatrixBlockEntry getEntryById(IgnitePair<Long> blockId) {
        MatrixBlockKey key = this.getCacheKey((Long)blockId.get1(), (Long)blockId.get2());
        MatrixBlockEntry entry = (MatrixBlockEntry)this.cache.localPeek((Object)key, new CachePeekMode[]{CachePeekMode.PRIMARY});
        MatrixBlockEntry matrixBlockEntry = entry = entry != null ? entry : (MatrixBlockEntry)this.cache.get((Object)key);
        if (entry == null) {
            entry = this.getEmptyBlockEntry(blockId);
        }
        return entry;
    }

    private MatrixBlockEntry getEmptyBlockEntry(IgnitePair<Long> blockId) {
        int rowSize;
        int rowMod = this.rows % this.maxBlockEdge;
        int colMod = this.cols % this.maxBlockEdge;
        if (rowMod == 0) {
            rowSize = this.maxBlockEdge;
        } else {
            int n = rowSize = (Long)blockId.get1() != (long)(this.blocksInRow - 1) ? this.maxBlockEdge : rowMod;
        }
        int colSize = colMod == 0 ? this.maxBlockEdge : ((Long)blockId.get2() != (long)(this.blocksInCol - 1) ? this.maxBlockEdge : colMod);
        MatrixBlockEntry entry = new MatrixBlockEntry(rowSize, colSize);
        return entry;
    }

    private UUID getAffinityKey(long blockIdRow, long blockIdCol) {
        return null;
    }

    private void matrixSet(int a, int b, double v) {
        IgnitePair<Long> blockId = this.getBlockId(a, b);
        BlockMatrixStorage.ignite().compute(BlockMatrixStorage.getClusterGroupForGivenKey(CACHE_NAME, blockId)).run((IgniteRunnable & Serializable)() -> {
            IgniteCache cache = Ignition.localIgnite().getOrCreateCache(CACHE_NAME);
            MatrixBlockKey key = this.getCacheKey((Long)blockId.get1(), (Long)blockId.get2());
            MatrixBlockEntry block = this.getEntryById(blockId);
            block.set(a % block.rowSize(), b % block.columnSize(), v);
            cache.put((Object)key, (Object)block);
        });
    }

    private IgnitePair<Long> getBlockId(int x, int y) {
        return new IgnitePair((Object)((long)x / (long)this.maxBlockEdge), (Object)((long)y / (long)this.maxBlockEdge));
    }

    private double matrixGet(int a, int b) {
        return (Double)BlockMatrixStorage.ignite().compute(BlockMatrixStorage.getClusterGroupForGivenKey(CACHE_NAME, this.getBlockId(a, b))).call((IgniteCallable & Serializable)() -> {
            MatrixBlockKey key;
            IgniteCache cache = Ignition.localIgnite().getOrCreateCache(CACHE_NAME);
            MatrixBlockEntry block = (MatrixBlockEntry)cache.localPeek((Object)(key = this.getCacheKey(this.getBlockId(a, b))), new CachePeekMode[]{CachePeekMode.PRIMARY});
            if (block == null) {
                block = (MatrixBlockEntry)cache.get((Object)key);
            }
            return block == null ? 0.0 : block.get(a % block.rowSize(), b % block.columnSize());
        });
    }

    private IgniteCache<MatrixBlockKey, MatrixBlockEntry> newCache() {
        CacheConfiguration cfg = new CacheConfiguration();
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.PRIMARY_SYNC);
        cfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        cfg.setEvictionPolicy(null);
        cfg.setCopyOnRead(false);
        cfg.setCacheMode(CacheMode.PARTITIONED);
        cfg.setName(CACHE_NAME);
        return Ignition.localIgnite().getOrCreateCache(cfg);
    }
}

