/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.distributed.CacheUtils;
import org.apache.ignite.ml.math.exceptions.CardinalityException;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.impls.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.impls.matrix.MatrixBlockEntry;
import org.apache.ignite.ml.math.impls.storage.matrix.BlockMatrixStorage;
import org.apache.ignite.ml.math.impls.storage.matrix.BlockVectorStorage;
import org.apache.ignite.ml.math.impls.vector.SparseBlockDistributedVector;
import org.apache.ignite.ml.math.impls.vector.VectorBlockEntry;

public class SparseBlockDistributedMatrix
extends AbstractMatrix
implements StorageConstants {
    public SparseBlockDistributedMatrix() {
    }

    public SparseBlockDistributedMatrix(int rows, int cols) {
        assert (rows > 0);
        assert (cols > 0);
        this.setStorage(new BlockMatrixStorage(rows, cols));
    }

    public SparseBlockDistributedMatrix(double[][] data) {
        assert (data.length > 0);
        this.setStorage(new BlockMatrixStorage(data.length, this.getMaxAmountOfColumns(data)));
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                this.storage().set(i, j, data[i][j]);
            }
        }
    }

    @Override
    public Matrix divide(double d) {
        return this.mapOverValues(v -> v / d);
    }

    @Override
    public Matrix plus(double x) {
        return this.mapOverValues(v -> v + x);
    }

    @Override
    public Matrix times(double x) {
        return this.mapOverValues(v -> v * x);
    }

    @Override
    public Matrix times(Matrix mtx) {
        if (mtx == null) {
            throw new IllegalArgumentException("The matrix should be not null.");
        }
        if (this.columnSize() != mtx.rowSize()) {
            throw new CardinalityException(this.columnSize(), mtx.rowSize());
        }
        SparseBlockDistributedMatrix matrixA = this;
        SparseBlockDistributedMatrix matrixB = (SparseBlockDistributedMatrix)mtx;
        String cacheName = this.storage().cacheName();
        SparseBlockDistributedMatrix matrixC = new SparseBlockDistributedMatrix(matrixA.rowSize(), matrixB.columnSize());
        CacheUtils.bcast(cacheName, (IgniteRunnable & Serializable)() -> {
            Ignite ignite = Ignition.localIgnite();
            Affinity affinity = ignite.affinity(cacheName);
            IgniteCache cache = ignite.getOrCreateCache(cacheName);
            ClusterNode locNode = ignite.cluster().localNode();
            BlockMatrixStorage storageC = matrixC.storage();
            Map keysCToNodes = affinity.mapKeysToNodes(storageC.getAllKeys());
            Collection locKeys = (Collection)keysCToNodes.get(locNode);
            if (locKeys == null) {
                return;
            }
            locKeys.forEach(key -> {
                long newBlockIdRow = key.blockRowId();
                long newBlockIdCol = key.blockColId();
                IgnitePair newBlockId = new IgnitePair((Object)newBlockIdRow, (Object)newBlockIdCol);
                MatrixBlockEntry blockC = null;
                List<MatrixBlockEntry> aRow = matrixA.storage().getRowForBlock((IgnitePair<Long>)newBlockId);
                List<MatrixBlockEntry> bCol = matrixB.storage().getColForBlock((IgnitePair<Long>)newBlockId);
                for (int i = 0; i < aRow.size(); ++i) {
                    MatrixBlockEntry blockA = aRow.get(i);
                    MatrixBlockEntry blockB = bCol.get(i);
                    MatrixBlockEntry tmpBlock = new MatrixBlockEntry(blockA.times(blockB));
                    blockC = blockC == null ? tmpBlock : new MatrixBlockEntry(blockC.plus(tmpBlock));
                }
                cache.put((Object)storageC.getCacheKey(newBlockIdRow, newBlockIdCol), blockC);
            });
        });
        return matrixC;
    }

    @Override
    public Vector times(Vector vec) {
        if (vec == null) {
            throw new IllegalArgumentException("The vector should be not null.");
        }
        if (this.columnSize() != vec.size()) {
            throw new CardinalityException(this.columnSize(), vec.size());
        }
        SparseBlockDistributedMatrix matrixA = this;
        SparseBlockDistributedVector vectorB = (SparseBlockDistributedVector)vec;
        String cacheName = this.storage().cacheName();
        SparseBlockDistributedVector vectorC = new SparseBlockDistributedVector(matrixA.rowSize());
        CacheUtils.bcast(cacheName, (IgniteRunnable & Serializable)() -> {
            Ignite ignite = Ignition.localIgnite();
            Affinity affinity = ignite.affinity(cacheName);
            IgniteCache cache = ignite.getOrCreateCache(cacheName);
            ClusterNode locNode = ignite.cluster().localNode();
            BlockVectorStorage storageC = vectorC.storage();
            Map keysCToNodes = affinity.mapKeysToNodes(storageC.getAllKeys());
            Collection locKeys = (Collection)keysCToNodes.get(locNode);
            if (locKeys == null) {
                return;
            }
            locKeys.forEach(key -> {
                long newBlockId = key.blockId();
                IgnitePair newBlockIdForMtx = new IgnitePair((Object)newBlockId, (Object)0L);
                VectorBlockEntry blockC = null;
                List<MatrixBlockEntry> aRow = matrixA.storage().getRowForBlock((IgnitePair<Long>)newBlockIdForMtx);
                List<VectorBlockEntry> bCol = vectorB.storage().getColForBlock(newBlockId);
                for (int i = 0; i < aRow.size(); ++i) {
                    MatrixBlockEntry blockA = aRow.get(i);
                    VectorBlockEntry blockB = bCol.get(i);
                    VectorBlockEntry tmpBlock = new VectorBlockEntry(blockA.times(blockB));
                    blockC = blockC == null ? tmpBlock : new VectorBlockEntry(blockC.plus(tmpBlock));
                }
                cache.put((Object)storageC.getCacheKey(newBlockId), blockC);
            });
        });
        return vectorC;
    }

    @Override
    public Vector getCol(int col) {
        this.checkColumnIndex(col);
        SparseBlockDistributedVector res = new SparseBlockDistributedVector(this.rowSize());
        for (int i = 0; i < this.rowSize(); ++i) {
            res.setX(i, this.getX(i, col));
        }
        return res;
    }

    @Override
    public Vector getRow(int row) {
        this.checkRowIndex(row);
        SparseBlockDistributedVector res = new SparseBlockDistributedVector(this.columnSize());
        for (int i = 0; i < this.columnSize(); ++i) {
            res.setX(i, this.getX(row, i));
        }
        return res;
    }

    @Override
    public Matrix assign(double val) {
        return this.mapOverValues(v -> val);
    }

    @Override
    public Matrix map(IgniteDoubleFunction<Double> fun) {
        return this.mapOverValues(fun);
    }

    @Override
    public double sum() {
        return CacheUtils.sparseSum(this.getUUID(), this.storage().cacheName());
    }

    @Override
    public double maxValue() {
        return CacheUtils.sparseMax(this.getUUID(), this.storage().cacheName());
    }

    @Override
    public double minValue() {
        return CacheUtils.sparseMin(this.getUUID(), this.storage().cacheName());
    }

    @Override
    public Matrix copy() {
        Matrix cp = this.like(this.rowSize(), this.columnSize());
        cp.assign(this);
        return cp;
    }

    @Override
    public Matrix like(int rows, int cols) {
        return new SparseBlockDistributedMatrix(rows, cols);
    }

    @Override
    public Vector likeVector(int crd) {
        return new SparseBlockDistributedVector(crd);
    }

    private UUID getUUID() {
        return ((BlockMatrixStorage)this.getStorage()).getUUID();
    }

    private Matrix mapOverValues(IgniteDoubleFunction<Double> mapper) {
        CacheUtils.sparseMap(this.getUUID(), mapper, this.storage().cacheName());
        return this;
    }

    private BlockMatrixStorage storage() {
        return (BlockMatrixStorage)this.getStorage();
    }
}

