/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.decompositions;

import org.apache.ignite.ml.math.Destroyable;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.decompositions.QRDSolver;
import org.apache.ignite.ml.math.exceptions.SingularMatrixException;
import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class QRDecomposition
implements Destroyable {
    private final Matrix q;
    private final Matrix r;
    private final Matrix mType;
    private final boolean fullRank;
    private final int rows;
    private final int cols;

    private void checkDouble(double v) {
        if (Double.isInfinite(v) || Double.isNaN(v)) {
            throw new ArithmeticException("Invalid intermediate result");
        }
    }

    public QRDecomposition(Matrix mtx) {
        this(mtx, 0.0);
    }

    public QRDecomposition(Matrix mtx, double threshold) {
        assert (mtx != null);
        this.rows = mtx.rowSize();
        int min = Math.min(mtx.rowSize(), mtx.columnSize());
        this.cols = mtx.columnSize();
        this.mType = MatrixUtil.like(mtx, 1, 1);
        Matrix qTmp = MatrixUtil.copy(mtx);
        boolean fullRank = true;
        this.r = MatrixUtil.like(mtx, min, this.cols);
        for (int i = 0; i < min; ++i) {
            Vector qi = qTmp.viewColumn(i);
            double alpha = qi.kNorm(2.0);
            if (Math.abs(alpha) > Double.MIN_VALUE) {
                qi.map(Functions.div(alpha));
            } else {
                this.checkDouble(alpha);
                fullRank = false;
            }
            this.r.set(i, i, alpha);
            for (int j = i + 1; j < this.cols; ++j) {
                Vector qj = qTmp.viewColumn(j);
                double norm = qj.kNorm(2.0);
                if (Math.abs(norm) > Double.MIN_VALUE) {
                    double beta = qi.dot(qj);
                    this.r.set(i, j, beta);
                    if (j >= min) continue;
                    qj.map(qi, Functions.plusMult(-beta));
                    continue;
                }
                this.checkDouble(norm);
            }
        }
        this.q = this.cols > min ? qTmp.viewPart(0, this.rows, 0, min).copy() : qTmp;
        this.verifyNonSingularR(threshold);
        this.fullRank = fullRank;
    }

    @Override
    public void destroy() {
        this.q.destroy();
        this.r.destroy();
        this.mType.destroy();
    }

    public Matrix getQ() {
        return this.q;
    }

    public Matrix getR() {
        return this.r;
    }

    public boolean hasFullRank() {
        return this.fullRank;
    }

    public Matrix solve(Matrix mtx) {
        return new QRDSolver(this.q, this.r).solve(mtx);
    }

    public Vector solve(Vector vec) {
        return new QRDSolver(this.q, this.r).solve(vec);
    }

    public String toString() {
        return String.format("QR(%d x %d, fullRank=%s)", this.rows, this.cols, this.hasFullRank());
    }

    private void verifyNonSingularR(double min) {
        int len = this.r.columnSize() > this.r.rowSize() ? this.r.rowSize() : this.r.columnSize();
        for (int i = 0; i < len; ++i) {
            double d = this.r.getX(i, i);
            if (!(Math.abs(d) <= min)) continue;
            throw new SingularMatrixException("Number is too small (%f, while threshold is %f). Index of diagonal element is (%d, %d)", d, min, i, i);
        }
    }
}

