/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.decompositions;

import org.apache.ignite.ml.math.Destroyable;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.impls.matrix.CacheMatrix;
import org.apache.ignite.ml.math.impls.matrix.DenseLocalOnHeapMatrix;
import org.apache.ignite.ml.math.impls.matrix.PivotedMatrixView;
import org.apache.ignite.ml.math.impls.matrix.RandomMatrix;
import org.apache.ignite.ml.math.impls.vector.DenseLocalOnHeapVector;

public abstract class DecompositionSupport
implements Destroyable {
    protected Matrix like(Matrix matrix) {
        if (this.isCopyLikeSupport(matrix)) {
            return new DenseLocalOnHeapMatrix(matrix.rowSize(), matrix.columnSize());
        }
        return matrix.like(matrix.rowSize(), matrix.columnSize());
    }

    protected Matrix like(Matrix matrix, int rows, int cols) {
        if (this.isCopyLikeSupport(matrix)) {
            return new DenseLocalOnHeapMatrix(rows, cols);
        }
        return matrix.like(rows, cols);
    }

    protected Vector likeVector(Matrix matrix, int crd) {
        if (this.isCopyLikeSupport(matrix)) {
            return new DenseLocalOnHeapVector(crd);
        }
        return matrix.likeVector(crd);
    }

    protected Vector likeVector(Matrix matrix) {
        return this.likeVector(matrix, matrix.rowSize());
    }

    protected Matrix copy(Matrix matrix) {
        if (this.isCopyLikeSupport(matrix)) {
            DenseLocalOnHeapMatrix cp = new DenseLocalOnHeapMatrix(matrix.rowSize(), matrix.columnSize());
            cp.assign(matrix);
            return cp;
        }
        return matrix.copy();
    }

    private boolean isCopyLikeSupport(Matrix matrix) {
        return matrix instanceof RandomMatrix || matrix instanceof PivotedMatrixView || matrix instanceof CacheMatrix;
    }
}

