/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MurmurHash {
    private MurmurHash() {
    }

    public static int hash3X86(byte[] data, int off, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = off + (len & 0xFFFFFFFC);
        for (int i = off; i < roundedEnd; i += 4) {
            int k1 = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
            k1 *= c1;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= c2);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= c1;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static int hash(int data, int seed) {
        byte[] arr = new byte[]{(byte)(data >>> 24), (byte)(data >>> 16), (byte)(data >>> 8), (byte)data};
        return MurmurHash.hash(ByteBuffer.wrap(arr), seed);
    }

    public static int hash(byte[] data, int seed) {
        return MurmurHash.hash(ByteBuffer.wrap(data), seed);
    }

    public static int hash(byte[] data, int off, int len, int seed) {
        return MurmurHash.hash(ByteBuffer.wrap(data, off, len), seed);
    }

    public static int hash(ByteBuffer buf, int seed) {
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int m = 1540483477;
        int r = 24;
        int h = seed ^ buf.remaining();
        while (buf.remaining() >= 4) {
            int k = buf.getInt();
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h ^= finish.getInt();
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        buf.order(byteOrder);
        return h;
    }

    public static long hash64A(byte[] data, int seed) {
        return MurmurHash.hash64A(ByteBuffer.wrap(data), seed);
    }

    public static long hash64A(byte[] data, int off, int len, int seed) {
        return MurmurHash.hash64A(ByteBuffer.wrap(data, off, len), seed);
    }

    public static long hash64A(ByteBuffer buf, int seed) {
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long m = -4132994306676758123L;
        int r = 47;
        long h = (long)seed ^ (long)buf.remaining() * m;
        while (buf.remaining() >= 8) {
            long k = buf.getLong();
            k *= m;
            k ^= k >>> r;
            h ^= (k *= m);
            h *= m;
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h ^= finish.getLong();
            h *= m;
        }
        h ^= h >>> r;
        h *= m;
        h ^= h >>> r;
        buf.order(byteOrder);
        return h;
    }
}

