/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.ml.genetic.Chromosome;
import org.apache.ignite.ml.genetic.CrossOverTask;
import org.apache.ignite.ml.genetic.FitnessTask;
import org.apache.ignite.ml.genetic.Gene;
import org.apache.ignite.ml.genetic.MutateTask;
import org.apache.ignite.ml.genetic.TruncateSelectionTask;
import org.apache.ignite.ml.genetic.cache.GeneCacheConfig;
import org.apache.ignite.ml.genetic.cache.PopulationCacheConfig;
import org.apache.ignite.ml.genetic.parameter.GAConfiguration;
import org.apache.ignite.ml.genetic.parameter.GAGridConstants;

public class GAGrid {
    IgniteLogger igniteLogger = null;
    private GAConfiguration config = null;
    private Ignite ignite = null;
    private IgniteCache<Long, Chromosome> populationCache = null;
    private IgniteCache<Long, Gene> geneCache = null;
    private List<Long> populationKeys = new ArrayList<Long>();

    public GAGrid(GAConfiguration config, Ignite ignite) {
        this.ignite = ignite;
        this.config = config;
        this.ignite = ignite;
        this.igniteLogger = ignite.log();
        this.populationCache = this.ignite.getOrCreateCache(PopulationCacheConfig.populationCache());
        this.populationCache.clear();
        this.geneCache = this.ignite.getOrCreateCache(GeneCacheConfig.geneCache());
        this.geneCache.clear();
    }

    private Double calculateAverageFitness() {
        double avgFitnessScore = 0.0;
        IgniteCache cache = this.ignite.cache("populationCache");
        SqlFieldsQuery sql = new SqlFieldsQuery("select AVG(FITNESSSCORE) from Chromosome");
        try (FieldsQueryCursor cursor = cache.query(sql);){
            for (List row : cursor) {
                avgFitnessScore = (Double)row.get(0);
            }
        }
        return avgFitnessScore;
    }

    private void calculateFitness(List<Long> chromosomeKeys) {
        this.ignite.compute().execute((ComputeTask)new FitnessTask(this.config), chromosomeKeys);
    }

    private Boolean copyFitterChromosomesToPopulation(List<Long> fittestKeys, List<Long> selectedKeys) {
        double truncatePercentage = this.config.getTruncateRate();
        int totalSize = this.populationKeys.size();
        int truncateCount = (int)(truncatePercentage * (double)totalSize);
        int numberOfCopies = selectedKeys.size() / truncateCount;
        Boolean boolValue = (Boolean)this.ignite.compute().execute((ComputeTask)new TruncateSelectionTask(fittestKeys, numberOfCopies), selectedKeys);
        return boolValue;
    }

    private Chromosome createChromosome(int numberOfGenes) {
        long[] genes = new long[numberOfGenes];
        ArrayList<Long> keys = new ArrayList<Long>();
        int k = 0;
        while (k < numberOfGenes) {
            long key = this.selectGene(k);
            if (keys.contains(key)) continue;
            genes[k] = key;
            keys.add(key);
            ++k;
        }
        Chromosome aChromsome = new Chromosome(genes);
        return aChromsome;
    }

    private void crossover(List<Long> leastFitKeys) {
        this.ignite.compute().execute((ComputeTask)new CrossOverTask(this.config), leastFitKeys);
    }

    public Chromosome evolve() {
        int generationCount = 1;
        Chromosome fittestChomosome = null;
        this.initializeGenePopulation();
        this.intializePopulation();
        this.calculateFitness(this.populationKeys);
        List<Long> keys = this.getChromosomesByFittest();
        double averageFitnessScore = this.calculateAverageFitness();
        fittestChomosome = (Chromosome)this.populationCache.get((Object)keys.get(0));
        while (!this.config.getTerminateCriteria().isTerminationConditionMet(fittestChomosome, averageFitnessScore, generationCount)) {
            ++generationCount;
            List<Long> selectedKeysforCrossMutaton = this.selection(keys);
            this.crossover(selectedKeysforCrossMutaton);
            this.mutation(selectedKeysforCrossMutaton);
            this.calculateFitness(selectedKeysforCrossMutaton);
            keys = this.getChromosomesByFittest();
            fittestChomosome = (Chromosome)this.populationCache.get((Object)keys.get(0));
            averageFitnessScore = this.calculateAverageFitness();
        }
        return fittestChomosome;
    }

    private List<Long> getChromosomesByFittest() {
        ArrayList<Long> orderChromKeysByFittest = new ArrayList<Long>();
        String orderDirection = "desc";
        if (!this.config.isHigherFitnessValueFitter()) {
            orderDirection = "asc";
        }
        String fittestSQL = "select _key from Chromosome order by fitnessScore " + orderDirection;
        FieldsQueryCursor cursor = this.populationCache.query(new SqlFieldsQuery(fittestSQL));
        List res = cursor.getAll();
        for (List row : res) {
            Long key = (Long)row.get(0);
            orderChromKeysByFittest.add(key);
        }
        return orderChromKeysByFittest;
    }

    private List<Long> getFittestKeysForTruncation(List<Long> keys) {
        double truncatePercentage = this.config.getTruncateRate();
        int truncateCount = (int)(truncatePercentage * (double)keys.size());
        List<Long> selectedKeysToRetain = keys.subList(0, truncateCount);
        return selectedKeysToRetain;
    }

    void initializeGenePopulation() {
        this.geneCache.clear();
        List<Gene> genePool = this.config.getGenePool();
        for (Gene gene : genePool) {
            this.geneCache.put((Object)gene.id(), (Object)gene);
        }
    }

    void initializePopulation() {
        int populationSize = this.config.getPopulationSize();
        this.populationCache.clear();
        for (int j = 0; j < populationSize; ++j) {
            Chromosome chromosome = this.createChromosome(this.config.getChromosomeLength());
            this.populationCache.put((Object)chromosome.id(), (Object)chromosome);
            this.populationKeys.add(chromosome.id());
        }
    }

    void intializePopulation() {
        int populationSize = this.config.getPopulationSize();
        this.populationCache.clear();
        for (int j = 0; j < populationSize; ++j) {
            Chromosome chromosome = this.createChromosome(this.config.getChromosomeLength());
            this.populationCache.put((Object)chromosome.id(), (Object)chromosome);
            this.populationKeys.add(chromosome.id());
        }
    }

    private void mutation(List<Long> leastFitKeys) {
        this.ignite.compute().execute((ComputeTask)new MutateTask(this.config), leastFitKeys);
    }

    private long selectAnyGene() {
        int idx = this.selectRandomIndex(this.config.getGenePool().size());
        Gene gene = this.config.getGenePool().get(idx);
        return gene.id();
    }

    private List<Long> selectByElitism(List<Long> keys) {
        int elitismCount = this.config.getElitismCount();
        List<Long> leastFitKeys = keys.subList(elitismCount, keys.size());
        return leastFitKeys;
    }

    private List<Long> selectByTruncation(List<Long> keys) {
        double truncatePercentage = this.config.getTruncateRate();
        int truncateCount = (int)(truncatePercentage * (double)keys.size());
        List<Long> selectedKeysForCrossOver = keys.subList(truncateCount, keys.size());
        return selectedKeysForCrossOver;
    }

    private long selectGene(int k) {
        if (this.config.getChromosomeCriteria() == null) {
            return this.selectAnyGene();
        }
        return this.selectGeneByChromsomeCriteria(k);
    }

    private long selectGeneByChromsomeCriteria(int k) {
        ArrayList<Object> genes = new ArrayList<Object>();
        StringBuffer sbSqlClause = new StringBuffer("_val like '");
        sbSqlClause.append("%");
        sbSqlClause.append(this.config.getChromosomeCriteria().getCriteria().get(k));
        sbSqlClause.append("%'");
        IgniteCache cache = this.ignite.cache("geneCache");
        SqlQuery sql = new SqlQuery(Gene.class, sbSqlClause.toString());
        try (QueryCursor cursor = cache.query((Query)sql);){
            for (Cache.Entry e : cursor) {
                genes.add(e.getValue());
            }
        }
        int idx = this.selectRandomIndex(genes.size());
        Gene gene = (Gene)genes.get(idx);
        return gene.id();
    }

    private int selectRandomIndex(int sizeOfGenePool) {
        Random randomGenerator = new Random();
        int index = randomGenerator.nextInt(sizeOfGenePool);
        return index;
    }

    private List<Long> selection(List<Long> chromosomeKeys) {
        List<Long> selectedKeys = new ArrayList<Long>();
        GAGridConstants.SELECTION_METHOD selectionMethod = this.config.getSelectionMethod();
        switch (selectionMethod) {
            case SELECTON_METHOD_ELETISM: {
                selectedKeys = this.selectByElitism(chromosomeKeys);
                break;
            }
            case SELECTION_METHOD_TRUNCATION: {
                selectedKeys = this.selectByTruncation(chromosomeKeys);
                List<Long> fittestKeys = this.getFittestKeysForTruncation(chromosomeKeys);
                this.copyFitterChromosomesToPopulation(fittestKeys, selectedKeys);
                break;
            }
        }
        return selectedKeys;
    }

    List<Long> getPopulationKeys() {
        return this.populationKeys;
    }
}

