/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.ArrayList;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.ml.genetic.Chromosome;
import org.apache.ignite.ml.genetic.Gene;
import org.apache.ignite.ml.genetic.IFitnessFunction;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.transactions.Transaction;

public class FitnessJob
extends ComputeJobAdapter {
    private Long key;
    @IgniteInstanceResource
    private Ignite ignite = null;
    @LoggerResource
    private IgniteLogger log = null;
    private IFitnessFunction fitnessFuncton = null;

    public FitnessJob(Long key, IFitnessFunction fitnessFunction) {
        this.key = key;
        this.fitnessFuncton = fitnessFunction;
    }

    public Double execute() throws IgniteException {
        IgniteCache populationCache = this.ignite.cache("populationCache");
        IgniteCache geneCache = this.ignite.cache("geneCache");
        Chromosome chromosome = (Chromosome)populationCache.localPeek((Object)this.key, new CachePeekMode[0]);
        long[] geneKeys = chromosome.getGenes();
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (int i = 0; i < geneKeys.length; ++i) {
            long aKey = geneKeys[i];
            Gene aGene = (Gene)geneCache.localPeek((Object)aKey, new CachePeekMode[0]);
            genes.add(aGene);
        }
        Double value = this.fitnessFuncton.evaluate(genes);
        chromosome.setFitnessScore(value);
        Transaction tx = this.ignite.transactions().txStart();
        populationCache.put((Object)chromosome.id(), (Object)chromosome);
        tx.commit();
        return value;
    }
}

