/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.cache.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.ml.dataset.PartitionContextBuilder;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.impl.cache.util.PartitionDataStorage;
import org.apache.ignite.ml.dataset.impl.cache.util.UpstreamCursorAdapter;
import org.apache.ignite.ml.math.functions.IgniteFunction;

public class ComputeUtils {
    private static final String DATA_STORAGE_KEY_TEMPLATE = "part_data_storage_%s";

    public static <R> Collection<R> affinityCallWithRetries(Ignite ignite, Collection<String> cacheNames, IgniteFunction<Integer, R> fun, int retries, int interval) {
        assert (cacheNames.size() > 0);
        assert (interval >= 0);
        String primaryCache = cacheNames.iterator().next();
        Affinity affinity = ignite.affinity(primaryCache);
        int partitions = affinity.partitions();
        BitSet completionFlags = new BitSet(partitions);
        ArrayList<Object> results = new ArrayList<Object>();
        for (int t = 0; t <= retries; ++t) {
            ClusterGroup clusterGrp = ignite.cluster().forDataNodes(primaryCache);
            HashMap<Integer, IgniteFuture> futures = new HashMap<Integer, IgniteFuture>();
            for (int part = 0; part < partitions; ++part) {
                if (completionFlags.get(part)) continue;
                int currPart = part;
                futures.put(currPart, ignite.compute(clusterGrp).affinityCallAsync(cacheNames, currPart, (IgniteCallable & Serializable)() -> fun.apply(currPart)));
            }
            Iterator iterator = futures.keySet().iterator();
            while (iterator.hasNext()) {
                int part = (Integer)iterator.next();
                try {
                    Object res = ((IgniteFuture)futures.get(part)).get();
                    results.add(res);
                    completionFlags.set(part);
                }
                catch (IgniteException igniteException) {}
            }
            if (completionFlags.cardinality() == partitions) {
                return results;
            }
            LockSupport.parkNanos(interval * 1000000);
        }
        throw new IllegalStateException();
    }

    public static <R> Collection<R> affinityCallWithRetries(Ignite ignite, Collection<String> cacheNames, IgniteFunction<Integer, R> fun, int retries) {
        return ComputeUtils.affinityCallWithRetries(ignite, cacheNames, fun, retries, 0);
    }

    public static <K, V, C extends Serializable, D extends AutoCloseable> D getData(Ignite ignite, String upstreamCacheName, String datasetCacheName, UUID datasetId, int part, PartitionDataBuilder<K, V, C, D> partDataBuilder) {
        PartitionDataStorage dataStorage = (PartitionDataStorage)ignite.cluster().nodeLocalMap().computeIfAbsent(String.format(DATA_STORAGE_KEY_TEMPLATE, datasetId), key -> new PartitionDataStorage());
        return (D)dataStorage.computeDataIfAbsent(part, () -> {
            IgniteCache learningCtxCache = ignite.cache(datasetCacheName);
            Serializable ctx = (Serializable)learningCtxCache.get((Object)part);
            IgniteCache upstreamCache = ignite.cache(upstreamCacheName);
            ScanQuery qry = new ScanQuery();
            qry.setLocal(true);
            qry.setPartition(Integer.valueOf(part));
            long cnt = upstreamCache.localSizeLong(part, new CachePeekMode[0]);
            if (cnt > 0L) {
                try (QueryCursor cursor = upstreamCache.query((Query)qry);){
                    Object d = partDataBuilder.build(new UpstreamCursorAdapter(cursor.iterator(), cnt), cnt, ctx);
                    return d;
                }
            }
            return null;
        });
    }

    public static <K, V, C extends Serializable> void initContext(Ignite ignite, String upstreamCacheName, String datasetCacheName, PartitionContextBuilder<K, V, C> ctxBuilder, int retries, int interval) {
        ComputeUtils.affinityCallWithRetries(ignite, Arrays.asList(datasetCacheName, upstreamCacheName), part -> {
            Object ctx;
            Ignite locIgnite = Ignition.localIgnite();
            IgniteCache locUpstreamCache = locIgnite.cache(upstreamCacheName);
            ScanQuery qry = new ScanQuery();
            qry.setLocal(true);
            qry.setPartition(part);
            long cnt = locUpstreamCache.localSizeLong(part.intValue(), new CachePeekMode[0]);
            try (QueryCursor cursor = locUpstreamCache.query((Query)qry);){
                ctx = ctxBuilder.build(new UpstreamCursorAdapter(cursor.iterator(), cnt), cnt);
            }
            IgniteCache datasetCache = locIgnite.cache(datasetCacheName);
            datasetCache.put(part, ctx);
            return part;
        }, retries, interval);
    }

    public static <K, V, C extends Serializable> void initContext(Ignite ignite, String upstreamCacheName, String datasetCacheName, PartitionContextBuilder<K, V, C> ctxBuilder, int retries) {
        ComputeUtils.initContext(ignite, upstreamCacheName, datasetCacheName, ctxBuilder, retries, 0);
    }

    public static <C extends Serializable> C getContext(Ignite ignite, String datasetCacheName, int part) {
        IgniteCache datasetCache = ignite.cache(datasetCacheName);
        return (C)((Serializable)datasetCache.get((Object)part));
    }

    public static <C extends Serializable> void saveContext(Ignite ignite, String datasetCacheName, int part, C ctx) {
        IgniteCache datasetCache = ignite.cache(datasetCacheName);
        datasetCache.put((Object)part, ctx);
    }
}

