/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.session;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.querybuilder.Batch;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.cassandra.common.CassandraHelper;
import org.apache.ignite.cache.store.cassandra.common.RandomSleeper;
import org.apache.ignite.cache.store.cassandra.persistence.KeyValuePersistenceSettings;
import org.apache.ignite.cache.store.cassandra.session.BatchExecutionAssistant;
import org.apache.ignite.cache.store.cassandra.session.BatchLoaderAssistant;
import org.apache.ignite.cache.store.cassandra.session.CassandraSession;
import org.apache.ignite.cache.store.cassandra.session.ExecutionAssistant;
import org.apache.ignite.cache.store.cassandra.session.pool.SessionPool;
import org.apache.ignite.cache.store.cassandra.session.transaction.Mutation;

public class CassandraSessionImpl
implements CassandraSession {
    private static final int CQL_EXECUTION_ATTEMPTS_COUNT = 20;
    private static final int CQL_EXECUTION_ATTEMPT_MIN_TIMEOUT = 100;
    private static final int CQL_EXECUTION_ATTEMPT_MAX_TIMEOUT = 500;
    private static final int CQL_ATTEMPTS_TIMEOUT_INCREMENT = 100;
    private volatile Cluster.Builder builder;
    private volatile Session ses;
    private volatile int refCnt;
    private static final Map<String, PreparedStatement> sesStatements = new HashMap<String, PreparedStatement>();
    private Integer fetchSize;
    private ConsistencyLevel readConsistency;
    private ConsistencyLevel writeConsistency;
    private long expirationTimeout;
    private IgniteLogger log;
    private final AtomicInteger tblAbsenceHandlersCnt = new AtomicInteger(-1);
    private final AtomicInteger prepStatementHandlersCnt = new AtomicInteger(-1);

    public CassandraSessionImpl(Cluster.Builder builder, Integer n, ConsistencyLevel consistencyLevel, ConsistencyLevel consistencyLevel2, long l, IgniteLogger igniteLogger) {
        this.builder = builder;
        this.fetchSize = n;
        this.readConsistency = consistencyLevel;
        this.writeConsistency = consistencyLevel2;
        this.expirationTimeout = l;
        this.log = igniteLogger;
    }

    /*
     * Exception decompiling
     */
    @Override
    public <V> V execute(ExecutionAssistant<V> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <R, V> R execute(BatchExecutionAssistant<R, V> var1_1, Iterable<? extends V> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 14[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute(BatchLoaderAssistant var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute(List<Mutation> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.decrementSessionRefs() == 0 && this.ses != null) {
            SessionPool.put(this, this.ses, this.expirationTimeout);
            this.ses = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refresh() {
        SessionPool.get(this);
        CassandraHelper.closeSession(this.ses);
        this.ses = null;
        this.session();
        Map<String, PreparedStatement> map = sesStatements;
        synchronized (map) {
            sesStatements.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Session session() {
        if (this.ses != null) {
            return this.ses;
        }
        this.ses = SessionPool.get(this);
        if (this.ses != null) {
            return this.ses;
        }
        Map<String, PreparedStatement> map = sesStatements;
        synchronized (map) {
            sesStatements.clear();
        }
        try {
            this.ses = this.builder.build().connect();
            return this.ses;
        }
        catch (Throwable throwable) {
            throw new IgniteException("Failed to establish session with Cassandra database", throwable);
        }
    }

    private synchronized void incrementSessionRefs() {
        ++this.refCnt;
    }

    private synchronized int decrementSessionRefs() {
        if (this.refCnt != 0) {
            --this.refCnt;
        }
        return this.refCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PreparedStatement prepareStatement(String var1_1, String var2_2, KeyValuePersistenceSettings var3_3, boolean var4_4) {
        var6_6 = null;
        var7_7 = "Failed to prepare Cassandra CQL statement: " + var2_2;
        var8_8 = this.newSleeper();
        this.incrementSessionRefs();
        try {
            var9_9 = CassandraSessionImpl.sesStatements;
            synchronized (var9_9) {
                block16: {
                    if (!CassandraSessionImpl.sesStatements.containsKey(var2_2)) break block16;
                    var10_11 = CassandraSessionImpl.sesStatements.get(var2_2);
                    return var10_11;
                }
                ** try [egrp 3[TRYBLOCK] [1 : 81->87)] { 
                {
                }
            }
lbl17:
            // 3 sources

            for (var5_5 = 0; var5_5 < 20; ++var5_5) {
                try {
                    var9_9 = this.session().prepare(var2_2);
                    var10_12 = CassandraSessionImpl.sesStatements;
                    synchronized (var10_12) {
                        CassandraSessionImpl.sesStatements.put(var2_2, var9_9);
                    }
                    var10_12 = var9_9;
                    return var10_12;
                }
                catch (Throwable var9_10) {
                    block17: {
                        if (!CassandraHelper.isTableAbsenceError(var9_10)) ** GOTO lbl42
                        if (var4_4) break block17;
                        var10_13 = null;
                        this.decrementSessionRefs();
                        return var10_13;
                    }
                    try {
                        block18: {
                            this.handleTableAbsenceError(var1_1, var3_3);
                            break block18;
lbl42:
                            // 1 sources

                            if (!CassandraHelper.isHostsAvailabilityError(var9_10)) throw new IgniteException(var7_7, var9_10);
                            this.handleHostsAvailabilityError(var9_10, var5_5, var7_7);
                        }
                        var6_6 = var9_10;
                        if (CassandraHelper.isTableAbsenceError(var6_6)) continue;
                        var8_8.sleep();
                        continue;
                    }
                    catch (Throwable var13_16) {
                        throw var13_16;
                        throw new IgniteException(var7_7, var6_6);
                    }
                }
            }
        }
        finally {
            this.decrementSessionRefs();
        }
    }

    private void createKeyspace(KeyValuePersistenceSettings keyValuePersistenceSettings) {
        Throwable throwable = null;
        String string = "Failed to create Cassandra keyspace '" + keyValuePersistenceSettings.getKeyspace() + "'";
        for (int i = 0; i < 20; ++i) {
            try {
                this.log.info("-----------------------------------------------------------------------");
                this.log.info("Creating Cassandra keyspace '" + keyValuePersistenceSettings.getKeyspace() + "'");
                this.log.info("-----------------------------------------------------------------------\n\n" + keyValuePersistenceSettings.getKeyspaceDDLStatement() + "\n");
                this.log.info("-----------------------------------------------------------------------");
                this.session().execute(keyValuePersistenceSettings.getKeyspaceDDLStatement());
                this.log.info("Cassandra keyspace '" + keyValuePersistenceSettings.getKeyspace() + "' was successfully created");
                return;
            }
            catch (AlreadyExistsException alreadyExistsException) {
                this.log.info("Cassandra keyspace '" + keyValuePersistenceSettings.getKeyspace() + "' already exist");
                return;
            }
            catch (Throwable throwable2) {
                if (!CassandraHelper.isHostsAvailabilityError(throwable2)) {
                    throw new IgniteException(string, throwable2);
                }
                this.handleHostsAvailabilityError(throwable2, i, string);
                throwable = throwable2;
                continue;
            }
        }
        throw new IgniteException(string, throwable);
    }

    private void createTable(String string, KeyValuePersistenceSettings keyValuePersistenceSettings) {
        Throwable throwable = null;
        String string2 = keyValuePersistenceSettings.getKeyspace() + "." + string;
        String string3 = "Failed to create Cassandra table '" + string2 + "'";
        for (int i = 0; i < 20; ++i) {
            try {
                this.log.info("-----------------------------------------------------------------------");
                this.log.info("Creating Cassandra table '" + string2 + "'");
                this.log.info("-----------------------------------------------------------------------\n\n" + keyValuePersistenceSettings.getTableDDLStatement(string) + "\n");
                this.log.info("-----------------------------------------------------------------------");
                this.session().execute(keyValuePersistenceSettings.getTableDDLStatement(string));
                this.log.info("Cassandra table '" + string2 + "' was successfully created");
                return;
            }
            catch (AlreadyExistsException alreadyExistsException) {
                this.log.info("Cassandra table '" + string2 + "' already exist");
                return;
            }
            catch (Throwable throwable2) {
                if (!CassandraHelper.isHostsAvailabilityError(throwable2) && !CassandraHelper.isKeyspaceAbsenceError(throwable2)) {
                    throw new IgniteException(string3, throwable2);
                }
                if (CassandraHelper.isKeyspaceAbsenceError(throwable2)) {
                    this.log.warning("Failed to create Cassandra table '" + string2 + "' cause appropriate keyspace doesn't exist", throwable2);
                    this.createKeyspace(keyValuePersistenceSettings);
                } else if (CassandraHelper.isHostsAvailabilityError(throwable2)) {
                    this.handleHostsAvailabilityError(throwable2, i, string3);
                }
                throwable = throwable2;
                continue;
            }
        }
        throw new IgniteException(string3, throwable);
    }

    private void createTableIndexes(String string, KeyValuePersistenceSettings keyValuePersistenceSettings) {
        List<String> list = keyValuePersistenceSettings.getIndexDDLStatements(string);
        if (list == null || list.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        String string2 = keyValuePersistenceSettings.getKeyspace() + "." + string;
        String string3 = "Failed to create indexes for Cassandra table " + string2;
        for (int i = 0; i < 20; ++i) {
            try {
                this.log.info("-----------------------------------------------------------------------");
                this.log.info("Creating indexes for Cassandra table '" + string2 + "'");
                this.log.info("-----------------------------------------------------------------------");
                for (String string4 : list) {
                    try {
                        this.log.info(string4);
                        this.log.info("-----------------------------------------------------------------------");
                        this.session().execute(string4);
                    }
                    catch (AlreadyExistsException alreadyExistsException) {
                    }
                    catch (Throwable throwable2) {
                        if (throwable2 instanceof InvalidQueryException && "Index already exists".equals(throwable2.getMessage())) continue;
                        throw new IgniteException(string3, throwable2);
                    }
                }
                this.log.info("Indexes for Cassandra table '" + string2 + "' were successfully created");
                return;
            }
            catch (Throwable throwable3) {
                if (CassandraHelper.isHostsAvailabilityError(throwable3)) {
                    this.handleHostsAvailabilityError(throwable3, i, string3);
                } else if (CassandraHelper.isTableAbsenceError(throwable3)) {
                    this.createTable(string, keyValuePersistenceSettings);
                } else {
                    throw new IgniteException(string3, throwable3);
                }
                throwable = throwable3;
                continue;
            }
        }
        throw new IgniteException(string3, throwable);
    }

    private Statement tuneStatementExecutionOptions(Statement statement) {
        boolean bl;
        String string = "";
        if (statement instanceof BoundStatement) {
            string = ((BoundStatement)statement).preparedStatement().getQueryString().trim().toLowerCase();
        } else if (statement instanceof PreparedStatement) {
            string = ((PreparedStatement)statement).getQueryString().trim().toLowerCase();
        }
        boolean bl2 = string.startsWith("select");
        boolean bl3 = bl = statement instanceof Batch || statement instanceof BatchStatement || string.startsWith("insert") || string.startsWith("delete") || string.startsWith("update");
        if (bl2 && this.readConsistency != null) {
            statement.setConsistencyLevel(this.readConsistency);
        }
        if (bl && this.writeConsistency != null) {
            statement.setConsistencyLevel(this.writeConsistency);
        }
        if (this.fetchSize != null) {
            statement.setFetchSize(this.fetchSize.intValue());
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTableAbsenceError(String string, KeyValuePersistenceSettings keyValuePersistenceSettings) {
        int n = this.tblAbsenceHandlersCnt.incrementAndGet();
        String string2 = keyValuePersistenceSettings.getKeyspace() + "." + string;
        try {
            AtomicInteger atomicInteger = this.tblAbsenceHandlersCnt;
            synchronized (atomicInteger) {
                block14: {
                    if (n == 0) break block14;
                    this.log.warning("Table " + string2 + " absence problem detected. " + "Another thread already fixed it.");
                    return;
                }
                this.log.warning("Table " + string2 + " absence problem detected. " + "Trying to create table.");
                IgniteException igniteException = new IgniteException("Failed to create Cassandra table " + string2);
                for (int i = 0; igniteException != null && i < 20; ++i) {
                    igniteException = null;
                    try {
                        this.createKeyspace(keyValuePersistenceSettings);
                        this.createTable(string, keyValuePersistenceSettings);
                        this.createTableIndexes(string, keyValuePersistenceSettings);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (!CassandraHelper.isHostsAvailabilityError(throwable)) {
                            throw new IgniteException("Failed to create Cassandra table " + string2, throwable);
                        }
                        this.handleHostsAvailabilityError(throwable, i, null);
                        igniteException = throwable instanceof IgniteException ? (IgniteException)throwable : new IgniteException(throwable);
                    }
                }
                if (igniteException != null) {
                    throw igniteException;
                }
            }
        }
        finally {
            if (n == 0) {
                this.tblAbsenceHandlersCnt.set(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePreparedStatementClusterError(Throwable throwable) {
        int n = this.prepStatementHandlersCnt.incrementAndGet();
        try {
            AtomicInteger atomicInteger = this.prepStatementHandlersCnt;
            synchronized (atomicInteger) {
                block9: {
                    if (n == 0) break block9;
                    this.log.warning("Prepared statement cluster error detected, another thread already fixed the problem", throwable);
                    return;
                }
                this.log.warning("Prepared statement cluster error detected, refreshing Cassandra session", throwable);
                this.refresh();
                this.log.warning("Cassandra session refreshed");
            }
        }
        finally {
            if (n == 0) {
                this.prepStatementHandlersCnt.set(-1);
            }
        }
    }

    private boolean handleHostsAvailabilityError(Throwable throwable, int n, String string) {
        if (n >= 20) {
            this.log.error("Host availability problem detected. Number of CQL execution attempts reached maximum 20, exception will be thrown to upper execution layer.", throwable);
            throw string == null ? new IgniteException(throwable) : new IgniteException(string, throwable);
        }
        if (n == 5 || n == 10 || n == 15 || n == 19) {
            this.log.warning("Host availability problem detected, CQL execution attempt  " + (n + 1) + ", " + "refreshing Cassandra session", throwable);
            this.refresh();
            this.log.warning("Cassandra session refreshed");
            return true;
        }
        this.log.warning("Host availability problem detected, CQL execution attempt " + (n + 1) + ", " + "sleeping extra " + 500 + " milliseconds", throwable);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.warning("Sleep completed");
        return false;
    }

    private RandomSleeper newSleeper() {
        return new RandomSleeper(100, 500, 100, this.log);
    }
}

