/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.cache.store.cassandra.datasource.DataSource;
import org.apache.ignite.cache.store.cassandra.persistence.KeyValuePersistenceSettings;
import org.apache.ignite.cache.store.cassandra.persistence.PersistenceController;
import org.apache.ignite.cache.store.cassandra.session.CassandraSession;
import org.apache.ignite.cache.store.cassandra.session.ExecutionAssistant;
import org.apache.ignite.cache.store.cassandra.session.GenericBatchExecutionAssistant;
import org.apache.ignite.cache.store.cassandra.session.LoadCacheCustomQueryWorker;
import org.apache.ignite.cache.store.cassandra.session.transaction.DeleteMutation;
import org.apache.ignite.cache.store.cassandra.session.transaction.Mutation;
import org.apache.ignite.cache.store.cassandra.session.transaction.WriteMutation;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.resources.CacheStoreSessionResource;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.thread.IgniteThreadFactory;

public class CassandraCacheStore<K, V>
implements CacheStore<K, V> {
    private static final String TRANSACTION_BUFFER = "CASSANDRA_TRANSACTION_BUFFER";
    private static final String CACHE_LOADER_THREAD_NAME = "cassandra-cache-loader";
    @IgniteInstanceResource
    private Ignite ignite;
    @CacheStoreSessionResource
    private CacheStoreSession storeSes;
    @LoggerResource
    private IgniteLogger log;
    private DataSource dataSrc;
    private int maxPoolSize = Runtime.getRuntime().availableProcessors();
    private final PersistenceController controller;

    public CassandraCacheStore(DataSource dataSource, KeyValuePersistenceSettings keyValuePersistenceSettings, int n) {
        this.dataSrc = dataSource;
        this.controller = new PersistenceController(keyValuePersistenceSettings);
        this.maxPoolSize = n;
    }

    public void loadCache(IgniteBiInClosure<K, V> igniteBiInClosure, Object ... objectArray) throws CacheLoaderException {
        if (igniteBiInClosure == null) {
            return;
        }
        if (objectArray == null || objectArray.length == 0) {
            objectArray = new String[]{"select * from " + this.controller.getPersistenceSettings().getKeyspace() + "." + this.cassandraTable() + ";"};
        }
        ExecutorService executorService = null;
        ArrayList arrayList = new ArrayList(objectArray.length);
        try {
            executorService = Executors.newFixedThreadPool(this.maxPoolSize, (ThreadFactory)new IgniteThreadFactory(this.ignite.name(), CACHE_LOADER_THREAD_NAME));
            CassandraSession cassandraSession = this.getCassandraSession();
            for (Object object : objectArray) {
                String string;
                LoadCacheCustomQueryWorker<K, V> loadCacheCustomQueryWorker = null;
                if (object instanceof Statement) {
                    loadCacheCustomQueryWorker = new LoadCacheCustomQueryWorker<K, V>(cassandraSession, (Statement)object, this.controller, this.log, igniteBiInClosure);
                } else if (object instanceof String && (string = ((String)object).trim()).toLowerCase().startsWith("select")) {
                    loadCacheCustomQueryWorker = new LoadCacheCustomQueryWorker<K, V>(cassandraSession, (String)object, this.controller, this.log, igniteBiInClosure);
                }
                if (loadCacheCustomQueryWorker == null) continue;
                arrayList.add(executorService.submit(loadCacheCustomQueryWorker));
            }
            for (Future future : arrayList) {
                U.get((Future)future);
            }
            if (this.log != null && this.log.isDebugEnabled() && this.storeSes != null) {
                this.log.debug("Cache loaded from db: " + this.storeSes.cacheName());
            }
        }
        catch (IgniteCheckedException igniteCheckedException) {
            try {
                if (this.storeSes != null) {
                    throw new CacheLoaderException("Failed to load Ignite cache: " + this.storeSes.cacheName(), igniteCheckedException.getCause());
                }
                throw new CacheLoaderException("Failed to load cache", igniteCheckedException.getCause());
            }
            catch (Throwable throwable) {
                U.shutdownNow(this.getClass(), executorService, (IgniteLogger)this.log);
                throw throwable;
            }
        }
        U.shutdownNow(this.getClass(), (ExecutorService)executorService, (IgniteLogger)this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnd(boolean bl) throws CacheWriterException {
        if (!this.storeSes.isWithinTransaction()) {
            return;
        }
        List<Mutation> list = this.mutations();
        if (list == null || list.isEmpty()) {
            return;
        }
        CassandraSession cassandraSession = this.getCassandraSession();
        try {
            cassandraSession.execute(list);
        }
        finally {
            list.clear();
            U.closeQuiet((AutoCloseable)cassandraSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V load(final K k) throws CacheLoaderException {
        if (k == null) {
            return null;
        }
        CassandraSession cassandraSession = this.getCassandraSession();
        try {
            Object v = cassandraSession.execute(new ExecutionAssistant<V>(){

                @Override
                public boolean tableExistenceRequired() {
                    return false;
                }

                @Override
                public String getTable() {
                    return CassandraCacheStore.this.cassandraTable();
                }

                @Override
                public String getStatement() {
                    return CassandraCacheStore.this.controller.getLoadStatement(CassandraCacheStore.this.cassandraTable(), false);
                }

                @Override
                public BoundStatement bindStatement(PreparedStatement preparedStatement) {
                    return CassandraCacheStore.this.controller.bindKey(preparedStatement, k);
                }

                @Override
                public KeyValuePersistenceSettings getPersistenceSettings() {
                    return CassandraCacheStore.this.controller.getPersistenceSettings();
                }

                @Override
                public String operationName() {
                    return "READ";
                }

                @Override
                public V process(Row row) {
                    return row == null ? null : CassandraCacheStore.this.controller.buildValueObject(row);
                }
            });
            return v;
        }
        finally {
            U.closeQuiet((AutoCloseable)cassandraSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> loadAll(Iterable<? extends K> iterable) throws CacheLoaderException {
        if (iterable == null || !iterable.iterator().hasNext()) {
            return new HashMap();
        }
        CassandraSession cassandraSession = this.getCassandraSession();
        try {
            Map map = (Map)cassandraSession.execute(new GenericBatchExecutionAssistant<Map<K, V>, K>(){
                private Map<K, V> data = new HashMap();

                @Override
                public String getTable() {
                    return CassandraCacheStore.this.cassandraTable();
                }

                @Override
                public String getStatement() {
                    return CassandraCacheStore.this.controller.getLoadStatement(CassandraCacheStore.this.cassandraTable(), true);
                }

                @Override
                public BoundStatement bindStatement(PreparedStatement preparedStatement, K k) {
                    return CassandraCacheStore.this.controller.bindKey(preparedStatement, k);
                }

                @Override
                public KeyValuePersistenceSettings getPersistenceSettings() {
                    return CassandraCacheStore.this.controller.getPersistenceSettings();
                }

                @Override
                public String operationName() {
                    return "BULK_READ";
                }

                @Override
                public Map<K, V> processedData() {
                    return this.data;
                }

                @Override
                protected void process(Row row) {
                    if (row != null) {
                        this.data.put(CassandraCacheStore.this.controller.buildKeyObject(row), CassandraCacheStore.this.controller.buildValueObject(row));
                    }
                }
            }, iterable);
            return map;
        }
        finally {
            U.closeQuiet((AutoCloseable)cassandraSession);
        }
    }

    public void write(final Cache.Entry<? extends K, ? extends V> entry) throws CacheWriterException {
        if (entry == null || entry.getKey() == null) {
            return;
        }
        if (this.storeSes.isWithinTransaction()) {
            this.accumulate(new WriteMutation(entry, this.cassandraTable(), this.controller));
            return;
        }
        CassandraSession cassandraSession = this.getCassandraSession();
        try {
            cassandraSession.execute(new ExecutionAssistant<Void>(){

                @Override
                public boolean tableExistenceRequired() {
                    return true;
                }

                @Override
                public String getTable() {
                    return CassandraCacheStore.this.cassandraTable();
                }

                @Override
                public String getStatement() {
                    return CassandraCacheStore.this.controller.getWriteStatement(CassandraCacheStore.this.cassandraTable());
                }

                @Override
                public BoundStatement bindStatement(PreparedStatement preparedStatement) {
                    return CassandraCacheStore.this.controller.bindKeyValue(preparedStatement, entry.getKey(), entry.getValue());
                }

                @Override
                public KeyValuePersistenceSettings getPersistenceSettings() {
                    return CassandraCacheStore.this.controller.getPersistenceSettings();
                }

                @Override
                public String operationName() {
                    return "WRITE";
                }

                @Override
                public Void process(Row row) {
                    return null;
                }
            });
        }
        finally {
            U.closeQuiet((AutoCloseable)cassandraSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> collection) throws CacheWriterException {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (this.storeSes.isWithinTransaction()) {
            for (Cache.Entry<K, V> entry : collection) {
                this.accumulate(new WriteMutation(entry, this.cassandraTable(), this.controller));
            }
            return;
        }
        CassandraSession cassandraSession = this.getCassandraSession();
        try {
            cassandraSession.execute(new GenericBatchExecutionAssistant<Void, Cache.Entry<? extends K, ? extends V>>(){

                @Override
                public String getTable() {
                    return CassandraCacheStore.this.cassandraTable();
                }

                @Override
                public String getStatement() {
                    return CassandraCacheStore.this.controller.getWriteStatement(CassandraCacheStore.this.cassandraTable());
                }

                @Override
                public BoundStatement bindStatement(PreparedStatement preparedStatement, Cache.Entry<? extends K, ? extends V> entry) {
                    return CassandraCacheStore.this.controller.bindKeyValue(preparedStatement, entry.getKey(), entry.getValue());
                }

                @Override
                public KeyValuePersistenceSettings getPersistenceSettings() {
                    return CassandraCacheStore.this.controller.getPersistenceSettings();
                }

                @Override
                public String operationName() {
                    return "BULK_WRITE";
                }

                @Override
                public boolean tableExistenceRequired() {
                    return true;
                }
            }, collection);
        }
        finally {
            U.closeQuiet((AutoCloseable)cassandraSession);
        }
    }

    public void delete(final Object object) throws CacheWriterException {
        if (object == null) {
            return;
        }
        if (this.storeSes.isWithinTransaction()) {
            this.accumulate(new DeleteMutation(object, this.cassandraTable(), this.controller));
            return;
        }
        CassandraSession cassandraSession = this.getCassandraSession();
        try {
            cassandraSession.execute(new ExecutionAssistant<Void>(){

                @Override
                public boolean tableExistenceRequired() {
                    return false;
                }

                @Override
                public String getTable() {
                    return CassandraCacheStore.this.cassandraTable();
                }

                @Override
                public String getStatement() {
                    return CassandraCacheStore.this.controller.getDeleteStatement(CassandraCacheStore.this.cassandraTable());
                }

                @Override
                public BoundStatement bindStatement(PreparedStatement preparedStatement) {
                    return CassandraCacheStore.this.controller.bindKey(preparedStatement, object);
                }

                @Override
                public KeyValuePersistenceSettings getPersistenceSettings() {
                    return CassandraCacheStore.this.controller.getPersistenceSettings();
                }

                @Override
                public String operationName() {
                    return "DELETE";
                }

                @Override
                public Void process(Row row) {
                    return null;
                }
            });
        }
        finally {
            U.closeQuiet((AutoCloseable)cassandraSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(Collection<?> collection) throws CacheWriterException {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (this.storeSes.isWithinTransaction()) {
            for (Object obj : collection) {
                this.accumulate(new DeleteMutation(obj, this.cassandraTable(), this.controller));
            }
            return;
        }
        CassandraSession cassandraSession = this.getCassandraSession();
        try {
            cassandraSession.execute(new GenericBatchExecutionAssistant<Void, Object>(){

                @Override
                public String getTable() {
                    return CassandraCacheStore.this.cassandraTable();
                }

                @Override
                public String getStatement() {
                    return CassandraCacheStore.this.controller.getDeleteStatement(CassandraCacheStore.this.cassandraTable());
                }

                @Override
                public BoundStatement bindStatement(PreparedStatement preparedStatement, Object object) {
                    return CassandraCacheStore.this.controller.bindKey(preparedStatement, object);
                }

                @Override
                public KeyValuePersistenceSettings getPersistenceSettings() {
                    return CassandraCacheStore.this.controller.getPersistenceSettings();
                }

                @Override
                public String operationName() {
                    return "BULK_DELETE";
                }
            }, collection);
        }
        finally {
            U.closeQuiet((AutoCloseable)cassandraSession);
        }
    }

    private CassandraSession getCassandraSession() {
        return this.dataSrc.session((IgniteLogger)(this.log != null ? this.log : new NullLogger()));
    }

    private String cassandraTable() {
        return this.controller.getPersistenceSettings().getTable() != null ? this.controller.getPersistenceSettings().getTable() : this.storeSes.cacheName().trim().toLowerCase();
    }

    private void accumulate(Mutation mutation) {
        LinkedList<Mutation> linkedList = (LinkedList<Mutation>)this.storeSes.properties().get(TRANSACTION_BUFFER);
        if (linkedList == null) {
            linkedList = new LinkedList<Mutation>();
            this.storeSes.properties().put(TRANSACTION_BUFFER, linkedList);
        }
        linkedList.add(mutation);
    }

    private List<Mutation> mutations() {
        return (List)this.storeSes.properties().get(TRANSACTION_BUFFER);
    }

    public String toString() {
        return S.toString(CassandraCacheStore.class, (Object)this);
    }
}

