/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockStatusListener;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.storage.StorageStatusListener;
import org.apache.spark.storage.StorageUtils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u00015\u0011qb\u0015;pe\u0006<W\rT5ti\u0016tWM\u001d\u0006\u0003\u0007\u0011\tqa\u001d;pe\u0006<WM\u0003\u0002\u0006\r\u0005\u0011Q/\u001b\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0011#D\u0001\u0011\u0015\t\u0019a!\u0003\u0002\u0013!\t\u0019\"\t\\8dWN#\u0018\r^;t\u0019&\u001cH/\u001a8fe\"AA\u0003\u0001B\u0001B\u0003%Q#A\u000bti>\u0014\u0018mZ3Ti\u0006$Xo\u001d'jgR,g.\u001a:\u0011\u0005=1\u0012BA\f\u0011\u0005U\u0019Fo\u001c:bO\u0016\u001cF/\u0019;vg2K7\u000f^3oKJDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtDCA\u000e\u001e!\ta\u0002!D\u0001\u0003\u0011\u0015!\u0002\u00041\u0001\u0016\u0011!y\u0002A1A\u0005\u0002\u0011\u0001\u0013aC0sI\u0012LeNZ8NCB,\u0012!\t\t\u0005E%Zs&D\u0001$\u0015\t!S%A\u0004nkR\f'\r\\3\u000b\u0005\u0019:\u0013AC2pY2,7\r^5p]*\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+G\t\u0019Q*\u00199\u0011\u00051jS\"A\u0014\n\u00059:#aA%oiB\u0011q\u0002M\u0005\u0003cA\u0011qA\u0015#E\u0013:4w\u000e\u0003\u00044\u0001\u0001\u0006I!I\u0001\r?J$G-\u00138g_6\u000b\u0007\u000f\t\u0005\u0006k\u0001!\tAN\u0001\u0018C\u000e$\u0018N^3Ti>\u0014\u0018mZ3Ti\u0006$Xo\u001d'jgR,\u0012a\u000e\t\u0004q\u0001\u001beBA\u001d?\u001d\tQT(D\u0001<\u0015\taD\"\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011qhJ\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%IA\u0002TKFT!aP\u0014\u0011\u0005=!\u0015BA#\u0011\u00055\u0019Fo\u001c:bO\u0016\u001cF/\u0019;vg\")q\t\u0001C\u0001\u0011\u0006Y!\u000f\u001a3J]\u001a|G*[:u+\u0005I\u0005c\u0001\u001dA_!)1\n\u0001C\u0005\u0019\u0006iQ\u000f\u001d3bi\u0016\u0014F\tR%oM>$\"!\u0014)\u0011\u00051r\u0015BA((\u0005\u0011)f.\u001b;\t\u000bES\u0005\u0019\u0001*\u0002\u001bU\u0004H-\u0019;fI\ncwnY6t!\rA\u0004i\u0015\t\u0005YQ3\u0016,\u0003\u0002VO\t1A+\u001e9mKJ\u0002\"aD,\n\u0005a\u0003\"a\u0002\"m_\u000e\\\u0017\n\u001a\t\u0003\u001fiK!a\u0017\t\u0003\u0017\tcwnY6Ti\u0006$Xo\u001d\u0005\u0006;\u0002!\tEX\u0001\u0011_:\u001cF/Y4f'V\u0014W.\u001b;uK\u0012$\"!T0\t\u000b\u0001d\u0006\u0019A1\u0002\u001dM$\u0018mZ3Tk\nl\u0017\u000e\u001e;fIB\u0011!-Z\u0007\u0002G*\u0011AMB\u0001\ng\u000eDW\rZ;mKJL!AZ2\u00037M\u0003\u0018M]6MSN$XM\\3s'R\fw-Z*vE6LG\u000f^3e\u0011\u0015A\u0007\u0001\"\u0011j\u0003Aygn\u0015;bO\u0016\u001cu.\u001c9mKR,G\r\u0006\u0002NU\")1n\u001aa\u0001Y\u0006q1\u000f^1hK\u000e{W\u000e\u001d7fi\u0016$\u0007C\u00012n\u0013\tq7MA\u000eTa\u0006\u00148\u000eT5ti\u0016tWM]*uC\u001e,7i\\7qY\u0016$X\r\u001a\u0005\u0006a\u0002!\t%]\u0001\u000f_:,f\u000e]3sg&\u001cHO\u0015#E)\ti%\u000fC\u0003t_\u0002\u0007A/\u0001\u0007v]B,'o]5tiJ#E\t\u0005\u0002ck&\u0011ao\u0019\u0002\u001a'B\f'o\u001b'jgR,g.\u001a:V]B,'o]5tiJ#E\tC\u0003y\u0001\u0011\u0005\u00130\u0001\bp]\ncwnY6Va\u0012\fG/\u001a3\u0015\u00055S\b\"B>x\u0001\u0004a\u0018\u0001\u00042m_\u000e\\W\u000b\u001d3bi\u0016$\u0007C\u00012~\u0013\tq8MA\rTa\u0006\u00148\u000eT5ti\u0016tWM\u001d\"m_\u000e\\W\u000b\u001d3bi\u0016$\u0007f\u0002\u0001\u0002\u0002\u0005\u001d\u00111\u0002\t\u0004Y\u0005\r\u0011bAA\u0003O\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005%\u0011a\f+iSN\u00043\r\\1tg\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$\u0007%\u001b8!C\u00022W\u000f^;sK\u0002\u0012X\r\\3bg\u0016t\u0013EAA\u0007\u0003\u0015\u0011dF\r\u00181Q\r\u0001\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001c\u0005U!\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0007")
public class StorageListener
extends BlockStatusListener {
    private final StorageStatusListener storageStatusListener;
    private final Map<Object, RDDInfo> _rddInfoMap;

    public Map<Object, RDDInfo> _rddInfoMap() {
        return this._rddInfoMap;
    }

    public Seq<StorageStatus> activeStorageStatusList() {
        return this.storageStatusListener.storageStatusList();
    }

    public synchronized Seq<RDDInfo> rddInfoList() {
        return ((TraversableOnce)this._rddInfoMap().values().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RDDInfo x$1) {
                return x$1.numCachedPartitions() > 0;
            }
        })).toSeq();
    }

    private void updateRDDInfo(Seq<Tuple2<BlockId, BlockStatus>> updatedBlocks) {
        Set rddIdsToUpdate = ((TraversableOnce)updatedBlocks.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(Tuple2<BlockId, BlockStatus> x0$1) {
                Tuple2<BlockId, BlockStatus> tuple2 = x0$1;
                if (tuple2 != null) {
                    BlockId bid = (BlockId)tuple2._1();
                    Iterable iterable = Option$.MODULE$.option2Iterable(bid.asRDDId().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(RDDBlockId x$2) {
                            return x$2.rddId();
                        }
                    }));
                    return iterable;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        Seq rddInfosToUpdate = (Seq)this._rddInfoMap().values().toSeq().filter((Function1)new Serializable(this, rddIdsToUpdate){
            public static final long serialVersionUID = 0L;
            private final Set rddIdsToUpdate$1;

            public final boolean apply(RDDInfo s) {
                return this.rddIdsToUpdate$1.contains((Object)BoxesRunTime.boxToInteger((int)s.id()));
            }
            {
                this.rddIdsToUpdate$1 = rddIdsToUpdate$1;
            }
        });
        StorageUtils$.MODULE$.updateRddInfo((Seq<RDDInfo>)rddInfosToUpdate, this.activeStorageStatusList());
    }

    @Override
    public synchronized void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        Seq<RDDInfo> rddInfos = stageSubmitted.stageInfo().rddInfos();
        rddInfos.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageListener $outer;

            public final void apply(RDDInfo info) {
                ((RDDInfo)this.$outer._rddInfoMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)info.id()), (Function0)new Serializable(this, info){
                    public static final long serialVersionUID = 0L;
                    private final RDDInfo info$1;

                    public final RDDInfo apply() {
                        return this.info$1;
                    }
                    {
                        this.info$1 = info$1;
                    }
                })).name_$eq(info.name());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        StorageListener storageListener = this;
        synchronized (storageListener) {
            Set completedRddIds = ((TraversableOnce)stageCompleted.stageInfo().rddInfos().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(RDDInfo r) {
                    return r.id();
                }
            }, Seq$.MODULE$.canBuildFrom())).toSet();
            this._rddInfoMap().retain((Function2)new Serializable(this, completedRddIds){
                public static final long serialVersionUID = 0L;
                private final Set completedRddIds$1;

                public final boolean apply(int x0$2, RDDInfo x1$1) {
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)x1$1);
                    if (tuple2 != null) {
                        int id = tuple2._1$mcI$sp();
                        RDDInfo info = (RDDInfo)tuple2._2();
                        boolean bl = !this.completedRddIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)) || info.numCachedPartitions() > 0;
                        return bl;
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.completedRddIds$1 = completedRddIds$1;
                }
            });
            return;
        }
    }

    @Override
    public void onUnpersistRDD(SparkListenerUnpersistRDD unpersistRDD) {
        StorageListener storageListener = this;
        synchronized (storageListener) {
            this._rddInfoMap().remove((Object)BoxesRunTime.boxToInteger((int)unpersistRDD.rddId()));
            return;
        }
    }

    @Override
    public void onBlockUpdated(SparkListenerBlockUpdated blockUpdated) {
        super.onBlockUpdated(blockUpdated);
        BlockId blockId = blockUpdated.blockUpdatedInfo().blockId();
        StorageLevel storageLevel = blockUpdated.blockUpdatedInfo().storageLevel();
        long memSize = blockUpdated.blockUpdatedInfo().memSize();
        long diskSize = blockUpdated.blockUpdatedInfo().diskSize();
        BlockStatus blockStatus2 = new BlockStatus(storageLevel, memSize, diskSize);
        this.updateRDDInfo((Seq<Tuple2<BlockId, BlockStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)blockId, (Object)blockStatus2)}))));
    }

    public StorageListener(StorageStatusListener storageStatusListener) {
        this.storageStatusListener = storageStatusListener;
        this._rddInfoMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

