/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockStatus$;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus$;
import org.apache.spark.storage.StorageStatus$NonRddStorageInfo$;
import org.apache.spark.storage.StorageStatus$RddStorageInfo$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\r%c\u0001B\u0001\u0003\u0001-\u0011Qb\u0015;pe\u0006<Wm\u0015;biV\u001c(BA\u0002\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005q!\r\\8dW6\u000bg.Y4fe&#W#A\u000b\u0011\u0005Y9R\"\u0001\u0002\n\u0005a\u0011!A\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\u0005\t5\u0001\u0011\t\u0011)A\u0005+\u0005y!\r\\8dW6\u000bg.Y4fe&#\u0007\u0005\u0003\u0005\u001d\u0001\t\u0015\r\u0011\"\u0001\u001e\u0003%i\u0017\r_'f[>\u0014\u00180F\u0001\u001f!\tiq$\u0003\u0002!\u001d\t!Aj\u001c8h\u0011!\u0011\u0003A!A!\u0002\u0013q\u0012AC7bq6+Wn\u001c:zA!AA\u0005\u0001BC\u0002\u0013\u0005Q%\u0001\u0007nCb|e\u000eS3ba6+W.F\u0001'!\riqEH\u0005\u0003Q9\u0011aa\u00149uS>t\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u001b5\f\u0007p\u00148IK\u0006\u0004X*Z7!\u0011!a\u0003A!b\u0001\n\u0003)\u0013!D7bq>3g\rS3ba6+W\u000e\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003'\u00039i\u0017\r_(gM\"+\u0017\r]'f[\u0002BQ\u0001\r\u0001\u0005\u0002E\na\u0001P5oSRtD#\u0002\u001a4iU2\u0004C\u0001\f\u0001\u0011\u0015\u0019r\u00061\u0001\u0016\u0011\u0015ar\u00061\u0001\u001f\u0011\u0015!s\u00061\u0001'\u0011\u0015as\u00061\u0001'\u0011\u001dA\u0004A1A\u0005\ne\n!b\u0018:eI\ncwnY6t+\u0005Q\u0004\u0003B\u001eA\u0005\u0016k\u0011\u0001\u0010\u0006\u0003{y\nq!\\;uC\ndWM\u0003\u0002@\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0005c$a\u0002%bg\"l\u0015\r\u001d\t\u0003\u001b\rK!\u0001\u0012\b\u0003\u0007%sG\u000f\u0005\u0003<\r\"[\u0015BA$=\u0005\ri\u0015\r\u001d\t\u0003-%K!A\u0013\u0002\u0003\u000f\tcwnY6JIB\u0011a\u0003T\u0005\u0003\u001b\n\u00111B\u00117pG.\u001cF/\u0019;vg\"1q\n\u0001Q\u0001\ni\n1b\u0018:eI\ncwnY6tA!9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0016!D0o_:\u0014F\r\u001a\"m_\u000e\\7/F\u0001T!\u0011Y\u0004\tS&\t\rU\u0003\u0001\u0015!\u0003T\u00039yfn\u001c8SI\u0012\u0014En\\2lg\u00022Aa\u0016\u0001E1\nq!\u000b\u001a3Ti>\u0014\u0018mZ3J]\u001a|7\u0003\u0002,\r3r\u0003\"!\u0004.\n\u0005ms!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001buK!A\u0018\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u00014&Q3A\u0005\u0002u\t1\"\\3n_JLXk]1hK\"A!M\u0016B\tB\u0003%a$\u0001\u0007nK6|'/_+tC\u001e,\u0007\u0005\u0003\u0005e-\nU\r\u0011\"\u0001\u001e\u0003%!\u0017n]6Vg\u0006<W\r\u0003\u0005g-\nE\t\u0015!\u0003\u001f\u0003)!\u0017n]6Vg\u0006<W\r\t\u0005\tQZ\u0013)\u001a!C\u0001S\u0006)A.\u001a<fYV\t!\u000e\u0005\u0002\u0017W&\u0011AN\u0001\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\u0005\t]Z\u0013\t\u0012)A\u0005U\u00061A.\u001a<fY\u0002BQ\u0001\r,\u0005\u0002A$B!]:ukB\u0011!OV\u0007\u0002\u0001!)\u0001m\u001ca\u0001=!)Am\u001ca\u0001=!)\u0001n\u001ca\u0001U\"9qOVA\u0001\n\u0003A\u0018\u0001B2paf$B!]={w\"9\u0001M\u001eI\u0001\u0002\u0004q\u0002b\u00023w!\u0003\u0005\rA\b\u0005\bQZ\u0004\n\u00111\u0001k\u0011\u001dih+%A\u0005\u0002y\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001\u0000U\rq\u0012\u0011A\u0016\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0002\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0012\u0005\u001d!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"A\u0011Q\u0003,\u0012\u0002\u0013\u0005a0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005ea+%A\u0005\u0002\u0005m\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003;Q3A[A\u0001\u0011%\t\tCVA\u0001\n\u0003\n\u0019#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003K\u0001B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0003mC:<'BAA\u0018\u0003\u0011Q\u0017M^1\n\t\u0005M\u0012\u0011\u0006\u0002\u0007'R\u0014\u0018N\\4\t\u0013\u0005]b+!A\u0005\u0002\u0005e\u0012\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001\"\t\u0013\u0005ub+!A\u0005\u0002\u0005}\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0003\n9\u0005E\u0002\u000e\u0003\u0007J1!!\u0012\u000f\u0005\r\te.\u001f\u0005\n\u0003\u0013\nY$!AA\u0002\t\u000b1\u0001\u001f\u00132\u0011%\tiEVA\u0001\n\u0003\ny%A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0006\u0005\u0004\u0002T\u0005U\u0013\u0011I\u0007\u0002}%\u0019\u0011q\u000b \u0003\u0011%#XM]1u_JD\u0011\"a\u0017W\u0003\u0003%\t!!\u0018\u0002\u0011\r\fg.R9vC2$B!a\u0018\u0002fA\u0019Q\"!\u0019\n\u0007\u0005\rdBA\u0004C_>dW-\u00198\t\u0015\u0005%\u0013\u0011LA\u0001\u0002\u0004\t\t\u0005C\u0005\u0002jY\u000b\t\u0011\"\u0011\u0002l\u0005A\u0001.Y:i\u0007>$W\rF\u0001C\u0011%\tyGVA\u0001\n\u0003\n\t(\u0001\u0005u_N#(/\u001b8h)\t\t)\u0003C\u0005\u0002vY\u000b\t\u0011\"\u0011\u0002x\u00051Q-];bYN$B!a\u0018\u0002z!Q\u0011\u0011JA:\u0003\u0003\u0005\r!!\u0011\b\u0013\u0005u\u0004!!A\t\n\u0005}\u0014A\u0004*eIN#xN]1hK&sgm\u001c\t\u0004e\u0006\u0005e\u0001C,\u0001\u0003\u0003EI!a!\u0014\u000b\u0005\u0005\u0015Q\u0011/\u0011\u0011\u0005\u001d\u0015Q\u0012\u0010\u001fUFl!!!#\u000b\u0007\u0005-e\"A\u0004sk:$\u0018.\\3\n\t\u0005=\u0015\u0011\u0012\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004b\u0002\u0019\u0002\u0002\u0012\u0005\u00111\u0013\u000b\u0003\u0003\u007fB!\"a\u001c\u0002\u0002\u0006\u0005IQIA9\u0011)\tI*!!\u0002\u0002\u0013\u0005\u00151T\u0001\u0006CB\u0004H.\u001f\u000b\bc\u0006u\u0015qTAQ\u0011\u0019\u0001\u0017q\u0013a\u0001=!1A-a&A\u0002yAa\u0001[AL\u0001\u0004Q\u0007BCAS\u0003\u0003\u000b\t\u0011\"!\u0002(\u00069QO\\1qa2LH\u0003BAU\u0003c\u0003B!D\u0014\u0002,B1Q\"!,\u001f=)L1!a,\u000f\u0005\u0019!V\u000f\u001d7fg!I\u00111WAR\u0003\u0003\u0005\r!]\u0001\u0004q\u0012\u0002\u0004BCA\\\u0003\u0003\u000b\t\u0011\"\u0003\u0002:\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\f\u0005\u0003\u0002(\u0005u\u0016\u0002BA`\u0003S\u0011aa\u00142kK\u000e$\b\"CAb\u0001\t\u0007I\u0011BAc\u0003=y&\u000f\u001a3Ti>\u0014\u0018mZ3J]\u001a|WCAAd!\u0011Y\u0004IQ9\t\u0011\u0005-\u0007\u0001)A\u0005\u0003\u000f\f\u0001c\u0018:eIN#xN]1hK&sgm\u001c\u0011\u0007\r\u0005=\u0007\u0001RAi\u0005EquN\u001c*eIN#xN]1hK&sgm\\\n\u0006\u0003\u001bd\u0011\f\u0018\u0005\u000b\u0003+\fiM!e\u0001\n\u0003i\u0012aC8o\u0011\u0016\f\u0007/V:bO\u0016D1\"!7\u0002N\n\u0005\r\u0011\"\u0001\u0002\\\u0006yqN\u001c%fCB,6/Y4f?\u0012*\u0017\u000f\u0006\u0003\u0002^\u0006\r\bcA\u0007\u0002`&\u0019\u0011\u0011\u001d\b\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0013\n9.!AA\u0002yA!\"a:\u0002N\nE\t\u0015)\u0003\u001f\u00031yg\u000eS3baV\u001b\u0018mZ3!\u0011)\tY/!4\u0003\u0012\u0004%\t!H\u0001\r_\u001a4\u0007*Z1q+N\fw-\u001a\u0005\f\u0003_\fiM!a\u0001\n\u0003\t\t0\u0001\tpM\u001aDU-\u00199Vg\u0006<Wm\u0018\u0013fcR!\u0011Q\\Az\u0011%\tI%!<\u0002\u0002\u0003\u0007a\u0004\u0003\u0006\u0002x\u00065'\u0011#Q!\ny\tQb\u001c4g\u0011\u0016\f\u0007/V:bO\u0016\u0004\u0003\"\u00033\u0002N\nE\r\u0011\"\u0001\u001e\u0011-\ti0!4\u0003\u0002\u0004%\t!a@\u0002\u001b\u0011L7o[+tC\u001e,w\fJ3r)\u0011\tiN!\u0001\t\u0013\u0005%\u00131`A\u0001\u0002\u0004q\u0002\"\u00034\u0002N\nE\t\u0015)\u0003\u001f\u0011\u001d\u0001\u0014Q\u001aC\u0001\u0005\u000f!\u0002B!\u0003\u0003\f\t5!q\u0002\t\u0004e\u00065\u0007bBAk\u0005\u000b\u0001\rA\b\u0005\b\u0003W\u0014)\u00011\u0001\u001f\u0011\u0019!'Q\u0001a\u0001=!Iq/!4\u0002\u0002\u0013\u0005!1\u0003\u000b\t\u0005\u0013\u0011)Ba\u0006\u0003\u001a!I\u0011Q\u001bB\t!\u0003\u0005\rA\b\u0005\n\u0003W\u0014\t\u0002%AA\u0002yA\u0001\u0002\u001aB\t!\u0003\u0005\rA\b\u0005\t{\u00065\u0017\u0013!C\u0001}\"I\u0011QCAg#\u0003%\tA \u0005\n\u00033\ti-%A\u0005\u0002yD!\"!\t\u0002N\u0006\u0005I\u0011IA\u0012\u0011)\t9$!4\u0002\u0002\u0013\u0005\u0011\u0011\b\u0005\u000b\u0003{\ti-!A\u0005\u0002\t\u001dB\u0003BA!\u0005SA\u0011\"!\u0013\u0003&\u0005\u0005\t\u0019\u0001\"\t\u0015\u00055\u0013QZA\u0001\n\u0003\ny\u0005\u0003\u0006\u0002\\\u00055\u0017\u0011!C\u0001\u0005_!B!a\u0018\u00032!Q\u0011\u0011\nB\u0017\u0003\u0003\u0005\r!!\u0011\t\u0015\u0005%\u0014QZA\u0001\n\u0003\nY\u0007\u0003\u0006\u0002p\u00055\u0017\u0011!C!\u0003cB!\"!\u001e\u0002N\u0006\u0005I\u0011\tB\u001d)\u0011\tyFa\u000f\t\u0015\u0005%#qGA\u0001\u0002\u0004\t\teB\u0005\u0003@\u0001\t\t\u0011#\u0003\u0003B\u0005\tbj\u001c8SI\u0012\u001cFo\u001c:bO\u0016LeNZ8\u0011\u0007I\u0014\u0019EB\u0005\u0002P\u0002\t\t\u0011#\u0003\u0003FM)!1\tB$9BI\u0011qQAG=yq\"\u0011\u0002\u0005\ba\t\rC\u0011\u0001B&)\t\u0011\t\u0005\u0003\u0006\u0002p\t\r\u0013\u0011!C#\u0003cB!\"!'\u0003D\u0005\u0005I\u0011\u0011B))!\u0011IAa\u0015\u0003V\t]\u0003bBAk\u0005\u001f\u0002\rA\b\u0005\b\u0003W\u0014y\u00051\u0001\u001f\u0011\u0019!'q\na\u0001=!Q\u0011Q\u0015B\"\u0003\u0003%\tIa\u0017\u0015\t\tu#\u0011\r\t\u0005\u001b\u001d\u0012y\u0006\u0005\u0004\u000e\u0003[sbD\b\u0005\u000b\u0003g\u0013I&!AA\u0002\t%\u0001BCA\\\u0005\u0007\n\t\u0011\"\u0003\u0002:\"I!q\r\u0001C\u0002\u0013%!\u0011N\u0001\u0013?:|gN\u00153e'R|'/Y4f\u0013:4w.\u0006\u0002\u0003\n!A!Q\u000e\u0001!\u0002\u0013\u0011I!A\n`]>t'\u000b\u001a3Ti>\u0014\u0018mZ3J]\u001a|\u0007\u0005\u0003\u00041\u0001\u0011\u0005!\u0011\u000f\u000b\fe\tM$q\u000fB=\u0005w\u0012i\bC\u0004\u0003v\t=\u0004\u0019A\u000b\u0002\t\tl\u0017\u000e\u001a\u0005\u00079\t=\u0004\u0019\u0001\u0010\t\r\u0011\u0012y\u00071\u0001'\u0011\u0019a#q\u000ea\u0001M!A!q\u0010B8\u0001\u0004\u0011\t)A\u0007j]&$\u0018.\u00197CY>\u001c7n\u001d\t\u0007\u0003'\u0012\u0019\tS&\n\u0005\u001ds\u0004b\u0002BD\u0001\u0011\u0005!\u0011R\u0001\u0007E2|7m[:\u0016\u0005\t\u0005\u0005b\u0002BG\u0001\u0011\u0005!\u0011R\u0001\ne\u0012$'\t\\8dWNDqA!%\u0001\t\u0003\u0011\u0019*A\u0007sI\u0012\u0014En\\2lg\nK\u0018\n\u001a\u000b\u0005\u0005\u0003\u0013)\nC\u0004\u0003\u0018\n=\u0005\u0019\u0001\"\u0002\u000bI$G-\u00133\t\u0011\tm\u0005\u0001\"\u0001\u0005\u0005;\u000b\u0001\"\u00193e\u00052|7m\u001b\u000b\u0007\u0003;\u0014yJa)\t\u000f\t\u0005&\u0011\u0014a\u0001\u0011\u00069!\r\\8dW&#\u0007b\u0002BS\u00053\u0003\raS\u0001\fE2|7m[*uCR,8\u000f\u0003\u0005\u0003*\u0002!\t\u0001\u0002BV\u0003-)\b\u000fZ1uK\ncwnY6\u0015\r\u0005u'Q\u0016BX\u0011\u001d\u0011\tKa*A\u0002!CqA!*\u0003(\u0002\u00071\n\u0003\u0005\u00034\u0002!\t\u0001\u0002B[\u0003-\u0011X-\\8wK\ncwnY6\u0015\t\t]&\u0011\u0018\t\u0004\u001b\u001dZ\u0005b\u0002BQ\u0005c\u0003\r\u0001\u0013\u0005\b\u0005{\u0003A\u0011\u0001B`\u00035\u0019wN\u001c;bS:\u001c(\t\\8dWR!\u0011q\fBa\u0011\u001d\u0011\tKa/A\u0002!CqA!2\u0001\t\u0003\u00119-\u0001\u0005hKR\u0014En\\2l)\u0011\u00119L!3\t\u000f\t\u0005&1\u0019a\u0001\u0011\"9!Q\u001a\u0001\u0005\u0002\u0005e\u0012!\u00038v[\ncwnY6t\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0003s\tAB\\;n%\u0012$'\t\\8dWNDqA!6\u0001\t\u0003\u00119.\u0001\tok6\u0014F\r\u001a\"m_\u000e\\7OQ=JIR\u0019!I!7\t\u000f\t]%1\u001ba\u0001\u0005\"1!Q\u001c\u0001\u0005\u0002u\ta!\\1y\u001b\u0016l\u0007B\u0002Bq\u0001\u0011\u0005Q$\u0001\u0007nK6\u0014V-\\1j]&tw\r\u0003\u0004\u0003f\u0002!\t!H\u0001\nG\u0006\u001c\u0007.Z*ju\u0016DaA!;\u0001\t\u0003i\u0012aB7f[V\u001bX\r\u001a\u0005\u0007\u0005[\u0004A\u0011A\u0013\u0002%=t\u0007*Z1q\u001b\u0016l'+Z7bS:Lgn\u001a\u0005\u0007\u0005c\u0004A\u0011A\u0013\u0002'=4g\rS3ba6+WNU3nC&t\u0017N\\4\t\r\tU\b\u0001\"\u0001&\u00035yg\u000eS3ba6+W.V:fI\"1!\u0011 \u0001\u0005\u0002\u0015\nab\u001c4g\u0011\u0016\f\u0007/T3n+N,G\r\u0003\u0004\u0003~\u0002!\t!J\u0001\u0010_:DU-\u00199DC\u000eDWmU5{K\"11\u0011\u0001\u0001\u0005\u0002\u0015\n\u0001c\u001c4g\u0011\u0016\f\u0007oQ1dQ\u0016\u001c\u0016N_3\t\r\r\u0015\u0001\u0001\"\u0001\u001e\u0003!!\u0017n]6Vg\u0016$\u0007bBB\u0005\u0001\u0011\u000511B\u0001\r[\u0016lWk]3e\u0005f\u0014F\r\u001a\u000b\u0004=\r5\u0001b\u0002BL\u0007\u000f\u0001\rA\u0011\u0005\b\u0007#\u0001A\u0011AB\n\u00035!\u0017n]6Vg\u0016$')\u001f*eIR\u0019ad!\u0006\t\u000f\t]5q\u0002a\u0001\u0005\"91\u0011\u0004\u0001\u0005\u0002\rm\u0011a\u0004:eIN#xN]1hK2+g/\u001a7\u0015\t\ru1q\u0004\t\u0004\u001b\u001dR\u0007b\u0002BL\u0007/\u0001\rA\u0011\u0005\b\u0007G\u0001A\u0011BB\u0013\u0003E)\b\u000fZ1uKN#xN]1hK&sgm\u001c\u000b\u0007\u0003;\u001c9c!\u000b\t\u000f\t\u00056\u0011\u0005a\u0001\u0011\"911FB\u0011\u0001\u0004Y\u0015A\u00048fo\ncwnY6Ti\u0006$Xo\u001d\u0015\b\u0001\r=2QGB\u001d!\ri1\u0011G\u0005\u0004\u0007gq!A\u00033faJ,7-\u0019;fI\u0006\u00121qG\u0001?)\"L7\u000fI2mCN\u001c\b%\\1zA\t,\u0007E]3n_Z,G\rI8sA5\fG-\u001a\u0011qe&4\u0018\r^3!S:\u0004\u0013\r\t4viV\u0014X\r\t:fY\u0016\f7/\u001a\u0018\"\u0005\rm\u0012!\u0002\u001a/e9\u0002\u0004f\u0001\u0001\u0004@A!1\u0011IB#\u001b\t\u0019\u0019EC\u0002\u0002\u000e\u0011IAaa\u0012\u0004D\taA)\u001a<fY>\u0004XM]!qS\u0002")
public class StorageStatus {
    private final BlockManagerId blockManagerId;
    private final long maxMemory;
    private final Option<Object> maxOnHeapMem;
    private final Option<Object> maxOffHeapMem;
    private final HashMap<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> _rddBlocks;
    private final HashMap<BlockId, BlockStatus> _nonRddBlocks;
    private final HashMap<Object, RddStorageInfo> org$apache$spark$storage$StorageStatus$$_rddStorageInfo;
    private final NonRddStorageInfo org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo;
    private volatile StorageStatus$RddStorageInfo$ RddStorageInfo$module;
    private volatile StorageStatus$NonRddStorageInfo$ NonRddStorageInfo$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StorageStatus$RddStorageInfo$ org$apache$spark$storage$StorageStatus$$RddStorageInfo$lzycompute() {
        StorageStatus storageStatus2 = this;
        synchronized (storageStatus2) {
            if (this.RddStorageInfo$module != null) return this.RddStorageInfo$module;
            this.RddStorageInfo$module = new StorageStatus$RddStorageInfo$(this);
            return this.RddStorageInfo$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StorageStatus$NonRddStorageInfo$ org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$lzycompute() {
        StorageStatus storageStatus2 = this;
        synchronized (storageStatus2) {
            if (this.NonRddStorageInfo$module != null) return this.NonRddStorageInfo$module;
            this.NonRddStorageInfo$module = new StorageStatus$NonRddStorageInfo$(this);
            return this.NonRddStorageInfo$module;
        }
    }

    public BlockManagerId blockManagerId() {
        return this.blockManagerId;
    }

    public long maxMemory() {
        return this.maxMemory;
    }

    public Option<Object> maxOnHeapMem() {
        return this.maxOnHeapMem;
    }

    public Option<Object> maxOffHeapMem() {
        return this.maxOffHeapMem;
    }

    private HashMap<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> _rddBlocks() {
        return this._rddBlocks;
    }

    private HashMap<BlockId, BlockStatus> _nonRddBlocks() {
        return this._nonRddBlocks;
    }

    public StorageStatus$RddStorageInfo$ org$apache$spark$storage$StorageStatus$$RddStorageInfo() {
        return this.RddStorageInfo$module == null ? this.org$apache$spark$storage$StorageStatus$$RddStorageInfo$lzycompute() : this.RddStorageInfo$module;
    }

    public HashMap<Object, RddStorageInfo> org$apache$spark$storage$StorageStatus$$_rddStorageInfo() {
        return this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo;
    }

    public StorageStatus$NonRddStorageInfo$ org$apache$spark$storage$StorageStatus$$NonRddStorageInfo() {
        return this.NonRddStorageInfo$module == null ? this.org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$lzycompute() : this.NonRddStorageInfo$module;
    }

    public NonRddStorageInfo org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo() {
        return this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo;
    }

    public Map<BlockId, BlockStatus> blocks() {
        return this._nonRddBlocks().$plus$plus(this.rddBlocks());
    }

    public Map<BlockId, BlockStatus> rddBlocks() {
        return (Map)this._rddBlocks().flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Map<BlockId, BlockStatus> apply(Tuple2<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> x0$2) {
                Tuple2<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> tuple2 = x0$2;
                if (tuple2 != null) {
                    scala.collection.mutable.Map blocks;
                    scala.collection.mutable.Map map2 = blocks = (scala.collection.mutable.Map)tuple2._2();
                    return map2;
                }
                throw new MatchError(tuple2);
            }
        }, HashMap$.MODULE$.canBuildFrom());
    }

    public Map<BlockId, BlockStatus> rddBlocksById(int rddId) {
        return (Map)this._rddBlocks().getOrElse((Object)BoxesRunTime.boxToInteger((int)rddId), (Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<BlockId, Nothing$> apply() {
                return Map$.MODULE$.empty();
            }
        });
    }

    public void addBlock(BlockId blockId, BlockStatus blockStatus2) {
        this.updateStorageInfo(blockId, blockStatus2);
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            ((scala.collection.mutable.MapLike)this._rddBlocks().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rddId), (Function0)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final HashMap<BlockId, BlockStatus> apply() {
                    return new HashMap();
                }
            })).update((Object)blockId, (Object)blockStatus2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this._nonRddBlocks().update((Object)blockId, (Object)blockStatus2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void updateBlock(BlockId blockId, BlockStatus blockStatus2) {
        this.addBlock(blockId, blockStatus2);
    }

    public Option<BlockStatus> removeBlock(BlockId blockId) {
        Option option;
        this.updateStorageInfo(blockId, BlockStatus$.MODULE$.empty());
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            None$ none$;
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            if (this._rddBlocks().contains((Object)BoxesRunTime.boxToInteger((int)rddId))) {
                Option removed = ((scala.collection.mutable.MapLike)this._rddBlocks().apply((Object)BoxesRunTime.boxToInteger((int)rddId))).remove((Object)blockId);
                Object object = ((MapLike)this._rddBlocks().apply((Object)BoxesRunTime.boxToInteger((int)rddId))).isEmpty() ? this._rddBlocks().remove((Object)BoxesRunTime.boxToInteger((int)rddId)) : BoxedUnit.UNIT;
                none$ = removed;
            } else {
                none$ = None$.MODULE$;
            }
            option = none$;
        } else {
            option = this._nonRddBlocks().remove((Object)blockId);
        }
        return option;
    }

    public boolean containsBlock(BlockId blockId) {
        boolean bl;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            bl = this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).exists((Function1)new scala.Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$1;

                public final boolean apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$1) {
                    return x$1.contains((Object)this.blockId$1);
                }
                {
                    this.blockId$1 = blockId$1;
                }
            });
        } else {
            bl = this._nonRddBlocks().contains((Object)blockId);
        }
        return bl;
    }

    public Option<BlockStatus> getBlock(BlockId blockId) {
        Option option;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            option = this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).flatMap((Function1)new scala.Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$2;

                public final Option<BlockStatus> apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$2) {
                    return x$2.get((Object)this.blockId$2);
                }
                {
                    this.blockId$2 = blockId$2;
                }
            });
        } else {
            option = this._nonRddBlocks().get((Object)blockId);
        }
        return option;
    }

    public int numBlocks() {
        return this._nonRddBlocks().size() + this.numRddBlocks();
    }

    public int numRddBlocks() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this._rddBlocks().values().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$3) {
                return x$3.size();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public int numRddBlocksById(int rddId) {
        return BoxesRunTime.unboxToInt((Object)this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$4) {
                return x$4.size();
            }
        }).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
    }

    public long maxMem() {
        return this.maxMemory();
    }

    public long memRemaining() {
        return this.maxMem() - this.memUsed();
    }

    public long cacheSize() {
        return BoxesRunTime.unboxToLong((Object)this.onHeapCacheSize().getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })) + BoxesRunTime.unboxToLong((Object)this.offHeapCacheSize().getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public long memUsed() {
        return BoxesRunTime.unboxToLong((Object)this.onHeapMemUsed().getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })) + BoxesRunTime.unboxToLong((Object)this.offHeapMemUsed().getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public Option<Object> onHeapMemRemaining() {
        return this.maxOnHeapMem().flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final Option<Object> apply(long m) {
                return this.$outer.onHeapMemUsed().map((Function1)new scala.Serializable(this, m){
                    public static final long serialVersionUID = 0L;
                    private final long m$1;

                    public final long apply(long o) {
                        return this.apply$mcJJ$sp(o);
                    }

                    public long apply$mcJJ$sp(long o) {
                        return this.m$1 - o;
                    }
                    {
                        this.m$1 = m$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> offHeapMemRemaining() {
        return this.maxOffHeapMem().flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final Option<Object> apply(long m) {
                return this.$outer.offHeapMemUsed().map((Function1)new scala.Serializable(this, m){
                    public static final long serialVersionUID = 0L;
                    private final long m$2;

                    public final long apply(long o) {
                        return this.apply$mcJJ$sp(o);
                    }

                    public long apply$mcJJ$sp(long o) {
                        return this.m$2 - o;
                    }
                    {
                        this.m$2 = m$2;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> onHeapMemUsed() {
        return this.onHeapCacheSize().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(long x$5) {
                return this.apply$mcJJ$sp(x$5);
            }

            public long apply$mcJJ$sp(long x$5) {
                return x$5 + this.$outer.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().onHeapUsage();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> offHeapMemUsed() {
        return this.offHeapCacheSize().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(long x$6) {
                return this.apply$mcJJ$sp(x$6);
            }

            public long apply$mcJJ$sp(long x$6) {
                return x$6 + this.$outer.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().offHeapUsage();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> onHeapCacheSize() {
        return this.maxOnHeapMem().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(long x$7) {
                return this.apply$mcJJ$sp(x$7);
            }

            public long apply$mcJJ$sp(long x$7) {
                return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.$outer.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().collect((PartialFunction)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Tuple2<Object, RddStorageInfo>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        RddStorageInfo storageInfo;
                        A1 A1 = x1;
                        Object object = A1 != null && !(storageInfo = (RddStorageInfo)A1._2()).level().useOffHeap() ? BoxesRunTime.boxToLong((long)storageInfo.memoryUsage()) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<Object, RddStorageInfo> x1) {
                        RddStorageInfo storageInfo;
                        Tuple2<Object, RddStorageInfo> tuple2 = x1;
                        boolean bl = tuple2 != null && !(storageInfo = (RddStorageInfo)tuple2._2()).level().useOffHeap();
                        return bl;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> offHeapCacheSize() {
        return this.maxOffHeapMem().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(long x$8) {
                return this.apply$mcJJ$sp(x$8);
            }

            public long apply$mcJJ$sp(long x$8) {
                return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.$outer.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().collect((PartialFunction)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Tuple2<Object, RddStorageInfo>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        RddStorageInfo storageInfo;
                        A1 A1 = x2;
                        Object object = A1 != null && (storageInfo = (RddStorageInfo)A1._2()).level().useOffHeap() ? BoxesRunTime.boxToLong((long)storageInfo.memoryUsage()) : function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<Object, RddStorageInfo> x2) {
                        RddStorageInfo storageInfo;
                        Tuple2<Object, RddStorageInfo> tuple2 = x2;
                        boolean bl = tuple2 != null && (storageInfo = (RddStorageInfo)tuple2._2()).level().useOffHeap();
                        return bl;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public long diskUsed() {
        return this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().diskUsage() + BoxesRunTime.unboxToLong((Object)((TraversableOnce)this._rddBlocks().keys().toSeq().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(int rddId) {
                return this.apply$mcJI$sp(rddId);
            }

            public long apply$mcJI$sp(int rddId) {
                return this.$outer.diskUsedByRdd(rddId);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long memUsedByRdd(int rddId) {
        return BoxesRunTime.unboxToLong((Object)this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RddStorageInfo x$9) {
                return x$9.memoryUsage();
            }
        }).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public long diskUsedByRdd(int rddId) {
        return BoxesRunTime.unboxToLong((Object)this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RddStorageInfo x$10) {
                return x$10.diskUsage();
            }
        }).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public Option<StorageLevel> rddStorageLevel(int rddId) {
        return this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StorageLevel apply(RddStorageInfo x$11) {
                return x$11.level();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateStorageInfo(BlockId blockId, BlockStatus newBlockStatus) {
        Tuple2.mcJJ.sp sp2;
        Tuple2.mcJJ.sp sp3;
        BlockStatus oldBlockStatus = (BlockStatus)this.getBlock(blockId).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BlockStatus apply() {
                return BlockStatus$.MODULE$.empty();
            }
        });
        long changeInMem = newBlockStatus.memSize() - oldBlockStatus.memSize();
        long changeInDisk = newBlockStatus.diskSize() - oldBlockStatus.diskSize();
        StorageLevel level = newBlockStatus.storageLevel();
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            sp3 = (Tuple2)this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new $anonfun$2(this)).getOrElse((Function0)new $anonfun$3(this));
        } else if (level.useOffHeap()) {
            if (!level.useOffHeap()) throw new MatchError((Object)blockId2);
            sp3 = new Tuple2.mcJJ.sp(this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().offHeapUsage(), this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().diskUsage());
        } else {
            sp3 = new Tuple2.mcJJ.sp(this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().onHeapUsage(), this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().diskUsage());
        }
        Tuple2.mcJJ.sp sp4 = sp3;
        if (sp4 == null) throw new MatchError((Object)sp4);
        long oldMem = sp4._1$mcJ$sp();
        long oldDisk = sp4._2$mcJ$sp();
        Tuple2.mcJJ.sp sp5 = sp2 = new Tuple2.mcJJ.sp(oldMem, oldDisk);
        long oldMem2 = sp5._1$mcJ$sp();
        long oldDisk2 = sp5._2$mcJ$sp();
        long newMem = package$.MODULE$.max(oldMem2 + changeInMem, 0L);
        long newDisk = package$.MODULE$.max(oldDisk2 + changeInDisk, 0L);
        BlockId blockId3 = blockId;
        if (blockId3 instanceof RDDBlockId) {
            BoxedUnit boxedUnit;
            RDDBlockId rDDBlockId = (RDDBlockId)blockId3;
            int rddId = rDDBlockId.rddId();
            if (newMem + newDisk == 0L) {
                this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().remove((Object)BoxesRunTime.boxToInteger((int)rddId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().update((Object)BoxesRunTime.boxToInteger((int)rddId), (Object)new RddStorageInfo(this, newMem, newDisk, level));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        } else {
            if (level.useOffHeap()) {
                this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().offHeapUsage_$eq(newMem);
            } else {
                this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().onHeapUsage_$eq(newMem);
            }
            this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().diskUsage_$eq(newDisk);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public StorageStatus(BlockManagerId blockManagerId, long maxMemory, Option<Object> maxOnHeapMem, Option<Object> maxOffHeapMem) {
        this.blockManagerId = blockManagerId;
        this.maxMemory = maxMemory;
        this.maxOnHeapMem = maxOnHeapMem;
        this.maxOffHeapMem = maxOffHeapMem;
        this._rddBlocks = new HashMap();
        this._nonRddBlocks = new HashMap();
        this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo = new HashMap();
        this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo = new NonRddStorageInfo(this, 0L, 0L, 0L);
    }

    public StorageStatus(BlockManagerId bmid, long maxMemory, Option<Object> maxOnHeapMem, Option<Object> maxOffHeapMem, Map<BlockId, BlockStatus> initialBlocks) {
        this(bmid, maxMemory, maxOnHeapMem, maxOffHeapMem);
        initialBlocks.foreach((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final void apply(Tuple2<BlockId, BlockStatus> x0$1) {
                Tuple2<BlockId, BlockStatus> tuple2 = x0$1;
                if (tuple2 != null) {
                    BlockId bid = (BlockId)tuple2._1();
                    BlockStatus bstatus = (BlockStatus)tuple2._2();
                    this.$outer.addBlock(bid, bstatus);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public class RddStorageInfo
    implements Product,
    scala.Serializable {
        private final long memoryUsage;
        private final long diskUsage;
        private final StorageLevel level;
        public final /* synthetic */ StorageStatus $outer;

        public long memoryUsage() {
            return this.memoryUsage;
        }

        public long diskUsage() {
            return this.diskUsage;
        }

        public StorageLevel level() {
            return this.level;
        }

        public RddStorageInfo copy(long memoryUsage, long diskUsage, StorageLevel level) {
            return new RddStorageInfo(this.org$apache$spark$storage$StorageStatus$RddStorageInfo$$$outer(), memoryUsage, diskUsage, level);
        }

        public long copy$default$1() {
            return this.memoryUsage();
        }

        public long copy$default$2() {
            return this.diskUsage();
        }

        public StorageLevel copy$default$3() {
            return this.level();
        }

        public String productPrefix() {
            return "RddStorageInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Serializable serializable;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    serializable = this.level();
                    break;
                }
                case 1: {
                    serializable = BoxesRunTime.boxToLong((long)this.diskUsage());
                    break;
                }
                case 0: {
                    serializable = BoxesRunTime.boxToLong((long)this.memoryUsage());
                }
            }
            return serializable;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RddStorageInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.memoryUsage()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.diskUsage()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.level()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RddStorageInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            RddStorageInfo rddStorageInfo = (RddStorageInfo)x$1;
            if (this.memoryUsage() != rddStorageInfo.memoryUsage()) return false;
            if (this.diskUsage() != rddStorageInfo.diskUsage()) return false;
            StorageLevel storageLevel = this.level();
            StorageLevel storageLevel2 = rddStorageInfo.level();
            if (storageLevel == null) {
                if (storageLevel2 != null) {
                    return false;
                }
            } else if (!((Object)storageLevel).equals(storageLevel2)) return false;
            if (!rddStorageInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ StorageStatus org$apache$spark$storage$StorageStatus$RddStorageInfo$$$outer() {
            return this.$outer;
        }

        public RddStorageInfo(StorageStatus $outer, long memoryUsage, long diskUsage, StorageLevel level) {
            this.memoryUsage = memoryUsage;
            this.diskUsage = diskUsage;
            this.level = level;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }

    public class NonRddStorageInfo
    implements Product,
    scala.Serializable {
        private long onHeapUsage;
        private long offHeapUsage;
        private long diskUsage;
        public final /* synthetic */ StorageStatus $outer;

        public long onHeapUsage() {
            return this.onHeapUsage;
        }

        public void onHeapUsage_$eq(long x$1) {
            this.onHeapUsage = x$1;
        }

        public long offHeapUsage() {
            return this.offHeapUsage;
        }

        public void offHeapUsage_$eq(long x$1) {
            this.offHeapUsage = x$1;
        }

        public long diskUsage() {
            return this.diskUsage;
        }

        public void diskUsage_$eq(long x$1) {
            this.diskUsage = x$1;
        }

        public NonRddStorageInfo copy(long onHeapUsage, long offHeapUsage, long diskUsage) {
            return new NonRddStorageInfo(this.org$apache$spark$storage$StorageStatus$NonRddStorageInfo$$$outer(), onHeapUsage, offHeapUsage, diskUsage);
        }

        public long copy$default$1() {
            return this.onHeapUsage();
        }

        public long copy$default$2() {
            return this.offHeapUsage();
        }

        public long copy$default$3() {
            return this.diskUsage();
        }

        public String productPrefix() {
            return "NonRddStorageInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Long l;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    l = BoxesRunTime.boxToLong((long)this.diskUsage());
                    break;
                }
                case 1: {
                    l = BoxesRunTime.boxToLong((long)this.offHeapUsage());
                    break;
                }
                case 0: {
                    l = BoxesRunTime.boxToLong((long)this.onHeapUsage());
                }
            }
            return l;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NonRddStorageInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.onHeapUsage()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.offHeapUsage()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.diskUsage()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NonRddStorageInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            NonRddStorageInfo nonRddStorageInfo = (NonRddStorageInfo)x$1;
            if (this.onHeapUsage() != nonRddStorageInfo.onHeapUsage()) return false;
            if (this.offHeapUsage() != nonRddStorageInfo.offHeapUsage()) return false;
            if (this.diskUsage() != nonRddStorageInfo.diskUsage()) return false;
            if (!nonRddStorageInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ StorageStatus org$apache$spark$storage$StorageStatus$NonRddStorageInfo$$$outer() {
            return this.$outer;
        }

        public NonRddStorageInfo(StorageStatus $outer, long onHeapUsage, long offHeapUsage, long diskUsage) {
            this.onHeapUsage = onHeapUsage;
            this.offHeapUsage = offHeapUsage;
            this.diskUsage = diskUsage;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

