/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.ByteBufferBlockData;
import org.apache.spark.storage.CountingWritableChannel;
import org.apache.spark.storage.DiskBlockManager;
import org.apache.spark.storage.EncryptedBlockData;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import org.spark_project.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\u0001\u0003\u0001\u0011Q!!\u0003#jg.\u001cFo\u001c:f\u0015\t\u0019A!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0012!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0011!#F\u0007\u0002')\u0011A\u0003B\u0001\tS:$XM\u001d8bY&\u0011ac\u0005\u0002\b\u0019><w-\u001b8h\u0011!A\u0002A!A!\u0002\u0013Q\u0012\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002\u001c95\tA!\u0003\u0002\u001e\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005YA-[:l\u001b\u0006t\u0017mZ3s!\t\t#%D\u0001\u0003\u0013\t\u0019#A\u0001\tESN\\'\t\\8dW6\u000bg.Y4fe\"AQ\u0005\u0001B\u0001B\u0003%a%A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\tYr%\u0003\u0002)\t\ty1+Z2ve&$\u00180T1oC\u001e,'\u000fC\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0005Y5rs\u0006\u0005\u0002\"\u0001!)\u0001$\u000ba\u00015!)q$\u000ba\u0001A!)Q%\u000ba\u0001M!9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0014!E7j]6+Wn\u001c:z\u001b\u0006\u0004()\u001f;fgV\t1\u0007\u0005\u0002\ri%\u0011Q'\u0004\u0002\u0005\u0019>tw\r\u0003\u00048\u0001\u0001\u0006IaM\u0001\u0013[&tW*Z7pefl\u0015\r\u001d\"zi\u0016\u001c\b\u0005C\u0004:\u0001\t\u0007I\u0011\u0002\u001e\u0002\u0015\tdwnY6TSj,7/F\u0001<!\u0011a4)R\u001a\u000e\u0003uR!AP \u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002A\u0003\u0006!Q\u000f^5m\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!\u0001R\u001f\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002G\u0013:\u0011AbR\u0005\u0003\u00116\ta\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001*\u0004\u0005\u0007\u001b\u0002\u0001\u000b\u0011B\u001e\u0002\u0017\tdwnY6TSj,7\u000f\t\u0005\u0006\u001f\u0002!\t\u0001U\u0001\bO\u0016$8+\u001b>f)\t\u0019\u0014\u000bC\u0003S\u001d\u0002\u00071+A\u0004cY>\u001c7.\u00133\u0011\u0005\u0005\"\u0016BA+\u0003\u0005\u001d\u0011En\\2l\u0013\u0012DQa\u0016\u0001\u0005\u0002a\u000b1\u0001];u)\tI&\u000e\u0006\u0002[;B\u0011AbW\u0005\u000396\u0011A!\u00168ji\")aL\u0016a\u0001?\u0006IqO]5uK\u001a+hn\u0019\t\u0005\u0019\u0001\u0014',\u0003\u0002b\u001b\tIa)\u001e8di&|g.\r\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\f\u0001b\u00195b]:,Gn\u001d\u0006\u0003O\u0006\u000b1A\\5p\u0013\tIGMA\nXe&$\u0018M\u00197f\u0005f$Xm\u00115b]:,G\u000eC\u0003S-\u0002\u00071\u000bC\u0003m\u0001\u0011\u0005Q.\u0001\u0005qkR\u0014\u0015\u0010^3t)\rQfn\u001c\u0005\u0006%.\u0004\ra\u0015\u0005\u0006a.\u0004\r!]\u0001\u0006Ef$Xm\u001d\t\u0003eZl\u0011a\u001d\u0006\u0003iV\f!![8\u000b\u0005\u0001#\u0011BA<t\u0005E\u0019\u0005.\u001e8lK\u0012\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006s\u0002!\tA_\u0001\tO\u0016$()\u001f;fgR\u00111P \t\u0003CqL!! \u0002\u0003\u0013\tcwnY6ECR\f\u0007\"\u0002*y\u0001\u0004\u0019\u0006bBA\u0001\u0001\u0011\u0005\u00111A\u0001\u0007e\u0016lwN^3\u0015\t\u0005\u0015\u00111\u0002\t\u0004\u0019\u0005\u001d\u0011bAA\u0005\u001b\t9!i\\8mK\u0006t\u0007\"\u0002*\u0000\u0001\u0004\u0019\u0006bBA\b\u0001\u0011\u0005\u0011\u0011C\u0001\tG>tG/Y5ogR!\u0011QAA\n\u0011\u0019\u0011\u0016Q\u0002a\u0001'\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0011\u0001D8qK:4uN],sSR,Gc\u00012\u0002\u001c!A\u0011QDA\u000b\u0001\u0004\ty\"\u0001\u0003gS2,\u0007\u0003BA\u0011\u0003Ki!!a\t\u000b\u0005Q\f\u0015\u0002BA\u0014\u0003G\u0011AAR5mK\u0002")
public class DiskStore
implements Logging {
    public final SparkConf org$apache$spark$storage$DiskStore$$conf;
    private final DiskBlockManager diskManager;
    private final SecurityManager securityManager;
    private final long minMemoryMapBytes;
    private final ConcurrentHashMap<String, Object> blockSizes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private long minMemoryMapBytes() {
        return this.minMemoryMapBytes;
    }

    private ConcurrentHashMap<String, Object> blockSizes() {
        return this.blockSizes;
    }

    public long getSize(BlockId blockId) {
        return BoxesRunTime.unboxToLong((Object)this.blockSizes().get(blockId.name()));
    }

    /*
     * Unable to fully structure code
     */
    public void put(BlockId blockId, Function1<WritableByteChannel, BoxedUnit> writeFunc) {
        if (this.contains(blockId)) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Block ", " is already present in the disk store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blockId})));
        }
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to put block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
        startTime = System.currentTimeMillis();
        file = this.diskManager.getFile(blockId);
        out = new CountingWritableChannel(this.openForWrite(file));
        threwException = true;
        writeFunc.apply((Object)out);
        this.blockSizes().put(blockId.name(), BoxesRunTime.boxToLong((long)out.getCount()));
        threwException = false;
        out.close();
        catch (Throwable var8_7) {
            try {
                out.close();
            }
            catch (IOException var9_8) {
                if (threwException) {
                }
                ** GOTO lbl-1000
            }
lbl25:
            // 2 sources

            throw var8_7;
lbl-1000:
            // 1 sources

            {
                threwException = true;
                throw var9_8;
            }
            finally {
                if (!threwException) ** continue;
                this.remove(blockId);
            }
        }
        ** GOTO lbl25
        catch (IOException var9_9) {
            if (threwException) {
            }
            ** GOTO lbl-1000
        }
        while (true) {
            finishTime = System.currentTimeMillis();
            this.logDebug((Function0<String>)new Serializable(this, startTime, file, finishTime){
                public static final long serialVersionUID = 0L;
                private final long startTime$1;
                private final File file$1;
                private final long finishTime$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Block %s stored as %s file on disk in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1.getName(), Utils$.MODULE$.bytesToString(this.file$1.length()), BoxesRunTime.boxToLong((long)(this.finishTime$1 - this.startTime$1))}));
                }
                {
                    this.startTime$1 = startTime$1;
                    this.file$1 = file$1;
                    this.finishTime$1 = finishTime$1;
                }
            });
            return;
        }
lbl-1000:
        // 1 sources

        {
            var7_6 = true;
            throw var9_9;
        }
        finally {
            if (!threwException) ** continue;
            this.remove(blockId);
        }
    }

    public void putBytes(BlockId blockId, ChunkedByteBuffer bytes) {
        this.put(blockId, (Function1<WritableByteChannel, BoxedUnit>)new Serializable(this, bytes){
            public static final long serialVersionUID = 0L;
            private final ChunkedByteBuffer bytes$1;

            public final void apply(WritableByteChannel channel) {
                this.bytes$1.writeFully(channel);
            }
            {
                this.bytes$1 = bytes$1;
            }
        });
    }

    public BlockData getBytes(BlockId blockId) {
        BlockData blockData;
        File file = this.diskManager.getFile(blockId.name());
        long blockSize = this.getSize(blockId);
        Option<byte[]> option = this.securityManager.getIOEncryptionKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            byte[] key = (byte[])some.x();
            blockData = new EncryptedBlockData(file, blockSize, this.org$apache$spark$storage$DiskStore$$conf, key);
        } else {
            FileChannel channel = new FileInputStream(file).getChannel();
            blockData = blockSize < this.minMemoryMapBytes() ? (BlockData)Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, blockSize, channel){
                public static final long serialVersionUID = 0L;
                private final long blockSize$1;
                private final FileChannel channel$1;

                public final ByteBufferBlockData apply() {
                    ByteBuffer buf = ByteBuffer.allocate((int)this.blockSize$1);
                    JavaUtils.readFully((ReadableByteChannel)this.channel$1, (ByteBuffer)buf);
                    buf.flip();
                    return new ByteBufferBlockData(new ChunkedByteBuffer(buf), true);
                }
                {
                    this.blockSize$1 = blockSize$1;
                    this.channel$1 = channel$1;
                }
            }, (Function0<BoxedUnit>)new Serializable(this, channel){
                public static final long serialVersionUID = 0L;
                private final FileChannel channel$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.channel$1.close();
                }
                {
                    this.channel$1 = channel$1;
                }
            }) : (BlockData)Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, file, channel){
                public static final long serialVersionUID = 0L;
                private final File file$2;
                private final FileChannel channel$1;

                public final ByteBufferBlockData apply() {
                    return new ByteBufferBlockData(new ChunkedByteBuffer(this.channel$1.map(FileChannel.MapMode.READ_ONLY, 0L, this.file$2.length())), true);
                }
                {
                    this.file$2 = file$2;
                    this.channel$1 = channel$1;
                }
            }, (Function0<BoxedUnit>)new Serializable(this, channel){
                public static final long serialVersionUID = 0L;
                private final FileChannel channel$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.channel$1.close();
                }
                {
                    this.channel$1 = channel$1;
                }
            });
        }
        return blockData;
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(BlockId blockId) {
        boolean bl;
        this.blockSizes().remove(blockId.name());
        File file = this.diskManager.getFile(blockId.name());
        if (file.exists()) {
            void var3_3;
            boolean ret = file.delete();
            if (!ret) {
                this.logWarning((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final File file$3;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$3.getPath()}));
                    }
                    {
                        this.file$3 = file$3;
                    }
                });
            }
            bl = var3_3;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean contains(BlockId blockId) {
        File file = this.diskManager.getFile(blockId.name());
        return file.exists();
    }

    private WritableByteChannel openForWrite(File file) {
        FileChannel out = new FileOutputStream(file).getChannel();
        try {
            return (WritableByteChannel)this.securityManager.getIOEncryptionKey().map((Function1)new Serializable(this, out){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskStore $outer;
                private final FileChannel out$1;

                public final WritableByteChannel apply(byte[] key) {
                    return CryptoStreamUtils$.MODULE$.createWritableChannel(this.out$1, this.$outer.org$apache$spark$storage$DiskStore$$conf, key);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.out$1 = out$1;
                }
            }).getOrElse((Function0)new Serializable(this, out){
                public static final long serialVersionUID = 0L;
                private final FileChannel out$1;

                public final FileChannel apply() {
                    return this.out$1;
                }
                {
                    this.out$1 = out$1;
                }
            });
        }
        catch (Exception exception2) {
            Closeables.close((Closeable)out, (boolean)true);
            file.delete();
            throw exception2;
        }
    }

    public DiskStore(SparkConf conf, DiskBlockManager diskManager, SecurityManager securityManager) {
        this.org$apache$spark$storage$DiskStore$$conf = conf;
        this.diskManager = diskManager;
        this.securityManager = securityManager;
        Logging$class.$init$(this);
        this.minMemoryMapBytes = conf.getSizeAsBytes("spark.storage.memoryMapThreshold", "2m");
        this.blockSizes = new ConcurrentHashMap();
    }
}

