/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import com.codahale.metrics.Timer;
import java.util.Properties;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.AllJobsCancelled$;
import org.apache.spark.scheduler.BeginEvent;
import org.apache.spark.scheduler.CompletionEvent;
import org.apache.spark.scheduler.DAGScheduler;
import org.apache.spark.scheduler.DAGSchedulerEvent;
import org.apache.spark.scheduler.ExecutorAdded;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.ExecutorLost;
import org.apache.spark.scheduler.GettingResultEvent;
import org.apache.spark.scheduler.JobCancelled;
import org.apache.spark.scheduler.JobGroupCancelled;
import org.apache.spark.scheduler.JobListener;
import org.apache.spark.scheduler.JobSubmitted;
import org.apache.spark.scheduler.MapStageSubmitted;
import org.apache.spark.scheduler.ResubmitFailedStages$;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.StageCancelled;
import org.apache.spark.scheduler.Task;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.scheduler.TaskSet;
import org.apache.spark.scheduler.TaskSetFailed;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.EventLoop;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001U3Q!\u0001\u0002\u0001\u0005)\u0011A\u0004R!H'\u000eDW\rZ;mKJ,e/\u001a8u!J|7-Z:t\u0019>|\u0007O\u0003\u0002\u0004\t\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sON\u0019\u0001aC\u000b\u0011\u00071y\u0011#D\u0001\u000e\u0015\tqA!\u0001\u0003vi&d\u0017B\u0001\t\u000e\u0005%)e/\u001a8u\u0019>|\u0007\u000f\u0005\u0002\u0013'5\t!!\u0003\u0002\u0015\u0005\t\tB)Q$TG\",G-\u001e7fe\u00163XM\u001c;\u0011\u0005YIR\"A\f\u000b\u0005a!\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005i9\"a\u0002'pO\u001eLgn\u001a\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005aA-Y4TG\",G-\u001e7fe\u000e\u0001\u0001C\u0001\n \u0013\t\u0001#A\u0001\u0007E\u0003\u001e\u001b6\r[3ek2,'\u000fC\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0015\u0002\"A\u0005\u0001\t\u000bq\t\u0003\u0019\u0001\u0010\t\r\u001d\u0002\u0001\u0015!\u0003)\u0003\u0015!\u0018.\\3s!\tI\u0003'D\u0001+\u0015\tYC&A\u0004nKR\u0014\u0018nY:\u000b\u00055r\u0013\u0001C2pI\u0006D\u0017\r\\3\u000b\u0003=\n1aY8n\u0013\t\t$FA\u0003US6,'\u000fC\u00034\u0001\u0011\u0005C'A\u0005p]J+7-Z5wKR\u0011Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0005+:LG\u000fC\u0003=e\u0001\u0007\u0011#A\u0003fm\u0016tG\u000fC\u0003?\u0001\u0011%q(A\u0006e_>s'+Z2fSZ,GCA\u001bA\u0011\u0015aT\b1\u0001\u0012\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0003\u001dyg.\u0012:s_J$\"!\u000e#\t\u000b\u0015\u000b\u0005\u0019\u0001$\u0002\u0003\u0015\u0004\"aR(\u000f\u0005!keBA%M\u001b\u0005Q%BA&\u001e\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002Oo\u00059\u0001/Y2lC\u001e,\u0017B\u0001)R\u0005%!\u0006N]8xC\ndWM\u0003\u0002Oo!)1\u000b\u0001C!)\u00061qN\\*u_B$\u0012!\u000e")
public class DAGSchedulerEventProcessLoop
extends EventLoop<DAGSchedulerEvent>
implements Logging {
    private final DAGScheduler dagScheduler;
    private final Timer timer;

    @Override
    public void onReceive(DAGSchedulerEvent event) {
        Timer.Context timerContext = this.timer.time();
        try {
            this.doOnReceive(event);
            return;
        }
        finally {
            timerContext.stop();
        }
    }

    private void doOnReceive(DAGSchedulerEvent event) {
        DAGSchedulerEvent dAGSchedulerEvent;
        block15: {
            block3: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    SlaveLost slaveLost;
                                    boolean bl;
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                dAGSchedulerEvent = event;
                                                                if (!(dAGSchedulerEvent instanceof JobSubmitted)) break block2;
                                                                JobSubmitted jobSubmitted = (JobSubmitted)dAGSchedulerEvent;
                                                                int jobId = jobSubmitted.jobId();
                                                                RDD<?> rdd = jobSubmitted.finalRDD();
                                                                Function2<TaskContext, Iterator<Object>, ?> func = jobSubmitted.func();
                                                                int[] partitions2 = jobSubmitted.partitions();
                                                                CallSite callSite = jobSubmitted.callSite();
                                                                JobListener listener = jobSubmitted.listener();
                                                                Properties properties = jobSubmitted.properties();
                                                                this.dagScheduler.handleJobSubmitted(jobId, rdd, func, partitions2, callSite, listener, properties);
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                break block3;
                                                            }
                                                            if (!(dAGSchedulerEvent instanceof MapStageSubmitted)) break block4;
                                                            MapStageSubmitted mapStageSubmitted = (MapStageSubmitted)dAGSchedulerEvent;
                                                            int jobId = mapStageSubmitted.jobId();
                                                            ShuffleDependency<?, ?, ?> dependency = mapStageSubmitted.dependency();
                                                            CallSite callSite = mapStageSubmitted.callSite();
                                                            JobListener listener = mapStageSubmitted.listener();
                                                            Properties properties = mapStageSubmitted.properties();
                                                            this.dagScheduler.handleMapStageSubmitted(jobId, dependency, callSite, listener, properties);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block3;
                                                        }
                                                        if (!(dAGSchedulerEvent instanceof StageCancelled)) break block5;
                                                        StageCancelled stageCancelled = (StageCancelled)dAGSchedulerEvent;
                                                        int stageId = stageCancelled.stageId();
                                                        Option<String> reason = stageCancelled.reason();
                                                        this.dagScheduler.handleStageCancellation(stageId, reason);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block3;
                                                    }
                                                    if (!(dAGSchedulerEvent instanceof JobCancelled)) break block6;
                                                    JobCancelled jobCancelled = (JobCancelled)dAGSchedulerEvent;
                                                    int jobId = jobCancelled.jobId();
                                                    Option<String> reason = jobCancelled.reason();
                                                    this.dagScheduler.handleJobCancellation(jobId, reason);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                if (!(dAGSchedulerEvent instanceof JobGroupCancelled)) break block7;
                                                JobGroupCancelled jobGroupCancelled = (JobGroupCancelled)dAGSchedulerEvent;
                                                String groupId = jobGroupCancelled.groupId();
                                                this.dagScheduler.handleJobGroupCancelled(groupId);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            AllJobsCancelled$ allJobsCancelled$ = AllJobsCancelled$.MODULE$;
                                            DAGSchedulerEvent dAGSchedulerEvent2 = dAGSchedulerEvent;
                                            if (allJobsCancelled$ != null ? !allJobsCancelled$.equals(dAGSchedulerEvent2) : dAGSchedulerEvent2 != null) break block8;
                                            this.dagScheduler.doCancelAllJobs();
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(dAGSchedulerEvent instanceof ExecutorAdded)) break block9;
                                        ExecutorAdded executorAdded2 = (ExecutorAdded)dAGSchedulerEvent;
                                        String execId = executorAdded2.execId();
                                        String host = executorAdded2.host();
                                        this.dagScheduler.handleExecutorAdded(execId, host);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(dAGSchedulerEvent instanceof ExecutorLost)) break block10;
                                    ExecutorLost executorLost2 = (ExecutorLost)dAGSchedulerEvent;
                                    String execId = executorLost2.execId();
                                    ExecutorLossReason reason = executorLost2.reason();
                                    ExecutorLossReason executorLossReason = reason;
                                    boolean bl2 = executorLossReason instanceof SlaveLost && true == (bl = (slaveLost = (SlaveLost)executorLossReason).workerLost());
                                    boolean filesLost = bl2;
                                    this.dagScheduler.handleExecutorLost(execId, filesLost, this.dagScheduler.handleExecutorLost$default$3());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(dAGSchedulerEvent instanceof BeginEvent)) break block11;
                                BeginEvent beginEvent = (BeginEvent)dAGSchedulerEvent;
                                Task<?> task = beginEvent.task();
                                TaskInfo taskInfo = beginEvent.taskInfo();
                                this.dagScheduler.handleBeginEvent(task, taskInfo);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(dAGSchedulerEvent instanceof GettingResultEvent)) break block12;
                            GettingResultEvent gettingResultEvent = (GettingResultEvent)dAGSchedulerEvent;
                            TaskInfo taskInfo = gettingResultEvent.taskInfo();
                            this.dagScheduler.handleGetTaskResult(taskInfo);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(dAGSchedulerEvent instanceof CompletionEvent)) break block13;
                        CompletionEvent completionEvent = (CompletionEvent)dAGSchedulerEvent;
                        this.dagScheduler.handleTaskCompletion(completionEvent);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(dAGSchedulerEvent instanceof TaskSetFailed)) break block14;
                    TaskSetFailed taskSetFailed = (TaskSetFailed)dAGSchedulerEvent;
                    TaskSet taskSet = taskSetFailed.taskSet();
                    String reason = taskSetFailed.reason();
                    Option<Throwable> exception2 = taskSetFailed.exception();
                    this.dagScheduler.handleTaskSetFailed(taskSet, reason, exception2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                ResubmitFailedStages$ resubmitFailedStages$ = ResubmitFailedStages$.MODULE$;
                DAGSchedulerEvent dAGSchedulerEvent3 = dAGSchedulerEvent;
                if (resubmitFailedStages$ != null ? !resubmitFailedStages$.equals(dAGSchedulerEvent3) : dAGSchedulerEvent3 != null) break block15;
                this.dagScheduler.resubmitFailedStages();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)dAGSchedulerEvent);
    }

    @Override
    public void onError(Throwable e) {
        this.logError((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DAGSchedulerEventProcessLoop failed; shutting down SparkContext";
            }
        }, e);
        try {
            this.dagScheduler.doCancelAllJobs();
        }
        catch (Throwable throwable) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "DAGScheduler failed to cancel all jobs.";
                }
            }, throwable);
        }
        this.dagScheduler.sc().stopInNewThread();
    }

    @Override
    public void onStop() {
        this.dagScheduler.cleanUpAfterSchedulerStop();
    }

    public DAGSchedulerEventProcessLoop(DAGScheduler dagScheduler) {
        this.dagScheduler = dagScheduler;
        super("dag-scheduler-event-loop");
        this.timer = dagScheduler.metricsSource().messageProcessingTimer();
    }
}

