/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.StreamCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.rpc.RpcEndpointNotFoundException;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnvFileServer;
import org.apache.spark.rpc.RpcEnvStoppedException;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv$;
import org.apache.spark.rpc.netty.NettyRpcEnv$FileDownloadChannel$;
import org.apache.spark.rpc.netty.NettyRpcHandler;
import org.apache.spark.rpc.netty.NettyStreamManager;
import org.apache.spark.rpc.netty.OneWayOutboxMessage;
import org.apache.spark.rpc.netty.Outbox;
import org.apache.spark.rpc.netty.OutboxMessage;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcEndpointVerifier;
import org.apache.spark.rpc.netty.RpcEndpointVerifier$;
import org.apache.spark.rpc.netty.RpcFailure;
import org.apache.spark.rpc.netty.RpcOutboxMessage;
import org.apache.spark.serializer.JavaSerializerInstance;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001da!B\u0001\u0003\u0001\ta!a\u0003(fiRL(\u000b]2F]ZT!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u0001:qG*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bE\u0001\"AD\b\u000e\u0003\u0011I!\u0001\u0005\u0003\u0003\rI\u00038-\u00128w!\t\u0011R#D\u0001\u0014\u0015\t!b!\u0001\u0005j]R,'O\\1m\u0013\t12CA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!Q1A\u0005\u0002i\tAaY8oM\u000e\u0001Q#A\u000e\u0011\u0005qiR\"\u0001\u0004\n\u0005y1!!C*qCJ\\7i\u001c8g\u0011!\u0001\u0003A!A!\u0002\u0013Y\u0012!B2p]\u001a\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002-)\fg/Y*fe&\fG.\u001b>fe&s7\u000f^1oG\u0016\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u0015M,'/[1mSj,'/\u0003\u0002)K\t1\"*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003\u0011Awn\u001d;\u0011\u00051\u0012dBA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er\u0013A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u0018\t\u0011Y\u0002!\u0011!Q\u0001\n]\nqb]3dkJLG/_'b]\u0006<WM\u001d\t\u00039aJ!!\u000f\u0004\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJDQa\u000f\u0001\u0005\u0002q\na\u0001P5oSRtD#B\u001f@\u0001\u0006\u0013\u0005C\u0001 \u0001\u001b\u0005\u0011\u0001\"\u0002\r;\u0001\u0004Y\u0002\"\u0002\u0012;\u0001\u0004\u0019\u0003\"\u0002\u0016;\u0001\u0004Y\u0003\"\u0002\u001c;\u0001\u00049\u0004\u0002\u0003#\u0001\u0005\u0004%\tAA#\u0002\u001bQ\u0014\u0018M\\:q_J$8i\u001c8g+\u00051\u0005CA$M\u001b\u0005A%BA%K\u0003\u0011)H/\u001b7\u000b\u0005-3\u0011a\u00028fi^|'o[\u0005\u0003\u001b\"\u0013Q\u0002\u0016:b]N\u0004xN\u001d;D_:4\u0007BB(\u0001A\u0003%a)\u0001\bue\u0006t7\u000f]8si\u000e{gN\u001a\u0011\t\u000fE\u0003!\u0019!C\u0005%\u0006QA-[:qCR\u001c\u0007.\u001a:\u0016\u0003M\u0003\"A\u0010+\n\u0005U\u0013!A\u0003#jgB\fGo\u00195fe\"1q\u000b\u0001Q\u0001\nM\u000b1\u0002Z5ta\u0006$8\r[3sA!9\u0011\f\u0001b\u0001\n\u0013Q\u0016!D:ue\u0016\fW.T1oC\u001e,'/F\u0001\\!\tqD,\u0003\u0002^\u0005\t\u0011b*\u001a;usN#(/Z1n\u001b\u0006t\u0017mZ3s\u0011\u0019y\u0006\u0001)A\u00057\u0006q1\u000f\u001e:fC6l\u0015M\\1hKJ\u0004\u0003bB1\u0001\u0005\u0004%IAY\u0001\u0011iJ\fgn\u001d9peR\u001cuN\u001c;fqR,\u0012a\u0019\t\u0003I\u0016l\u0011AS\u0005\u0003M*\u0013\u0001\u0003\u0016:b]N\u0004xN\u001d;D_:$X\r\u001f;\t\r!\u0004\u0001\u0015!\u0003d\u0003E!(/\u00198ta>\u0014HoQ8oi\u0016DH\u000f\t\u0005\u0006U\u0002!Ia[\u0001\u0017GJ,\u0017\r^3DY&,g\u000e\u001e\"p_R\u001cHO]1qgR\tA\u000eE\u0002ncNl\u0011A\u001c\u0006\u0003\u0013>T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s]\n!A*[:u!\t!x/D\u0001v\u0015\t1(*\u0001\u0004dY&,g\u000e^\u0005\u0003qV\u0014\u0001\u0004\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e\"p_R\u001cHO]1q\u0011\u001dQ\bA1A\u0005\nm\fQb\u00197jK:$h)Y2u_JLX#\u0001?\u0011\u0005Ql\u0018B\u0001@v\u0005Y!&/\u00198ta>\u0014Ho\u00117jK:$h)Y2u_JL\bbBA\u0001\u0001\u0001\u0006I\u0001`\u0001\u000fG2LWM\u001c;GC\u000e$xN]=!\u0011)\t)\u0001\u0001a\u0001\u0002\u0004%Ia_\u0001\u0014M&dW\rR8x]2|\u0017\r\u001a$bGR|'/\u001f\u0005\f\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013\tY!A\fgS2,Gi\\<oY>\fGMR1di>\u0014\u0018p\u0018\u0013fcR!\u0011QBA\n!\ri\u0013qB\u0005\u0004\u0003#q#\u0001B+oSRD\u0011\"!\u0006\u0002\b\u0005\u0005\t\u0019\u0001?\u0002\u0007a$\u0013\u0007C\u0004\u0002\u001a\u0001\u0001\u000b\u0015\u0002?\u0002)\u0019LG.\u001a#po:dw.\u00193GC\u000e$xN]=!Q\u0011\t9\"!\b\u0011\u00075\ny\"C\u0002\u0002\"9\u0012\u0001B^8mCRLG.\u001a\u0005\n\u0003K\u0001!\u0019!C\u0001\u0003O\t\u0001\u0003^5nK>,HoU2iK\u0012,H.\u001a:\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=b.\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\r\u0002.\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0011\u0005]\u0002\u0001)A\u0005\u0003S\t\u0011\u0003^5nK>,HoU2iK\u0012,H.\u001a:!\u0011)\tY\u0004\u0001b\u0001\n\u0003\u0011\u0011QH\u0001\u0019G2LWM\u001c;D_:tWm\u0019;j_:,\u00050Z2vi>\u0014XCAA !\u0011\tY#!\u0011\n\t\u0005\r\u0013Q\u0006\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'\u000f\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA \u0003e\u0019G.[3oi\u000e{gN\\3di&|g.\u0012=fGV$xN\u001d\u0011\t\u0017\u0005-\u0003\u00011AA\u0002\u0013%\u0011QJ\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0005\u0005=\u0003\u0003BA)\u0003+j!!a\u0015\u000b\u0007\u0005-#*\u0003\u0003\u0002X\u0005M#a\u0004+sC:\u001c\bo\u001c:u'\u0016\u0014h/\u001a:\t\u0017\u0005m\u0003\u00011AA\u0002\u0013%\u0011QL\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fH\u0003BA\u0007\u0003?B!\"!\u0006\u0002Z\u0005\u0005\t\u0019AA(\u0011!\t\u0019\u0007\u0001Q!\n\u0005=\u0013aB:feZ,'\u000f\t\u0015\u0005\u0003C\ni\u0002C\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l\u000591\u000f^8qa\u0016$WCAA7!\u0011\ty'!\u001e\u000e\u0005\u0005E$\u0002BA:\u0003[\ta!\u0019;p[&\u001c\u0017\u0002BA<\u0003c\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002CA>\u0001\u0001\u0006I!!\u001c\u0002\u0011M$x\u000e\u001d9fI\u0002B\u0011\"a \u0001\u0005\u0004%I!!!\u0002\u0011=,HOY8yKN,\"!a!\u0011\u0011\u0005-\u0012QQAE\u0003\u001fKA!a\"\u0002.\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u00079\tY)C\u0002\u0002\u000e\u0012\u0011!B\u00159d\u0003\u0012$'/Z:t!\rq\u0014\u0011S\u0005\u0004\u0003'\u0013!AB(vi\n|\u0007\u0010\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BAB\u0003%yW\u000f\u001e2pq\u0016\u001c\b\u0005\u0003\u0005\u0002\u001c\u0002!\tAAAO\u00031\u0011X-\\8wK>+HOY8y)\u0011\ti!a(\t\u0011\u0005\u0005\u0016\u0011\u0014a\u0001\u0003\u0013\u000bq!\u00193ee\u0016\u001c8\u000fC\u0004\u0002&\u0002!\t!a*\u0002\u0017M$\u0018M\u001d;TKJ4XM\u001d\u000b\u0007\u0003\u001b\tI+!,\t\u000f\u0005-\u00161\u0015a\u0001W\u0005Y!-\u001b8e\u0003\u0012$'/Z:t\u0011!\ty+a)A\u0002\u0005E\u0016\u0001\u00029peR\u00042!LAZ\u0013\r\t)L\f\u0002\u0004\u0013:$\bBCAQ\u0001!\u0015\r\u0011\"\u0011\u0002:V\u0011\u0011\u0011\u0012\u0005\u000b\u0003{\u0003\u0001\u0012!Q!\n\u0005%\u0015\u0001C1eIJ,7o\u001d\u0011)\t\u0005m\u0016\u0011\u0019\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003\u0017\fQA[1wCbLA!a4\u0002F\nAa*\u001e7mC\ndW\rC\u0004\u0002T\u0002!\t%!6\u0002\u001bM,G/\u001e9F]\u0012\u0004x.\u001b8u)\u0019\t9.!8\u0002bB\u0019a\"!7\n\u0007\u0005mGA\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\t\u000f\u0005}\u0017\u0011\u001ba\u0001W\u0005!a.Y7f\u0011!\t\u0019/!5A\u0002\u0005\u0015\u0018\u0001C3oIB|\u0017N\u001c;\u0011\u00079\t9/C\u0002\u0002j\u0012\u00111B\u00159d\u000b:$\u0007o\\5oi\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\u0018AG1ts:\u001c7+\u001a;va\u0016sG\r]8j]R\u0014VM\u001a\"z+JKE\u0003BAy\u0003w\u0004b!a=\u0002x\u0006]WBAA{\u0015\r\tyCL\u0005\u0005\u0003s\f)P\u0001\u0004GkR,(/\u001a\u0005\b\u0003{\fY\u000f1\u0001,\u0003\r)(/\u001b\u0005\b\u0005\u0003\u0001A\u0011\tB\u0002\u0003\u0011\u0019Ho\u001c9\u0015\t\u00055!Q\u0001\u0005\t\u0005\u000f\ty\u00101\u0001\u0002X\u0006YQM\u001c3q_&tGOU3g\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005\u001b\tA\u0002]8tiR{w*\u001e;c_b$b!!\u0004\u0003\u0010\te\u0001\u0002\u0003B\t\u0005\u0013\u0001\rAa\u0005\u0002\u0011I,7-Z5wKJ\u00042A\u0010B\u000b\u0013\r\u00119B\u0001\u0002\u0014\u001d\u0016$H/\u001f*qG\u0016sG\r]8j]R\u0014VM\u001a\u0005\t\u00057\u0011I\u00011\u0001\u0003\u001e\u00059Q.Z:tC\u001e,\u0007c\u0001 \u0003 %\u0019!\u0011\u0005\u0002\u0003\u001b=+HOY8y\u001b\u0016\u001c8/Y4f\u0011!\u0011)\u0003\u0001C\u0001\u0005\t\u001d\u0012\u0001B:f]\u0012$B!!\u0004\u0003*!A!1\u0004B\u0012\u0001\u0004\u0011Y\u0003E\u0002?\u0005[I1Aa\f\u0003\u00059\u0011V-];fgRlUm]:bO\u0016D\u0001Ba\r\u0001\t\u0003\u0011!QG\u0001\rGJ,\u0017\r^3DY&,g\u000e\u001e\u000b\u0005\u0005o\u0011i\u0004E\u0002u\u0005sI1Aa\u000fv\u0005=!&/\u00198ta>\u0014Ho\u00117jK:$\b\u0002CAQ\u0005c\u0001\r!!#\t\u0011\t\u0005\u0003\u0001\"\u0001\u0003\u0005\u0007\n1!Y:l+\u0011\u0011)Ea\u0014\u0015\r\t\u001d#\u0011\u000fB:)\u0011\u0011IE!\u0019\u0011\r\u0005M\u0018q\u001fB&!\u0011\u0011iEa\u0014\r\u0001\u0011A!\u0011\u000bB \u0005\u0004\u0011\u0019FA\u0001U#\u0011\u0011)Fa\u0017\u0011\u00075\u00129&C\u0002\u0003Z9\u0012qAT8uQ&tw\rE\u0002.\u0005;J1Aa\u0018/\u0005\r\te.\u001f\u0005\u000b\u0005G\u0012y$!AA\u0004\t\u0015\u0014AC3wS\u0012,gnY3%cA1!q\rB7\u0005\u0017j!A!\u001b\u000b\u0007\t-d&A\u0004sK\u001adWm\u0019;\n\t\t=$\u0011\u000e\u0002\t\u00072\f7o\u001d+bO\"A!1\u0004B \u0001\u0004\u0011Y\u0003\u0003\u0005\u0003v\t}\u0002\u0019\u0001B<\u0003\u001d!\u0018.\\3pkR\u00042A\u0004B=\u0013\r\u0011Y\b\u0002\u0002\u000b%B\u001cG+[7f_V$\b\u0002\u0003B@\u0001\u0011\u0005!A!!\u0002\u0013M,'/[1mSj,G\u0003\u0002BB\u0005\u001f\u0003BA!\"\u0003\f6\u0011!q\u0011\u0006\u0004\u0005\u0013{\u0017a\u00018j_&!!Q\u0012BD\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\t\u0005#\u0013i\b1\u0001\u0003\\\u000591m\u001c8uK:$\b\u0002\u0003BK\u0001\u0011\u0005!Aa&\u0002\u001fM,'/[1mSj,7\u000b\u001e:fC6$BA!'\u0003 B\u0019AEa'\n\u0007\tuUEA\nTKJL\u0017\r\\5{CRLwN\\*ue\u0016\fW\u000e\u0003\u0005\u0003\"\nM\u0005\u0019\u0001BR\u0003\ryW\u000f\u001e\t\u0005\u0005K\u0013Y+\u0004\u0002\u0003(*\u0019!\u0011V8\u0002\u0005%|\u0017\u0002\u0002BW\u0005O\u0013AbT;uaV$8\u000b\u001e:fC6D\u0001B!-\u0001\t\u0003\u0011!1W\u0001\fI\u0016\u001cXM]5bY&TX-\u0006\u0003\u00036\nmFC\u0002B\\\u0005\u0007\u0014)\r\u0006\u0003\u0003:\nu\u0006\u0003\u0002B'\u0005w#\u0001B!\u0015\u00030\n\u0007!1\u000b\u0005\u000b\u0005\u007f\u0013y+!AA\u0004\t\u0005\u0017AC3wS\u0012,gnY3%eA1!q\rB7\u0005sCqA\u001eBX\u0001\u0004\u00119\u0004\u0003\u0005\u0003H\n=\u0006\u0019\u0001BB\u0003\u0015\u0011\u0017\u0010^3t\u0011\u001d\u00119\u0001\u0001C!\u0005\u0017$B!a6\u0003N\"A\u00111\u001dBe\u0001\u0004\t)\u000fC\u0004\u0003R\u0002!\tEa5\u0002\u0011MDW\u000f\u001e3po:$\"!!\u0004\t\u000f\t]\u0007\u0001\"\u0011\u0003T\u0006\u0001\u0012m^1jiR+'/\\5oCRLwN\u001c\u0005\b\u00057\u0004A\u0011\u0002Bj\u0003\u001d\u0019G.Z1okBDqA!-\u0001\t\u0003\u0012y.\u0006\u0003\u0003b\n\u0015H\u0003\u0002Br\u0005O\u0004BA!\u0014\u0003f\u0012A!\u0011\u000bBo\u0005\u0004\u0011\u0019\u0006\u0003\u0005\u0003j\nu\u0007\u0019\u0001Bv\u0003U!Wm]3sS\u0006d\u0017N_1uS>t\u0017i\u0019;j_:\u0004R!\fBw\u0005GL1Aa</\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u0003t\u0002!\tE!>\u0002\u0015\u0019LG.Z*feZ,'/\u0006\u0002\u0003xB\u0019aB!?\n\u0007\tmHA\u0001\tSa\u000e,eN\u001e$jY\u0016\u001cVM\u001d<fe\"9!q \u0001\u0005B\r\u0005\u0011aC8qK:\u001c\u0005.\u00198oK2$Baa\u0001\u0004\u0010A!1QAB\u0006\u001b\t\u00199A\u0003\u0003\u0004\n\t\u001d\u0015\u0001C2iC:tW\r\\:\n\t\r51q\u0001\u0002\u0014%\u0016\fG-\u00192mK\nKH/Z\"iC:tW\r\u001c\u0005\b\u0003{\u0014i\u00101\u0001,\u0011\u001d\u0019\u0019\u0002\u0001C\u0005\u0007+\ta\u0002Z8x]2|\u0017\rZ\"mS\u0016tG\u000f\u0006\u0004\u00038\r]1\u0011\u0004\u0005\u0007U\rE\u0001\u0019A\u0016\t\u0011\u0005=6\u0011\u0003a\u0001\u0003c3aa!\b\u0001\t\r}!a\u0005$jY\u0016$un\u001e8m_\u0006$7\t[1o]\u0016d7CBB\u000e\u0007C\u0019\u0019\u0001\u0005\u0003\u0004$\r%RBAB\u0013\u0015\r\u00199c\\\u0001\u0005Y\u0006tw-\u0003\u0003\u0004,\r\u0015\"AB(cU\u0016\u001cG\u000fC\u0006\u00040\rm!\u0011!Q\u0001\n\r\r\u0011AB:pkJ\u001cW\rC\u0004<\u00077!\taa\r\u0015\t\rU2\u0011\b\t\u0005\u0007o\u0019Y\"D\u0001\u0001\u0011!\u0019yc!\rA\u0002\r\r\u0001\u0002DB\u001f\u00077\u0001\r\u00111A\u0005\n\r}\u0012!B3se>\u0014XCAB!!\u0011\u0019\u0019ea\u0015\u000f\t\r\u00153q\n\b\u0005\u0007\u000f\u001ai%\u0004\u0002\u0004J)\u001911J\r\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0013bAB)]\u00059\u0001/Y2lC\u001e,\u0017\u0002BB+\u0007/\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\rEc\u0006\u0003\u0007\u0004\\\rm\u0001\u0019!a\u0001\n\u0013\u0019i&A\u0005feJ|'o\u0018\u0013fcR!\u0011QBB0\u0011)\t)b!\u0017\u0002\u0002\u0003\u00071\u0011\t\u0005\n\u0007G\u001aY\u0002)Q\u0005\u0007\u0003\na!\u001a:s_J\u0004\u0003\u0006BB1\u0003;A\u0001b!\u001b\u0004\u001c\u0011\u000511N\u0001\tg\u0016$XI\u001d:peR!\u0011QBB7\u0011!\u0019yga\u001aA\u0002\r\u0005\u0013!A3\t\u0011\rM41\u0004C!\u0007k\nAA]3bIR!\u0011\u0011WB<\u0011!\u0019Ih!\u001dA\u0002\t\r\u0015a\u00013ti\"A1QPB\u000e\t\u0003\u0012\u0019.A\u0003dY>\u001cX\r\u0003\u0005\u0004\u0002\u000emA\u0011IBB\u0003\u0019I7o\u00149f]R\u00111Q\u0011\t\u0004[\r\u001d\u0015bABE]\t9!i\\8mK\u0006tgABBG\u0001\u0011\u0019yI\u0001\u000bGS2,Gi\\<oY>\fGmQ1mY\n\f7m[\n\u0007\u0007\u0017\u001b\tc!%\u0011\u0007Q\u001c\u0019*C\u0002\u0004\u0016V\u0014ab\u0015;sK\u0006l7)\u00197mE\u0006\u001c7\u000eC\u0006\u0004\u001a\u000e-%\u0011!Q\u0001\n\rm\u0015\u0001B:j].\u0004Ba!\u0002\u0004\u001e&!1qTB\u0004\u0005M9&/\u001b;bE2,')\u001f;f\u0007\"\fgN\\3m\u0011-\u0019yca#\u0003\u0002\u0003\u0006Ia!\u000e\t\u0015Y\u001cYI!A!\u0002\u0013\u00119\u0004C\u0004<\u0007\u0017#\taa*\u0015\u0011\r%61VBW\u0007_\u0003Baa\u000e\u0004\f\"A1\u0011TBS\u0001\u0004\u0019Y\n\u0003\u0005\u00040\r\u0015\u0006\u0019AB\u001b\u0011\u001d18Q\u0015a\u0001\u0005oA\u0001ba-\u0004\f\u0012\u00053QW\u0001\u0007_:$\u0015\r^1\u0015\r\u000551qWB^\u0011\u001d\u0019Il!-A\u0002-\n\u0001b\u001d;sK\u0006l\u0017\n\u001a\u0005\t\u0007{\u001b\t\f1\u0001\u0003\u0004\u0006\u0019!-\u001e4\t\u0011\r\u000571\u0012C!\u0007\u0007\f!b\u001c8D_6\u0004H.\u001a;f)\u0011\tia!2\t\u000f\re6q\u0018a\u0001W!A1\u0011ZBF\t\u0003\u001aY-A\u0005p]\u001a\u000b\u0017\u000e\\;sKR1\u0011QBBg\u0007\u001fDqa!/\u0004H\u0002\u00071\u0006\u0003\u0005\u0004R\u000e\u001d\u0007\u0019AB!\u0003\u0015\u0019\u0017-^:f\u000f!\u0019)N\u0001E\u0001\u0005\r]\u0017a\u0003(fiRL(\u000b]2F]Z\u00042APBm\r\u001d\t!\u0001#\u0001\u0003\u00077\u001cRa!7\u0004^F\u00012!LBp\u0013\r\u0019\tO\f\u0002\u0007\u0003:L(+\u001a4\t\u000fm\u001aI\u000e\"\u0001\u0004fR\u00111q\u001b\u0005\f\u0007S\u001cIN1A\u0005\u0002\t\u0019Y/\u0001\u0006dkJ\u0014XM\u001c;F]Z,\"a!<\u0011\u000b\r=81_\u001f\u000e\u0005\rE(BA%/\u0013\u0011\u0019)p!=\u0003\u001f\u0011Kh.Y7jGZ\u000b'/[1cY\u0016D\u0011b!?\u0004Z\u0002\u0006Ia!<\u0002\u0017\r,(O]3oi\u0016sg\u000f\t\u0005\f\u0007{\u001cIN1A\u0005\u0002\t\u0019y0A\u0007dkJ\u0014XM\u001c;DY&,g\u000e^\u000b\u0003\t\u0003\u0001baa<\u0004t\n]\u0002\"\u0003C\u0003\u00073\u0004\u000b\u0011\u0002C\u0001\u00039\u0019WO\u001d:f]R\u001cE.[3oi\u0002\u0002")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    private final SparkConf conf;
    public final JavaSerializerInstance org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance;
    private final String host;
    private final SecurityManager securityManager;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private final NettyStreamManager streamManager;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private volatile TransportClientFactory fileDownloadFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    @Nullable
    private RpcAddress address;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() == null ? null : new RpcAddress(this.host, this.server().getPort());
                this.bitmap$0 = true;
            }
        }
        this.host = null;
        return this.address;
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private NettyStreamManager streamManager() {
        return this.streamManager;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    private List<TransportClientBootstrap> createClientBootstraps() {
        return this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportClientBootstrap[]{new AuthClientBootstrap(this.transportConf(), this.securityManager.getSaslUser(), (SecretKeyHolder)this.securityManager)}) : Collections.emptyList();
    }

    private TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private TransportClientFactory fileDownloadFactory() {
        return this.fileDownloadFactory;
    }

    private void fileDownloadFactory_$eq(TransportClientFactory x$1) {
        this.fileDownloadFactory = x$1;
    }

    public ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        Outbox outbox = this.outboxes().remove(address);
        if (outbox != null) {
            outbox.stop();
        }
    }

    public void startServer(String bindAddress, int port) {
        List bootstraps = this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportServerBootstrap[]{new AuthServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager)}) : Collections.emptyList();
        this.server_$eq(this.transportContext().createServer(bindAddress, port, bootstraps));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    @Override
    public RpcAddress address() {
        return this.bitmap$0 ? this.address : this.address$lzycompute();
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name2, RpcEndpoint endpoint) {
        return this.dispatcher().registerRpcEndpoint(name2, endpoint);
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByURI(String uri) {
        RpcEndpointAddress addr = RpcEndpointAddress$.MODULE$.apply(uri);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.conf(), addr, this);
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.conf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(endpointRef.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1)new Serializable(this, uri, endpointRef){
            public static final long serialVersionUID = 0L;
            private final String uri$1;
            private final NettyRpcEndpointRef endpointRef$1;

            public final Future<NettyRpcEndpointRef> apply(boolean find) {
                return find ? Future$.MODULE$.successful((Object)this.endpointRef$1) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(this.uri$1));
            }
            {
                this.uri$1 = uri$1;
                this.endpointRef$1 = endpointRef$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() == null) {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot send message to client endpoint with no listen address.";
                }
            });
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        } else {
            message.sendWith(receiver.client());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
                return;
            }
            catch (RpcEnvStoppedException rpcEnvStoppedException) {
                this.logWarning((Function0<String>)new Serializable(this, rpcEnvStoppedException){
                    public static final long serialVersionUID = 0L;
                    private final RpcEnvStoppedException e$1;

                    public final String apply() {
                        return this.e$1.getMessage();
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                return;
            }
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(message.serialize(this)));
            return;
        }
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Try<Object> x0$1) {
                        Try<Object> try_;
                        block4: {
                            block3: {
                                block2: {
                                    try_ = x0$1;
                                    if (!(try_ instanceof Success)) break block2;
                                    Success success = (Success)try_;
                                    Object response = success.value();
                                    this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(response, this.promise$1);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(try_ instanceof Failure)) break block4;
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(try_);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(message.serialize(this), (Function1<Throwable, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Throwable e) {
                        this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(TransportClient client, ByteBuffer response) {
                        this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(this.$outer.deserialize(client, response, ClassTag$.MODULE$.Any()), this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().onFailure((PartialFunction)new Serializable(this, rpcMessage){
                    public static final long serialVersionUID = 0L;
                    private final RpcOutboxMessage rpcMessage$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        BoxedUnit boxedUnit;
                        A1 A1 = x1;
                        if (A1 instanceof TimeoutException) {
                            this.rpcMessage$1.onTimeout();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return (B1)boxedUnit;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof TimeoutException ? true : true;
                        return bl;
                    }
                    {
                        this.rpcMessage$1 = rpcMessage$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, timeout, promise, remoteAddr){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;
                private final RpcAddress remoteAddr$1;

                public void run() {
                    this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot receive any reply from ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.remoteAddr$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timeout$1.duration()}))).toString()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                    this.remoteAddr$1 = remoteAddr$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1)new Serializable(this, timeoutCancelable){
                public static final long serialVersionUID = 0L;
                private final ScheduledFuture timeoutCancelable$1;

                public final boolean apply(Try<Object> v) {
                    return this.timeoutCancelable$1.cancel(true);
                }
                {
                    this.timeoutCancelable$1 = timeoutCancelable$1;
                }
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public SerializationStream serializeStream(OutputStream out) {
        return this.org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serializeStream(out);
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0)new Serializable(this, bytes, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;
            public final ByteBuffer bytes$1;
            public final ClassTag evidence$2$1;

            public final T apply() {
                return this.$outer.deserialize(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deserialize$1 $outer;

                    public final T apply() {
                        return this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$anonfun$$$outer().org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance.deserialize(this.$outer.bytes$1, this.$outer.evidence$2$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        if (this.stopped().compareAndSet(false, true)) {
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() == null ? BoxedUnit.UNIT : this.timeoutScheduler().shutdownNow();
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            Object object2 = this.clientConnectionExecutor() == null ? BoxedUnit.UNIT : this.clientConnectionExecutor().shutdownNow();
            if (this.fileDownloadFactory() != null) {
                this.fileDownloadFactory().close();
            }
            return;
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    @Override
    public RpcEnvFileServer fileServer() {
        return this.streamManager();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReadableByteChannel openChannel(String uri) {
        URI parsedUri = new URI(uri);
        Predef$.MODULE$.require(parsedUri.getHost() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Host name must be defined.";
            }
        });
        Predef$.MODULE$.require(parsedUri.getPort() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Port must be defined.";
            }
        });
        Predef$.MODULE$.require(parsedUri.getPath() != null && new StringOps(Predef$.MODULE$.augmentString(parsedUri.getPath())).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Path must be defined.";
            }
        });
        Pipe pipe2 = Pipe.open();
        FileDownloadChannel source = new FileDownloadChannel(this, pipe2.source());
        try {
            TransportClient client = this.downloadClient(parsedUri.getHost(), parsedUri.getPort());
            FileDownloadCallback callback = new FileDownloadCallback(this, pipe2.sink(), source, client);
            client.stream(parsedUri.getPath(), (StreamCallback)callback);
            return source;
        }
        catch (Exception exception2) {
            void var4_4;
            void var3_3;
            var3_3.sink().close();
            var4_4.close();
            throw exception2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TransportClient downloadClient(String host, int port) {
        BoxedUnit boxedUnit;
        if (this.fileDownloadFactory() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return this.fileDownloadFactory().createClient(host, port);
        }
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            BoxedUnit boxedUnit2;
            if (this.fileDownloadFactory() == null) {
                String module = "files";
                String prefix = "spark.rpc.io.";
                SparkConf clone2 = this.conf().clone();
                Predef$.MODULE$.refArrayOps((Object[])this.conf().getAll()).foreach((Function1)new Serializable(this, module, prefix, clone2){
                    public static final long serialVersionUID = 0L;
                    private final String module$1;
                    private final String prefix$1;
                    private final SparkConf clone$1;

                    public final Object apply(Tuple2<String, String> x0$2) {
                        Tuple2<String, String> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object object;
                            String key = (String)tuple2._1();
                            String value2 = (String)tuple2._2();
                            if (key.startsWith(this.prefix$1)) {
                                String opt = key.substring(this.prefix$1.length());
                                object = this.clone$1.setIfMissing(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ".io.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.module$1, opt})), value2);
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = object;
                            return boxedUnit;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.module$1 = module$1;
                        this.prefix$1 = prefix$1;
                        this.clone$1 = clone$1;
                    }
                });
                int ioThreads = clone2.getInt("spark.files.io.threads", 1);
                TransportConf downloadConf = SparkTransportConf$.MODULE$.fromSparkConf(clone2, module, ioThreads);
                TransportContext downloadContext = new TransportContext(downloadConf, (RpcHandler)new NoOpRpcHandler(), true);
                this.fileDownloadFactory_$eq(downloadContext.createClientFactory(this.createClientBootstraps()));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl20 : MonitorExitStatement: MONITOREXIT : nettyRpcEnv
            boxedUnit = boxedUnit3;
            return this.fileDownloadFactory().createClient(host, port);
        }
    }

    public final void org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        if (!promise$1.tryFailure(e)) {
            this.logWarning((Function0<String>)new Serializable(this, e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$2}));
                }
                {
                    this.e$2 = e$2;
                }
            });
        }
    }

    public final void org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(Object reply, Promise promise$1) {
        Object object = reply;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (promise$1.trySuccess(object)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this, reply){
                    public static final long serialVersionUID = 0L;
                    private final Object reply$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$1}));
                    }
                    {
                        this.reply$1 = reply$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public NettyRpcEnv(SparkConf conf, JavaSerializerInstance javaSerializerInstance, String host, SecurityManager securityManager) {
        this.conf = conf;
        this.org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance = javaSerializerInstance;
        this.host = host;
        this.securityManager = securityManager;
        super(conf);
        Logging$class.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf.clone().set("spark.rpc.io.numConnectionsPerPeer", "1"), "rpc", conf.getInt("spark.rpc.io.threads", 0));
        this.dispatcher = new Dispatcher(this);
        this.streamManager = new NettyStreamManager(this);
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)new NettyRpcHandler(this.dispatcher(), this, this.streamManager()));
        this.clientFactory = this.transportContext().createClientFactory(this.createClientBootstraps());
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("netty-rpc-env-timeout");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("netty-rpc-connection", conf.getInt("spark.rpc.connect.threads", 64), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = new ConcurrentHashMap();
    }

    public class FileDownloadChannel
    implements ReadableByteChannel {
        public final ReadableByteChannel org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source;
        private volatile Throwable error;
        public final /* synthetic */ NettyRpcEnv $outer;

        private Throwable error() {
            return this.error;
        }

        private void error_$eq(Throwable x$1) {
            this.error = x$1;
        }

        public void setError(Throwable e) {
            this.error_$eq(e);
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.close();
        }

        @Override
        public int read(ByteBuffer dst) {
            Try try_ = Try$.MODULE$.apply((Function0)new FileDownloadChannel$$anonfun$1(this, dst));
            if (try_ instanceof Success) {
                int bytesRead;
                Success success = (Success)try_;
                int n = bytesRead = BoxesRunTime.unboxToInt((Object)success.value());
                return n;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable readErr = failure.exception();
                if (this.error() == null) {
                    throw readErr;
                }
                throw this.error();
            }
            throw new MatchError((Object)try_);
        }

        @Override
        public void close() {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.close();
        }

        @Override
        public boolean isOpen() {
            return this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.isOpen();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$$outer() {
            return this.$outer;
        }

        public FileDownloadChannel(NettyRpcEnv $outer, ReadableByteChannel source) {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source = source;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }

    public class FileDownloadCallback
    implements StreamCallback {
        private final WritableByteChannel sink;
        private final FileDownloadChannel source;
        public final /* synthetic */ NettyRpcEnv $outer;

        public void onData(String streamId, ByteBuffer buf) {
            while (buf.remaining() > 0) {
                this.sink.write(buf);
            }
        }

        public void onComplete(String streamId) {
            this.sink.close();
        }

        public void onFailure(String streamId, Throwable cause) {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer().logDebug((Function0<String>)new Serializable(this, streamId){
                public static final long serialVersionUID = 0L;
                private final String streamId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error downloading stream ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamId$1}));
                }
                {
                    this.streamId$1 = streamId$1;
                }
            }, cause);
            this.source.setError(cause);
            this.sink.close();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer() {
            return this.$outer;
        }

        public FileDownloadCallback(NettyRpcEnv $outer, WritableByteChannel sink, FileDownloadChannel source, TransportClient client) {
            this.sink = sink;
            this.source = source;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

