/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io;

import java.util.Date;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.internal.io.HadoopMapReduceCommitProtocol;
import org.apache.spark.internal.io.SparkHadoopMapReduceWriter$;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

public final class SparkHadoopMapReduceWriter$
implements Logging {
    public static final SparkHadoopMapReduceWriter$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkHadoopMapReduceWriter$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public <K, V> void write(RDD<Tuple2<K, V>> rdd, Configuration hadoopConf, ClassTag<V> evidence$1) {
        SparkContext sparkContext = rdd.context();
        int stageId = rdd.id();
        SparkConf sparkConf = rdd.conf();
        SerializableConfiguration conf = new SerializableConfiguration(hadoopConf);
        String jobTrackerId = SparkHadoopWriterUtils$.MODULE$.createJobTrackerID(new Date());
        TaskAttemptID jobAttemptId = new TaskAttemptID(jobTrackerId, stageId, TaskType.MAP, 0, 0);
        TaskAttemptContextImpl jobContext = new TaskAttemptContextImpl(conf.value(), jobAttemptId);
        Class format = jobContext.getOutputFormatClass();
        if (SparkHadoopWriterUtils$.MODULE$.isOutputSpecValidationEnabled(sparkConf)) {
            OutputFormat jobFormat = (OutputFormat)format.newInstance();
            jobFormat.checkOutputSpecs((JobContext)jobContext);
        }
        HadoopMapReduceCommitProtocol committer = (HadoopMapReduceCommitProtocol)FileCommitProtocol$.MODULE$.instantiate(HadoopMapReduceCommitProtocol.class.getName(), ((Object)BoxesRunTime.boxToInteger((int)stageId)).toString(), conf.value().get("mapreduce.output.fileoutputformat.outputdir"), false);
        committer.setupJob((JobContext)jobContext);
        try {
            FileCommitProtocol.TaskCommitMessage[] ret = (FileCommitProtocol.TaskCommitMessage[])sparkContext.runJob(rdd, new Serializable(evidence$1, conf, jobTrackerId, format, committer){
                public static final long serialVersionUID = 0L;
                private final ClassTag evidence$1$1;
                private final SerializableConfiguration conf$1;
                private final String jobTrackerId$1;
                private final Class format$1;
                private final HadoopMapReduceCommitProtocol committer$1;

                public final FileCommitProtocol.TaskCommitMessage apply(TaskContext context, Iterator<Tuple2<K, V>> iter) {
                    return SparkHadoopMapReduceWriter$.MODULE$.org$apache$spark$internal$io$SparkHadoopMapReduceWriter$$executeTask(context, this.jobTrackerId$1, context.stageId(), context.partitionId(), context.attemptNumber(), this.committer$1, this.conf$1.value(), this.format$1, iter, this.evidence$1$1);
                }
                {
                    this.evidence$1$1 = evidence$1$1;
                    this.conf$1 = conf$1;
                    this.jobTrackerId$1 = jobTrackerId$1;
                    this.format$1 = format$1;
                    this.committer$1 = committer$1;
                }
            }, ClassTag$.MODULE$.apply(FileCommitProtocol.TaskCommitMessage.class));
            committer.commitJob((JobContext)jobContext, (Seq<FileCommitProtocol.TaskCommitMessage>)Predef$.MODULE$.wrapRefArray((Object[])ret));
            this.logInfo((Function0<String>)new Serializable(jobContext){
                public static final long serialVersionUID = 0L;
                private final TaskAttemptContextImpl jobContext$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job ", " committed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jobContext$1.getJobID()}));
                }
                {
                    this.jobContext$1 = jobContext$1;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            this.logError((Function0<String>)new Serializable(jobContext){
                public static final long serialVersionUID = 0L;
                private final TaskAttemptContextImpl jobContext$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting job ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jobContext$1.getJobID()}));
                }
                {
                    this.jobContext$1 = jobContext$1;
                }
            }, throwable);
            committer.abortJob((JobContext)jobContext);
            throw new SparkException("Job aborted.", throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K, V> FileCommitProtocol.TaskCommitMessage org$apache$spark$internal$io$SparkHadoopMapReduceWriter$$executeTask(TaskContext context, String jobTrackerId, int sparkStageId, int sparkPartitionId, int sparkAttemptNumber, FileCommitProtocol committer, Configuration hadoopConf, Class<? extends OutputFormat<K, V>> outputFormat, Iterator<Tuple2<K, V>> iterator2, ClassTag<V> evidence$2) {
        Tuple2 tuple22;
        TaskAttemptID attemptId = new TaskAttemptID(jobTrackerId, sparkStageId, TaskType.REDUCE, sparkPartitionId, sparkAttemptNumber);
        TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(hadoopConf, attemptId);
        committer.setupTask((TaskAttemptContext)taskContext);
        Tuple2<OutputMetrics, Function0<Object>> tuple2 = SparkHadoopWriterUtils$.MODULE$.initHadoopOutputMetrics(context);
        if (tuple2 == null) throw new MatchError(tuple2);
        OutputMetrics outputMetrics = (OutputMetrics)tuple2._1();
        Function0 callback = (Function0)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)outputMetrics, (Object)callback);
        OutputMetrics outputMetrics2 = (OutputMetrics)tuple23._1();
        Function0 callback2 = (Function0)tuple23._2();
        OutputFormat<K, V> taskFormat = outputFormat.newInstance();
        OutputFormat<K, V> outputFormat2 = taskFormat;
        if (outputFormat2 instanceof Configurable) {
            OutputFormat<K, V> outputFormat3 = outputFormat2;
            ((Configurable)outputFormat3).setConf(hadoopConf);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        RecordWriter temp1 = taskFormat.getRecordWriter((TaskAttemptContext)taskContext);
        ObjectRef writer = new ObjectRef((Object)temp1);
        Predef$.MODULE$.require((RecordWriter)writer.elem != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Unable to obtain RecordWriter";
            }
        });
        LongRef recordsWritten = new LongRef(0L);
        try {
            Serializable x$2 = new Serializable(committer, iterator2, taskContext, outputMetrics2, callback2, writer, recordsWritten){
                public static final long serialVersionUID = 0L;
                private final FileCommitProtocol committer$2;
                private final Iterator iterator$1;
                private final TaskAttemptContextImpl taskContext$1;
                private final OutputMetrics outputMetrics$1;
                private final Function0 callback$1;
                private final ObjectRef writer$1;
                private final LongRef recordsWritten$1;

                public final FileCommitProtocol.TaskCommitMessage apply() {
                    while (this.iterator$1.hasNext()) {
                        Tuple2 pair = (Tuple2)this.iterator$1.next();
                        ((RecordWriter)this.writer$1.elem).write(pair._1(), pair._2());
                        SparkHadoopWriterUtils$.MODULE$.maybeUpdateOutputMetrics(this.outputMetrics$1, (Function0<Object>)this.callback$1, this.recordsWritten$1.elem);
                        ++this.recordsWritten$1.elem;
                    }
                    if ((RecordWriter)this.writer$1.elem != null) {
                        ((RecordWriter)this.writer$1.elem).close((TaskAttemptContext)this.taskContext$1);
                        this.writer$1.elem = null;
                    }
                    return this.committer$2.commitTask((TaskAttemptContext)this.taskContext$1);
                }
                {
                    this.committer$2 = committer$2;
                    this.iterator$1 = iterator$1;
                    this.taskContext$1 = taskContext$1;
                    this.outputMetrics$1 = outputMetrics$1;
                    this.callback$1 = callback$1;
                    this.writer$1 = writer$1;
                    this.recordsWritten$1 = recordsWritten$1;
                }
            };
            Serializable x$3 = new Serializable(committer, taskContext, writer){
                public static final long serialVersionUID = 0L;
                private final FileCommitProtocol committer$2;
                public final TaskAttemptContextImpl taskContext$1;
                private final ObjectRef writer$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    try {
                        if ((RecordWriter)this.writer$1.elem != null) {
                            ((RecordWriter)this.writer$1.elem).close((TaskAttemptContext)this.taskContext$1);
                            this.writer$1.elem = null;
                        }
                        this.committer$2.abortTask((TaskAttemptContext)this.taskContext$1);
                        SparkHadoopMapReduceWriter$.MODULE$.logError((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task ", " aborted."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.taskContext$1.getTaskAttemptID()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        return;
                    }
                    catch (Throwable throwable) {
                        this.committer$2.abortTask((TaskAttemptContext)this.taskContext$1);
                        SparkHadoopMapReduceWriter$.MODULE$.logError((Function0<String>)new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                {
                    this.committer$2 = committer$2;
                    this.taskContext$1 = taskContext$1;
                    this.writer$1 = writer$1;
                }
            };
            Serializable x$4 = new Serializable((Function0)x$2){
                public static final long serialVersionUID = 0L;
                private final Function0 x$2$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(this.x$2$1);
                }
                {
                    this.x$2$1 = x$2$1;
                }
            };
            FileCommitProtocol.TaskCommitMessage ret = (FileCommitProtocol.TaskCommitMessage)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks(x$2, (Function0<BoxedUnit>)x$3, (Function0<BoxedUnit>)x$4);
            outputMetrics2.setBytesWritten(callback2.apply$mcJ$sp());
            outputMetrics2.setRecordsWritten(recordsWritten.elem);
            return ret;
        }
        catch (Throwable throwable) {
            throw new SparkException("Task failed while writing rows", throwable);
        }
    }

    private SparkHadoopMapReduceWriter$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

