/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.GlobPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.FileSystemResolver;
import org.apache.ivy.plugins.resolver.IBiblioResolver;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkSubmit$;
import org.apache.spark.deploy.SparkSubmitUtils;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkSubmitUtils$ {
    public static final SparkSubmitUtils$ MODULE$;
    private PrintStream printStream;

    static {
        new SparkSubmitUtils$();
    }

    public PrintStream printStream() {
        return this.printStream;
    }

    public void printStream_$eq(PrintStream x$1) {
        this.printStream = x$1;
    }

    public Seq<SparkSubmitUtils.MavenCoordinate> extractMavenCoordinates(String coordinates) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])coordinates.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparkSubmitUtils.MavenCoordinate apply(String p) {
                String[] splits = p.replace("/", ":").split(":");
                Predef$.MODULE$.require(splits.length == 3, (Function0)new Serializable(this, p){
                    public static final long serialVersionUID = 0L;
                    private final String p$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided Maven Coordinates must be in the form "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'groupId:artifactId:version'. The coordinate provided is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.p$1}))).toString();
                    }
                    {
                        this.p$1 = p$1;
                    }
                });
                Predef$.MODULE$.require(splits[0] != null && new StringOps(Predef$.MODULE$.augmentString(splits[0].trim())).nonEmpty(), (Function0)new Serializable(this, splits){
                    public static final long serialVersionUID = 0L;
                    private final String[] splits$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The groupId cannot be null or "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"be whitespace. The groupId provided is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.splits$1[0]}))).toString();
                    }
                    {
                        this.splits$1 = splits$1;
                    }
                });
                Predef$.MODULE$.require(splits[1] != null && new StringOps(Predef$.MODULE$.augmentString(splits[1].trim())).nonEmpty(), (Function0)new Serializable(this, splits){
                    public static final long serialVersionUID = 0L;
                    private final String[] splits$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The artifactId cannot be null or "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"be whitespace. The artifactId provided is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.splits$1[1]}))).toString();
                    }
                    {
                        this.splits$1 = splits$1;
                    }
                });
                Predef$.MODULE$.require(splits[2] != null && new StringOps(Predef$.MODULE$.augmentString(splits[2].trim())).nonEmpty(), (Function0)new Serializable(this, splits){
                    public static final long serialVersionUID = 0L;
                    private final String[] splits$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The version cannot be null or "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"be whitespace. The version provided is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.splits$1[2]}))).toString();
                    }
                    {
                        this.splits$1 = splits$1;
                    }
                });
                return new SparkSubmitUtils.MavenCoordinate(splits[0], splits[1], splits[2]);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public File m2Path() {
        return Utils$.MODULE$.isTesting() ? new File("dummy", new StringBuilder().append((Object)".m2").append((Object)File.separator).append((Object)"repository").toString()) : new File(System.getProperty("user.home"), new StringBuilder().append((Object)".m2").append((Object)File.separator).append((Object)"repository").toString());
    }

    /*
     * WARNING - void declaration
     */
    public ChainResolver createRepoResolvers(File defaultIvyUserDir) {
        void var2_2;
        ChainResolver cr = new ChainResolver();
        cr.setName("spark-list");
        IBiblioResolver localM2 = new IBiblioResolver();
        localM2.setM2compatible(true);
        localM2.setRoot(this.m2Path().toURI().toString());
        localM2.setUsepoms(true);
        localM2.setName("local-m2-cache");
        cr.add((DependencyResolver)localM2);
        FileSystemResolver localIvy = new FileSystemResolver();
        File localIvyRoot = new File(defaultIvyUserDir, "local");
        localIvy.setLocal(true);
        localIvy.setRepository((Repository)new FileRepository(localIvyRoot));
        String ivyPattern = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{localIvyRoot.getAbsolutePath(), "[organisation]", "[module]", "[revision]", "ivys", "ivy.xml"}))).mkString(File.separator);
        localIvy.addIvyPattern(ivyPattern);
        String artifactPattern = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{localIvyRoot.getAbsolutePath(), "[organisation]", "[module]", "[revision]", "[type]s", "[artifact](-[classifier]).[ext]"}))).mkString(File.separator);
        localIvy.addArtifactPattern(artifactPattern);
        localIvy.setName("local-ivy-cache");
        cr.add((DependencyResolver)localIvy);
        IBiblioResolver br = new IBiblioResolver();
        br.setM2compatible(true);
        br.setUsepoms(true);
        br.setName("central");
        cr.add((DependencyResolver)br);
        IBiblioResolver sp2 = new IBiblioResolver();
        sp2.setM2compatible(true);
        sp2.setUsepoms(true);
        sp2.setRoot("http://dl.bintray.com/spark-packages/maven");
        sp2.setName("spark-packages");
        cr.add((DependencyResolver)sp2);
        return var2_2;
    }

    public String resolveDependencyPaths(Object[] artifacts, File cacheDirectory) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(artifacts).map((Function1)new Serializable(cacheDirectory){
            public static final long serialVersionUID = 0L;
            private final File cacheDirectory$1;

            public final String apply(Object artifactInfo) {
                ModuleRevisionId artifact = ((Artifact)artifactInfo).getModuleRevisionId();
                return new StringBuilder().append((Object)this.cacheDirectory$1.getAbsolutePath()).append((Object)File.separator).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", "-", ".jar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{artifact.getOrganisation(), artifact.getName(), artifact.getRevision()}))).toString();
            }
            {
                this.cacheDirectory$1 = cacheDirectory$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
    }

    public void addDependenciesToIvy(DefaultModuleDescriptor md, Seq<SparkSubmitUtils.MavenCoordinate> artifacts, String ivyConfName) {
        artifacts.foreach((Function1)new Serializable(md, ivyConfName){
            public static final long serialVersionUID = 0L;
            private final DefaultModuleDescriptor md$1;
            private final String ivyConfName$1;

            public final void apply(SparkSubmitUtils.MavenCoordinate mvn) {
                ModuleRevisionId ri = ModuleRevisionId.newInstance((String)mvn.groupId(), (String)mvn.artifactId(), (String)mvn.version());
                DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(ri, false, false);
                dd.addDependencyConfiguration(this.ivyConfName$1, new StringBuilder().append((Object)this.ivyConfName$1).append((Object)"(runtime)").toString());
                SparkSubmitUtils$.MODULE$.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " added as a dependency"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dd.getDependencyId()})));
                this.md$1.addDependency((DependencyDescriptor)dd);
            }
            {
                this.md$1 = md$1;
                this.ivyConfName$1 = ivyConfName$1;
            }
        });
    }

    public void addExclusionRules(IvySettings ivySettings, String ivyConfName, DefaultModuleDescriptor md) {
        md.addExcludeRule(this.createExclusion("*:scala-library:*", ivySettings, ivyConfName));
        Seq components = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"catalyst_", "core_", "graphx_", "hive_", "mllib_", "repl_", "sql_", "streaming_", "yarn_", "network-common_", "network-shuffle_", "network-yarn_"}));
        components.foreach((Function1)new Serializable(ivySettings, ivyConfName, md){
            public static final long serialVersionUID = 0L;
            private final IvySettings ivySettings$2;
            private final String ivyConfName$2;
            private final DefaultModuleDescriptor md$2;

            public final void apply(String comp) {
                this.md$2.addExcludeRule(SparkSubmitUtils$.MODULE$.createExclusion(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark:spark-", "*:*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{comp})), this.ivySettings$2, this.ivyConfName$2));
            }
            {
                this.ivySettings$2 = ivySettings$2;
                this.ivyConfName$2 = ivyConfName$2;
                this.md$2 = md$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public IvySettings buildIvySettings(Option<String> remoteRepos, Option<String> ivyPath) {
        void var3_3;
        IvySettings ivySettings = new IvySettings();
        this.processIvyPathArg(ivySettings, ivyPath);
        ivySettings.addMatcher((PatternMatcher)new GlobPatternMatcher());
        ChainResolver repoResolver = this.createRepoResolvers(ivySettings.getDefaultIvyUserDir());
        ivySettings.addResolver((DependencyResolver)repoResolver);
        ivySettings.setDefaultResolver(repoResolver.getName());
        this.processRemoteRepoArg(ivySettings, remoteRepos);
        return var3_3;
    }

    public IvySettings loadIvySettings(String settingsFile, Option<String> remoteRepos, Option<String> ivyPath) {
        File file = new File(settingsFile);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ivy settings file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
            }
            {
                this.file$1 = file$1;
            }
        });
        Predef$.MODULE$.require(file.isFile(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ivy settings file ", " is not a normal file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
            }
            {
                this.file$1 = file$1;
            }
        });
        IvySettings ivySettings = new IvySettings();
        try {
            ivySettings.load(file);
            this.processIvyPathArg(ivySettings, ivyPath);
            this.processRemoteRepoArg(ivySettings, remoteRepos);
            return ivySettings;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof ParseException;
            if (bl) {
                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed when loading Ivy settings from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{settingsFile})), throwable2);
            }
            throw throwable;
        }
    }

    private void processIvyPathArg(IvySettings ivySettings, Option<String> ivyPath) {
        ivyPath.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$10) {
                return x$10.trim().isEmpty();
            }
        }).foreach((Function1)new Serializable(ivySettings){
            public static final long serialVersionUID = 0L;
            private final IvySettings ivySettings$3;

            public final void apply(String alternateIvyDir) {
                this.ivySettings$3.setDefaultIvyUserDir(new File(alternateIvyDir));
                this.ivySettings$3.setDefaultCache(new File(alternateIvyDir, "cache"));
            }
            {
                this.ivySettings$3 = ivySettings$3;
            }
        });
    }

    private void processRemoteRepoArg(IvySettings ivySettings, Option<String> remoteRepos) {
        remoteRepos.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$11) {
                return x$11.trim().isEmpty();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$12) {
                return x$12.split(",");
            }
        }).foreach((Function1)new Serializable(ivySettings){
            public static final long serialVersionUID = 0L;
            private final IvySettings ivySettings$4;

            public final void apply(String[] repositoryList) {
                ChainResolver cr = new ChainResolver();
                cr.setName("user-list");
                Option$.MODULE$.apply((Object)this.ivySettings$4.getDefaultResolver()).foreach((Function1)new Serializable(this, cr){
                    public static final long serialVersionUID = 0L;
                    private final ChainResolver cr$1;

                    public final void apply(DependencyResolver x$1) {
                        this.cr$1.add(x$1);
                    }
                    {
                        this.cr$1 = cr$1;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])repositoryList).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, cr){
                    public static final long serialVersionUID = 0L;
                    private final ChainResolver cr$1;

                    public final void apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String repo = (String)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            IBiblioResolver brr = new IBiblioResolver();
                            brr.setM2compatible(true);
                            brr.setUsepoms(true);
                            brr.setRoot(repo);
                            brr.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"repo-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1))})));
                            this.cr$1.add((DependencyResolver)brr);
                            SparkSubmitUtils$.MODULE$.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " added as a remote repository with the name: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{repo, brr.getName()})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.cr$1 = cr$1;
                    }
                });
                this.ivySettings$4.addResolver((DependencyResolver)cr);
                this.ivySettings$4.setDefaultResolver(cr.getName());
            }
            {
                this.ivySettings$4 = ivySettings$4;
            }
        });
    }

    public DefaultModuleDescriptor getModuleDescriptor() {
        return DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)"org.apache.spark", (String)"spark-submit-parent", (String)"1.0"));
    }

    public String resolveMavenCoordinates(String coordinates, IvySettings ivySettings, Seq<String> exclusions, boolean isTest) {
        PrintStream sysOut;
        String string;
        if (coordinates == null || coordinates.trim().isEmpty()) {
            string = "";
        } else {
            ResolveOptions resolveOptions;
            sysOut = System.out;
            System.setOut(this.printStream());
            Seq<SparkSubmitUtils.MavenCoordinate> artifacts = this.extractMavenCoordinates(coordinates);
            File packagesDirectory = new File(ivySettings.getDefaultIvyUserDir(), "jars");
            this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ivy Default Cache set to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ivySettings.getDefaultCache().getAbsolutePath()})));
            this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The jars for the packages stored in: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{packagesDirectory})));
            Ivy ivy = Ivy.newInstance((IvySettings)ivySettings);
            ResolveOptions resolveOptions2 = new ResolveOptions();
            resolveOptions2.setTransitive(true);
            RetrieveOptions retrieveOptions = new RetrieveOptions();
            if (isTest) {
                resolveOptions2.setDownload(false);
                resolveOptions2.setLog("quiet");
                resolveOptions = retrieveOptions.setLog("quiet");
            } else {
                resolveOptions = resolveOptions2.setDownload(true);
            }
            String ivyConfName = "default";
            DefaultModuleDescriptor md = this.getModuleDescriptor();
            ModuleRevisionId mdId = md.getModuleRevisionId();
            File previousResolution = new File(ivySettings.getDefaultCache(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-", ".xml"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mdId.getOrganisation(), mdId.getName(), ivyConfName})));
            Object object = previousResolution.exists() ? BoxesRunTime.boxToBoolean((boolean)previousResolution.delete()) : BoxedUnit.UNIT;
            md.setDefaultConf(ivyConfName);
            this.addExclusionRules(ivySettings, ivyConfName, md);
            this.addDependenciesToIvy(md, artifacts, ivyConfName);
            exclusions.foreach((Function1)new Serializable(ivySettings, ivyConfName, md){
                public static final long serialVersionUID = 0L;
                private final IvySettings ivySettings$1;
                private final String ivyConfName$3;
                private final DefaultModuleDescriptor md$3;

                public final void apply(String e) {
                    this.md$3.addExcludeRule(SparkSubmitUtils$.MODULE$.createExclusion(new StringBuilder().append((Object)e).append((Object)":*").toString(), this.ivySettings$1, this.ivyConfName$3));
                }
                {
                    this.ivySettings$1 = ivySettings$1;
                    this.ivyConfName$3 = ivyConfName$3;
                    this.md$3 = md$3;
                }
            });
            ResolveReport rr = ivy.resolve((ModuleDescriptor)md, resolveOptions2);
            if (rr.hasError()) {
                throw new RuntimeException(rr.getAllProblemMessages().toString());
            }
            ivy.retrieve(rr.getModuleDescriptor().getModuleRevisionId(), new StringBuilder().append((Object)packagesDirectory.getAbsolutePath()).append((Object)File.separator).append((Object)"[organization]_[artifact]-[revision].[ext]").toString(), retrieveOptions.setConfs((String[])((Object[])new String[]{ivyConfName})));
            string = this.resolveDependencyPaths(rr.getArtifacts().toArray(), packagesDirectory);
        }
        return string;
        finally {
            System.setOut(sysOut);
        }
    }

    public Seq<String> resolveMavenCoordinates$default$3() {
        return Nil$.MODULE$;
    }

    public boolean resolveMavenCoordinates$default$4() {
        return false;
    }

    public ExcludeRule createExclusion(String coords, IvySettings ivySettings, String ivyConfName) {
        SparkSubmitUtils.MavenCoordinate c = (SparkSubmitUtils.MavenCoordinate)this.extractMavenCoordinates(coords).apply(0);
        ArtifactId id = new ArtifactId(new ModuleId(c.groupId(), c.artifactId()), "*", "*", "*");
        DefaultExcludeRule rule = new DefaultExcludeRule(id, ivySettings.getMatcher("glob"), null);
        rule.addConfiguration(ivyConfName);
        return rule;
    }

    private SparkSubmitUtils$() {
        MODULE$ = this;
        this.printStream = SparkSubmit$.MODULE$.printStream();
    }
}

