/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.SparkUserAppException;
import org.apache.spark.api.r.RBackend;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.api.r.SparkRDefaults$;
import org.apache.spark.deploy.PythonRunner$;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileIntRef;
import scala.sys.package$;

public final class RRunner$ {
    public static final RRunner$ MODULE$;

    static {
        new RRunner$();
    }

    public void main(String[] args) {
        String rFile = PythonRunner$.MODULE$.formatPath(args[0], PythonRunner$.MODULE$.formatPath$default$2());
        String[] otherArgs = (String[])Predef$.MODULE$.refArrayOps((Object[])args).slice(1, args.length);
        int backendTimeout = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"SPARKR_BACKEND_TIMEOUT", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "120";
            }
        }))).toInt();
        ObjectRef cmd = new ObjectRef((Object)((String)package$.MODULE$.props().getOrElse((Object)"spark.sparkr.r.command", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Rscript";
            }
        })));
        cmd.elem = (String)package$.MODULE$.props().getOrElse((Object)"spark.r.command", (Function0)new Serializable(cmd){
            public static final long serialVersionUID = 0L;
            private final ObjectRef cmd$1;

            public final String apply() {
                return (String)this.cmd$1.elem;
            }
            {
                this.cmd$1 = cmd$1;
            }
        });
        Object object = package$.MODULE$.props().getOrElse((Object)"spark.submit.deployMode", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "client";
            }
        });
        String string = "client";
        if (!(object != null ? !object.equals(string) : string != null)) {
            cmd.elem = (String)package$.MODULE$.props().getOrElse((Object)"spark.r.driver.command", (Function0)new Serializable(cmd){
                public static final long serialVersionUID = 0L;
                private final ObjectRef cmd$1;

                public final String apply() {
                    return (String)this.cmd$1.elem;
                }
                {
                    this.cmd$1 = cmd$1;
                }
            });
        }
        String rCommand = (String)cmd.elem;
        String backendConnectionTimeout = (String)package$.MODULE$.props().getOrElse((Object)"spark.r.backendConnectionTimeout", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ((Object)BoxesRunTime.boxToInteger((int)SparkRDefaults$.MODULE$.DEFAULT_CONNECTION_TIMEOUT())).toString();
            }
        });
        File rF = new File(rFile);
        String rFileNormalized = rF.exists() ? rFile : new Path(rFile).getName();
        RBackend sparkRBackend = new RBackend();
        VolatileIntRef sparkRBackendPort = new VolatileIntRef(0);
        Semaphore initialized = new Semaphore(0);
        Thread sparkRBackendThread = new Thread(sparkRBackend, sparkRBackendPort, initialized){
            private final RBackend sparkRBackend$1;
            private final VolatileIntRef sparkRBackendPort$1;
            private final Semaphore initialized$1;

            public void run() {
                this.sparkRBackendPort$1.elem = this.sparkRBackend$1.init();
                this.initialized$1.release();
                this.sparkRBackend$1.run();
            }
            {
                this.sparkRBackend$1 = sparkRBackend$1;
                this.sparkRBackendPort$1 = sparkRBackendPort$1;
                this.initialized$1 = initialized$1;
                super("SparkR backend");
            }
        };
        sparkRBackendThread.start();
        if (initialized.tryAcquire(backendTimeout, TimeUnit.SECONDS)) {
            ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{rCommand, rFileNormalized}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])otherArgs), Seq$.MODULE$.canBuildFrom())).asJava());
            Map<String, String> env = builder.environment();
            env.put("EXISTING_SPARKR_BACKEND_PORT", ((Object)BoxesRunTime.boxToInteger((int)sparkRBackendPort.elem)).toString());
            env.put("SPARKR_BACKEND_CONNECTION_TIMEOUT", backendConnectionTimeout);
            Seq<String> rPackageDir = RUtils$.MODULE$.sparkRPackagePath(true);
            env.put("SPARKR_PACKAGE_DIR", rPackageDir.mkString(","));
            env.put("R_PROFILE_USER", ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)rPackageDir.apply(0), "SparkR", "profile", "general.R"}))).mkString(File.separator));
            builder.redirectErrorStream(true);
            Process process2 = builder.start();
            new RedirectThread(process2.getInputStream(), System.out, "redirect R output", RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            int returnCode = process2.waitFor();
            if (returnCode != 0) {
                throw new SparkUserAppException(returnCode);
            }
            return;
        }
        String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SparkR backend did not initialize in ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)backendTimeout)}));
        System.err.println(errorMessage);
        throw new SparkException(errorMessage);
        finally {
            sparkRBackend.close();
        }
    }

    private RRunner$() {
        MODULE$ = this;
    }
}

