/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.deploy.RPackageUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.io.ByteStreams;
import org.spark_project.guava.io.Files;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RPackageUtils$
implements Logging {
    public static final RPackageUtils$ MODULE$;
    private final String hasRPackage;
    private final Seq<String> baseInstallCmd;
    private final String RJarEntries;
    private final String RJarDoc;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RPackageUtils$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private final String hasRPackage() {
        return "Spark-HasRPackage";
    }

    private final Seq<String> baseInstallCmd() {
        return this.baseInstallCmd;
    }

    private final String RJarEntries() {
        return "R/pkg";
    }

    public final String RJarDoc() {
        return this.RJarDoc;
    }

    public void org$apache$spark$deploy$RPackageUtils$$print(String msg, PrintStream printStream, Level level, Throwable e) {
        if (printStream == null) {
            Level level2 = level;
            Level level3 = Level.INFO;
            Level level4 = level2;
            if (!(level3 != null ? !((Object)level3).equals(level4) : level4 != null)) {
                this.logInfo((Function0<String>)new Serializable(msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$1;

                    public final String apply() {
                        return this.msg$1;
                    }
                    {
                        this.msg$1 = msg$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Level level5 = Level.WARNING;
                Level level6 = level2;
                if (!(level5 != null ? !((Object)level5).equals(level6) : level6 != null)) {
                    this.logWarning((Function0<String>)new Serializable(msg){
                        public static final long serialVersionUID = 0L;
                        private final String msg$1;

                        public final String apply() {
                            return this.msg$1;
                        }
                        {
                            this.msg$1 = msg$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Level level7 = Level.SEVERE;
                    Level level8 = level2;
                    if (!(level7 != null ? !((Object)level7).equals(level8) : level8 != null)) {
                        this.logError((Function0<String>)new Serializable(msg){
                            public static final long serialVersionUID = 0L;
                            private final String msg$1;

                            public final String apply() {
                                return this.msg$1;
                            }
                            {
                                this.msg$1 = msg$1;
                            }
                        }, e);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.logDebug((Function0<String>)new Serializable(msg){
                            public static final long serialVersionUID = 0L;
                            private final String msg$1;

                            public final String apply() {
                                return this.msg$1;
                            }
                            {
                                this.msg$1 = msg$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        } else {
            printStream.println(msg);
            if (e != null) {
                e.printStackTrace(printStream);
            }
        }
    }

    public Level org$apache$spark$deploy$RPackageUtils$$print$default$3() {
        return Level.FINE;
    }

    public Throwable org$apache$spark$deploy$RPackageUtils$$print$default$4() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkManifestForR(JarFile jar) {
        if (jar.getManifest() == null) {
            return false;
        }
        Attributes manifest = jar.getManifest().getMainAttributes();
        if (manifest.getValue("Spark-HasRPackage") == null) return false;
        String string = manifest.getValue("Spark-HasRPackage").trim();
        String string2 = "true";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean org$apache$spark$deploy$RPackageUtils$$rPackageBuilder(File dir, PrintStream printStream, boolean verbose, String libDir) {
        boolean bl;
        String pathToPkg = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{dir, "R", "pkg"}))).mkString(File.separator);
        Seq installCmd = (Seq)this.baseInstallCmd().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{libDir, pathToPkg})), Seq$.MODULE$.canBuildFrom());
        if (verbose) {
            this.org$apache$spark$deploy$RPackageUtils$$print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Building R package with the command: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{installCmd})), printStream, this.org$apache$spark$deploy$RPackageUtils$$print$default$3(), this.org$apache$spark$deploy$RPackageUtils$$print$default$4());
        }
        try {
            ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter(installCmd).asJava());
            builder.redirectErrorStream(true);
            Map<String, String> env = builder.environment();
            Seq<String> rPackageDir = RUtils$.MODULE$.sparkRPackagePath(true);
            env.put("SPARKR_PACKAGE_DIR", rPackageDir.mkString(","));
            env.put("R_PROFILE_USER", ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)rPackageDir.apply(0), "SparkR", "profile", "general.R"}))).mkString(File.separator));
            Process process2 = builder.start();
            new RedirectThread(process2.getInputStream(), printStream, "redirect R packaging", RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            bl = process2.waitFor() == 0;
        }
        catch (Throwable throwable) {
            this.org$apache$spark$deploy$RPackageUtils$$print("Failed to build R package.", printStream, Level.SEVERE, throwable);
            bl = false;
        }
        return bl;
    }

    public File org$apache$spark$deploy$RPackageUtils$$extractRFolder(JarFile jar, PrintStream printStream, boolean verbose) {
        File tempDir = Utils$.MODULE$.createTempDir(null, Utils$.MODULE$.createTempDir$default$2());
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            Object object;
            JarEntry entry = jarEntries.nextElement();
            int entryRIndex = entry.getName().indexOf("R/pkg");
            if (entryRIndex > -1) {
                String entryPath = entry.getName().substring(entryRIndex);
                if (entry.isDirectory()) {
                    File dir = new File(tempDir, entryPath);
                    if (verbose) {
                        this.org$apache$spark$deploy$RPackageUtils$$print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir})), printStream, this.org$apache$spark$deploy$RPackageUtils$$print$default$3(), this.org$apache$spark$deploy$RPackageUtils$$print$default$4());
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)dir.mkdirs());
                    continue;
                }
                InputStream inStream = jar.getInputStream(entry);
                File outPath = new File(tempDir, entryPath);
                Files.createParentDirs((File)outPath);
                FileOutputStream outStream = new FileOutputStream(outPath);
                if (verbose) {
                    this.org$apache$spark$deploy$RPackageUtils$$print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extracting ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entry, outPath})), printStream, this.org$apache$spark$deploy$RPackageUtils$$print$default$3(), this.org$apache$spark$deploy$RPackageUtils$$print$default$4());
                }
                object = BoxesRunTime.boxToLong((long)Utils$.MODULE$.copyStream(inStream, outStream, true, Utils$.MODULE$.copyStream$default$4()));
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return tempDir;
    }

    public void checkAndBuildRPackage(String jars, PrintStream printStream, boolean verbose) {
        Predef$.MODULE$.refArrayOps((Object[])jars.split(",")).foreach((Function1)new Serializable(printStream, verbose){
            public static final long serialVersionUID = 0L;
            public final PrintStream printStream$1;
            public final boolean verbose$1;

            public final void apply(String jarPath) {
                File file = new File(Utils$.MODULE$.resolveURI(jarPath));
                if (file.exists()) {
                    JarFile jar = new JarFile(file);
                    Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, file, jar){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.checkAndBuildRPackage.1 $outer;
                        private final File file$1;
                        private final JarFile jar$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void apply$mcV$sp() {
                            if (!RPackageUtils$.MODULE$.checkManifestForR(this.jar$1)) {
                                if (!this.$outer.verbose$1) return;
                                RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " doesn't contain R source code, skipping..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1})), this.$outer.printStream$1, RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print$default$3(), RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print$default$4());
                                return;
                            }
                            RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " contains R source code. Now installing package."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1})), this.$outer.printStream$1, Level.INFO, RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print$default$4());
                            File rSource = RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$extractRFolder(this.jar$1, this.$outer.printStream$1, this.$outer.verbose$1);
                            if (RUtils$.MODULE$.rPackages().isEmpty()) {
                                RUtils$.MODULE$.rPackages_$eq((Option<String>)new Some((Object)Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath()));
                            }
                            try {
                                if (!RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$rPackageBuilder(rSource, this.$outer.printStream$1, this.$outer.verbose$1, (String)RUtils$.MODULE$.rPackages().get())) {
                                    RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: Failed to build R package in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1})), this.$outer.printStream$1, RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print$default$3(), RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print$default$4());
                                    RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print(RPackageUtils$.MODULE$.RJarDoc(), this.$outer.printStream$1, RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print$default$3(), RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print$default$4());
                                }
                                if (rSource.delete()) return;
                                RPackageUtils$.MODULE$.logWarning((Function0<String>)new Serializable(this, rSource){
                                    public static final long serialVersionUID = 0L;
                                    private final File rSource$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rSource$1.getPath()}));
                                    }
                                    {
                                        this.rSource$1 = rSource$1;
                                    }
                                });
                                return;
                            }
                            catch (Throwable throwable) {
                                if (rSource.delete()) throw throwable;
                                RPackageUtils$.MODULE$.logWarning((Function0<String>)new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.file$1 = file$1;
                            this.jar$1 = jar$1;
                        }
                    }, (Function0<BoxedUnit>)new Serializable(this, jar){
                        public static final long serialVersionUID = 0L;
                        private final JarFile jar$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.jar$1.close();
                        }
                        {
                            this.jar$1 = jar$1;
                        }
                    });
                } else {
                    RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARN: ", " resolved as dependency, but not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})), this.printStream$1, Level.WARNING, RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$print$default$4());
                }
            }
            {
                this.printStream$1 = printStream$1;
                this.verbose$1 = verbose$1;
            }
        });
    }

    public PrintStream checkAndBuildRPackage$default$2() {
        return null;
    }

    public boolean checkAndBuildRPackage$default$3() {
        return false;
    }

    public Set<File> org$apache$spark$deploy$RPackageUtils$$listFilesRecursively(File dir, Seq<String> excludePatterns) {
        Set set2;
        if (dir.exists()) {
            if (dir.isDirectory()) {
                File[] subDir = dir.listFiles(new FilenameFilter(excludePatterns){
                    private final Seq excludePatterns$1;

                    public boolean accept(File dir, String name2) {
                        return !BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)this.excludePatterns$1.map((Function1)new Serializable(this, name2){
                            public static final long serialVersionUID = 0L;
                            private final String name$1;

                            public final boolean apply(CharSequence x$1) {
                                return this.name$1.contains(x$1);
                            }
                            {
                                this.name$1 = name$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(boolean x$1, boolean x$2) {
                                return x$1 || x$2;
                            }
                        }));
                    }
                    {
                        this.excludePatterns$1 = excludePatterns$1;
                    }
                });
                set2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])subDir).flatMap((Function1)new Serializable(excludePatterns){
                    public static final long serialVersionUID = 0L;
                    private final Seq excludePatterns$1;

                    public final Set<File> apply(File x$3) {
                        return RPackageUtils$.MODULE$.org$apache$spark$deploy$RPackageUtils$$listFilesRecursively(x$3, (Seq<String>)this.excludePatterns$1);
                    }
                    {
                        this.excludePatterns$1 = excludePatterns$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).toSet();
            } else {
                set2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{dir}));
            }
        } else {
            set2 = Predef$.MODULE$.Set().empty();
        }
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    public File zipRLibraries(File dir, String name2) {
        Set<File> filesToBundle = this.org$apache$spark$deploy$RPackageUtils$$listFilesRecursively(dir, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".zip"}))));
        File zipFile = new File(dir, name2);
        if (!zipFile.delete()) {
            this.logWarning((Function0<String>)new Serializable(zipFile){
                public static final long serialVersionUID = 0L;
                private final File zipFile$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zipFile$1.getPath()}));
                }
                {
                    this.zipFile$1 = zipFile$1;
                }
            });
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile, false));
        try {
            filesToBundle.foreach((Function1)new Serializable(dir, zipOutputStream){
                public static final long serialVersionUID = 0L;
                private final File dir$1;
                private final ZipOutputStream zipOutputStream$1;

                public final void apply(File file) {
                    String relPath = file.toURI().toString().replaceFirst(new StringOps(Predef$.MODULE$.augmentString(this.dir$1.toURI().toString())).stripSuffix("/"), "");
                    FileInputStream fis = new FileInputStream(file);
                    ZipEntry zipEntry = new ZipEntry(relPath);
                    this.zipOutputStream$1.putNextEntry(zipEntry);
                    ByteStreams.copy((InputStream)fis, (OutputStream)this.zipOutputStream$1);
                    this.zipOutputStream$1.closeEntry();
                    fis.close();
                }
                {
                    this.dir$1 = dir$1;
                    this.zipOutputStream$1 = zipOutputStream$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        zipOutputStream.close();
        return zipFile;
    }

    private RPackageUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.baseInstallCmd = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"R", "CMD", "INSTALL", "-l"}));
        this.RJarDoc = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In order for Spark to build R packages that are parts of Spark Packages, there are a few\n      |requirements. The R source code must be shipped in a jar, with additional Java/Scala\n      |classes. The jar must be in the following format:\n      |  1- The Manifest (META-INF/MANIFEST.mf) must contain the key-value: ", ": true\n      |  2- The standard R package layout must be preserved under R/pkg/ inside the jar. More\n      |  information on the standard R package layout can be found in:\n      |  http://cran.r-project.org/doc/contrib/Leisch-CreatingPackages.pdf\n      |  An example layout is given below. After running `jar tf $JAR_FILE | sort`:\n      |\n      |META-INF/MANIFEST.MF\n      |R/\n      |R/pkg/\n      |R/pkg/DESCRIPTION\n      |R/pkg/NAMESPACE\n      |R/pkg/R/\n      |R/pkg/R/myRcode.R\n      |org/\n      |org/apache/\n      |...\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Spark-HasRPackage"})))).stripMargin().trim();
    }
}

