/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.FileDescriptor;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.AlignedBuffers;
import org.apache.ignite.internal.processors.cache.persistence.file.AlignedBuffersDirectFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.file.IgniteNativeIoLib;
import org.apache.ignite.internal.processors.cache.persistence.file.LinuxNativeIoPlugin;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.CachePluginContext;
import org.apache.ignite.plugin.CachePluginProvider;
import org.apache.ignite.plugin.ExtensionRegistry;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.PluginValidationException;
import org.jetbrains.annotations.Nullable;

public class LinuxNativeIoPluginProvider
implements PluginProvider {
    @Nullable
    private ConcurrentHashMap<Long, Thread> managedBuffers;
    private IgniteLogger log;

    public String name() {
        return "Ignite Native I/O Plugin [Direct I/O]";
    }

    public String version() {
        return "";
    }

    public String copyright() {
        return "Copyright(C) Apache Software Foundation";
    }

    public void initExtensions(PluginContext ctx, ExtensionRegistry registry) {
    }

    public CachePluginProvider createCacheProvider(CachePluginContext ctx) {
        return null;
    }

    public void start(PluginContext ctx) {
        Ignite ignite = ctx.grid();
        this.log = ignite.log();
        this.managedBuffers = this.setupDirect((IgniteEx)ignite);
    }

    public void stop(boolean cancel) {
        this.freeDirectBuffers();
    }

    private void freeDirectBuffers() {
        ConcurrentHashMap<Long, Thread> buffers = this.managedBuffers;
        if (buffers == null) {
            return;
        }
        this.managedBuffers = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Direct IO buffers to be freed: " + buffers.size());
        }
        for (Map.Entry<Long, Thread> next : buffers.entrySet()) {
            Thread th = next.getValue();
            Long addr = next.getKey();
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Free Direct IO buffer [address=%d; Thread=%s; alive=%s]", addr, th != null ? th.getName() : "", th != null && th.isAlive()));
            }
            AlignedBuffers.free(addr);
        }
        buffers.clear();
    }

    public void onIgniteStart() {
    }

    public void onIgniteStop(boolean cancel) {
    }

    @Nullable
    public Serializable provideDiscoveryData(UUID nodeId) {
        return null;
    }

    public void receiveDiscoveryData(UUID nodeId, Serializable data) {
    }

    public void validateNewNode(ClusterNode node) throws PluginValidationException {
    }

    @Nullable
    public Object createComponent(PluginContext ctx, Class cls) {
        return null;
    }

    public IgnitePlugin plugin() {
        return new LinuxNativeIoPlugin();
    }

    @Nullable
    private ConcurrentHashMap<Long, Thread> setupDirect(IgniteEx ignite) {
        GridCacheSharedContext cacheCtx = ignite.context().cache().context();
        IgnitePageStoreManager ignitePageStoreMgr = cacheCtx.pageStore();
        if (ignitePageStoreMgr == null) {
            return null;
        }
        if (!(ignitePageStoreMgr instanceof FilePageStoreManager)) {
            return null;
        }
        final FilePageStoreManager pageStore = (FilePageStoreManager)ignitePageStoreMgr;
        FileIOFactory backupIoFactory = pageStore.getPageStoreFileIoFactory();
        final AlignedBuffersDirectFileIOFactory factory = new AlignedBuffersDirectFileIOFactory(ignite.log(), pageStore.workDir(), pageStore.pageSize(), backupIoFactory);
        final IgniteWriteAheadLogManager walMgr = cacheCtx.wal();
        if (walMgr != null && walMgr instanceof FileWriteAheadLogManager && IgniteNativeIoLib.isJnaAvailable()) {
            ((FileWriteAheadLogManager)walMgr).setCreateWalFileListener((IgniteInClosure)new IgniteInClosure<FileIO>(){

                public void apply(FileIO fileIO) {
                    LinuxNativeIoPluginProvider.this.adviceFileDontNeed(fileIO, ((FileWriteAheadLogManager)walMgr).maxWalSegmentSize());
                }
            });
        }
        if (!factory.isDirectIoAvailable()) {
            return null;
        }
        GridCacheDatabaseSharedManager db = (GridCacheDatabaseSharedManager)cacheCtx.database();
        db.setThreadBuf((ThreadLocal)new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                return factory.createManagedBuffer(pageStore.pageSize());
            }
        });
        pageStore.setPageStoreFileIOFactories((FileIOFactory)factory, backupIoFactory);
        return factory.managedAlignedBuffers();
    }

    private void adviceFileDontNeed(FileIO fileIO, long size) {
        try {
            RandomAccessFileIO chIo;
            FileChannel ch;
            FileDescriptor fd;
            int fdVal;
            int retVal;
            if (fileIO instanceof RandomAccessFileIO && (retVal = IgniteNativeIoLib.posix_fadvise(fdVal = ((Integer)U.field((Object)(fd = (FileDescriptor)U.field((Object)(ch = (FileChannel)U.field((Object)(chIo = (RandomAccessFileIO)fileIO), (String)"ch")), (String)"fd")), (String)"fd")).intValue(), 0L, size, 4)) != 0) {
                U.warn((IgniteLogger)this.log, (Object)("Unable to apply fadvice on WAL file descriptor [fd=" + fdVal + "]:" + IgniteNativeIoLib.strerror(retVal)));
            }
        }
        catch (Exception e) {
            U.warn((IgniteLogger)this.log, (Object)("Unable to advice on WAL file descriptor: [" + e.getMessage() + "]"), (Object)e);
        }
    }
}

