/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.kubernetes;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;

public class TcpDiscoveryKubernetesIpFinder
extends TcpDiscoveryIpFinderAdapter {
    @LoggerResource
    private IgniteLogger log;
    private final AtomicBoolean initGuard = new AtomicBoolean();
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private TrustManager[] trustAll = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};
    private HostnameVerifier trustAllHosts = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private String serviceName = "ignite";
    private String namespace = "default";
    private String master = "https://kubernetes.default.svc.cluster.local:443";
    private String accountToken = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private URL url;
    private SSLContext ctx;

    public TcpDiscoveryKubernetesIpFinder() {
        this.setShared(true);
    }

    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        this.init();
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Getting Apache Ignite endpoints from: " + this.url);
            }
            HttpsURLConnection conn = (HttpsURLConnection)this.url.openConnection();
            conn.setHostnameVerifier(this.trustAllHosts);
            conn.setSSLSocketFactory(this.ctx.getSocketFactory());
            conn.addRequestProperty("Authorization", "Bearer " + this.serviceAccountToken(this.accountToken));
            ObjectMapper mapper = new ObjectMapper();
            Endpoints endpoints = (Endpoints)mapper.readValue(conn.getInputStream(), Endpoints.class);
            if (endpoints != null && endpoints.subsets != null && !endpoints.subsets.isEmpty()) {
                for (Subset subset : endpoints.subsets) {
                    if (subset.addresses == null || subset.addresses.isEmpty()) continue;
                    for (Address address : subset.addresses) {
                        addrs.add(new InetSocketAddress(address.ip, 0));
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Added an address to the list: " + address.ip);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IgniteSpiException("Failed to retrieve Ignite pods IP addresses.", (Throwable)e);
        }
        return addrs;
    }

    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
    }

    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
    }

    public void setServiceName(String service) {
        this.serviceName = service;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setMasterUrl(String master) {
        this.master = master;
    }

    public void setAccountToken(String accountToken) {
        this.accountToken = accountToken;
    }

    private void init() throws IgniteSpiException {
        if (this.initGuard.compareAndSet(false, true)) {
            if (this.serviceName == null || this.serviceName.isEmpty() || this.namespace == null || this.namespace.isEmpty() || this.master == null || this.master.isEmpty() || this.accountToken == null || this.accountToken.isEmpty()) {
                throw new IgniteSpiException("One or more configuration parameters are invalid [setServiceName=" + this.serviceName + ", setNamespace=" + this.namespace + ", setMasterUrl=" + this.master + ", setAccountToken=" + this.accountToken + "]");
            }
            try {
                String path = String.format("/api/v1/namespaces/%s/endpoints/%s", this.namespace, this.serviceName);
                this.url = new URL(this.master + path);
                this.ctx = SSLContext.getInstance("SSL");
                this.ctx.init(null, this.trustAll, new SecureRandom());
            }
            catch (Exception e) {
                throw new IgniteSpiException("Failed to connect to Ignite's Kubernetes Service.", (Throwable)e);
            }
            finally {
                this.initLatch.countDown();
            }
        }
        try {
            U.await((CountDownLatch)this.initLatch);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteSpiException("Thread has been interrupted.", (Throwable)e);
        }
        if (this.url == null || this.ctx == null) {
            throw new IgniteSpiException("IP finder has not been initialized properly.");
        }
    }

    private String serviceAccountToken(String file) {
        try {
            return new String(Files.readAllBytes(Paths.get(file, new String[0])));
        }
        catch (IOException e) {
            throw new IgniteSpiException("Failed to load services account token [setAccountToken= " + file + "]", (Throwable)e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Endpoints {
        public List<Subset> subsets;

        private Endpoints() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Subset {
        public List<Address> addresses;

        private Subset() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Address {
        public String ip;

        private Address() {
        }
    }
}

