/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshaller;

import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.marshaller.AbstractNodeNameAwareMarshaller;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.jetbrains.annotations.Nullable;

public class MarshallerUtils {
    public static final String JDK_CLS_NAMES_FILE = "META-INF/classnames-jdk.properties";
    public static final String CLS_NAMES_FILE = "META-INF/classnames.properties";
    private static final ThreadLocal<IgniteProductVersion> JOB_SND_NODE_VER = new ThreadLocal();

    public static void setNodeName(Marshaller marsh, @Nullable String nodeName) {
        if (marsh instanceof AbstractNodeNameAwareMarshaller) {
            ((AbstractNodeNameAwareMarshaller)marsh).nodeName(nodeName);
        }
    }

    public static JdkMarshaller jdkMarshaller(@Nullable String nodeName) {
        JdkMarshaller marsh = new JdkMarshaller();
        MarshallerUtils.setNodeName(new JdkMarshaller(), nodeName);
        return marsh;
    }

    private MarshallerUtils() {
    }

    public static void jobSenderVersion(IgniteProductVersion ver) {
        JOB_SND_NODE_VER.set(ver);
    }

    public static IgniteProductVersion jobSenderVersion() {
        return JOB_SND_NODE_VER.get();
    }
}

