/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public final class GridDhtTxPrepareFuture
extends GridCacheCompoundFuture<IgniteInternalTx, GridNearTxPrepareResponse>
implements GridCacheVersionedFuture<GridNearTxPrepareResponse>,
IgniteDiagnosticAware {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static final AtomicReferenceFieldUpdater<GridDhtTxPrepareFuture, Throwable> ERR_UPD = AtomicReferenceFieldUpdater.newUpdater(GridDhtTxPrepareFuture.class, Throwable.class, "err");
    private static final IgniteReducer<IgniteInternalTx, GridNearTxPrepareResponse> REDUCER = new IgniteReducer<IgniteInternalTx, GridNearTxPrepareResponse>(){

        @Override
        public boolean collect(IgniteInternalTx e) {
            return true;
        }

        @Override
        public GridNearTxPrepareResponse reduce() {
            return null;
        }
    };
    private static final AtomicIntegerFieldUpdater<GridDhtTxPrepareFuture> REPLIED_UPD = AtomicIntegerFieldUpdater.newUpdater(GridDhtTxPrepareFuture.class, "replied");
    private static final AtomicIntegerFieldUpdater<GridDhtTxPrepareFuture> MAPPED_UPD = AtomicIntegerFieldUpdater.newUpdater(GridDhtTxPrepareFuture.class, "mapped");
    private static IgniteLogger log;
    private static IgniteLogger msgLog;
    private GridCacheSharedContext<?, ?> cctx;
    private IgniteUuid futId;
    @GridToStringExclude
    private GridDhtTxLocalAdapter tx;
    private Map<UUID, GridDistributedTxMapping> nearMap;
    private Map<UUID, GridDistributedTxMapping> dhtMap;
    private volatile Throwable err;
    private volatile int replied;
    private volatile int mapped;
    private GridNearTxPrepareRequest req;
    private boolean trackable = true;
    private int nearMiniId;
    private Map<IgniteTxKey, GridCacheVersion> dhtVerMap;
    private boolean last;
    private boolean retVal;
    private GridCacheReturn ret;
    private Collection<IgniteTxKey> filterFailedKeys;
    @GridToStringInclude
    private final Set<IgniteTxKey> lockKeys = new HashSet<IgniteTxKey>();
    private IgniteInternalFuture<?> forceKeysFut;
    private volatile boolean locksReady;
    private boolean invoke;
    private final PrepareTimeoutObject timeoutObj;

    public GridDhtTxPrepareFuture(GridCacheSharedContext cctx, GridDhtTxLocalAdapter tx, long timeout, int nearMiniId, Map<IgniteTxKey, GridCacheVersion> dhtVerMap, boolean last, boolean retVal) {
        super(REDUCER);
        this.cctx = cctx;
        this.tx = tx;
        this.dhtVerMap = dhtVerMap;
        this.last = last;
        this.futId = IgniteUuid.randomUuid();
        this.nearMiniId = nearMiniId;
        if (log == null) {
            msgLog = cctx.txPrepareMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridDhtTxPrepareFuture.class);
        }
        this.dhtMap = tx.dhtMap();
        this.nearMap = tx.nearMap();
        this.retVal = retVal;
        assert (this.dhtMap != null);
        assert (this.nearMap != null);
        this.timeoutObj = timeout > 0L ? new PrepareTimeoutObject(timeout) : null;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    int nearMiniId() {
        return this.nearMiniId;
    }

    @Override
    public GridCacheVersion version() {
        return this.tx.xidVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        boolean rmv;
        if (log.isDebugEnabled()) {
            log.debug("Transaction future received owner changed callback: " + entry);
        }
        GridDhtTxPrepareFuture gridDhtTxPrepareFuture = this;
        synchronized (gridDhtTxPrepareFuture) {
            rmv = this.lockKeys.remove(entry.txKey());
        }
        return rmv && this.mapIfLocked();
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    public GridDhtTxLocalAdapter tx() {
        return this.tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLocks() {
        if (!this.locksReady) {
            return false;
        }
        GridDhtTxPrepareFuture gridDhtTxPrepareFuture = this;
        synchronized (gridDhtTxPrepareFuture) {
            return this.lockKeys.isEmpty();
        }
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            f.onNodeLeft();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEntriesLocked() {
        this.ret = new GridCacheReturn(null, this.tx.localResult(), true, null, true);
        for (IgniteTxEntry writeEntry : this.req.writes()) {
            IgniteTxEntry txEntry = this.tx.entry(writeEntry.txKey());
            assert (txEntry != null) : writeEntry;
            GridCacheContext<?, ?> cacheCtx = txEntry.context();
            GridCacheEntryEx cached = txEntry.cached();
            ExpiryPolicy expiry = cacheCtx.expiryForTxEntry(txEntry);
            this.cctx.database().checkpointReadLock();
            try {
                boolean sndOldVal;
                boolean readOld;
                if ((txEntry.op() == GridCacheOperation.CREATE || txEntry.op() == GridCacheOperation.UPDATE) && txEntry.conflictExpireTime() == -1L && expiry != null) {
                    cached.unswap(true);
                    Duration duration = cached.hasValue() ? expiry.getExpiryForUpdate() : expiry.getExpiryForCreation();
                    txEntry.ttl(CU.toTtl(duration));
                }
                boolean hasFilters = !F.isEmptyOrNulls(txEntry.filters()) && !F.isAlwaysTrue(txEntry.filters());
                CacheObject oldVal = null;
                boolean bl = readOld = hasFilters || this.retVal || txEntry.op() == GridCacheOperation.DELETE || txEntry.op() == GridCacheOperation.TRANSFORM || this.tx.nearOnOriginatingNode() || this.tx.hasInterceptor();
                if (readOld) {
                    boolean readThrough = !txEntry.skipStore() && (txEntry.op() == GridCacheOperation.TRANSFORM || (this.retVal || hasFilters) && cacheCtx.config().isLoadPreviousValue());
                    boolean evt = this.retVal || txEntry.op() == GridCacheOperation.TRANSFORM;
                    EntryProcessor entryProc = null;
                    if (evt && txEntry.op() == GridCacheOperation.TRANSFORM) {
                        entryProc = (EntryProcessor)F.first(txEntry.entryProcessors()).get1();
                    }
                    boolean keepBinary = txEntry.keepBinary();
                    CacheObject val = oldVal = cached.innerGet(null, this.tx, readThrough, this.retVal, evt, this.tx.subjectId(), entryProc, this.tx.resolveTaskName(), null, keepBinary);
                    if (this.retVal || txEntry.op() == GridCacheOperation.TRANSFORM) {
                        if (!F.isEmpty(txEntry.entryProcessors())) {
                            GridCacheOperation op;
                            this.invoke = true;
                            if (txEntry.hasValue()) {
                                val = txEntry.value();
                            }
                            KeyCacheObject key = txEntry.key();
                            Object procRes = null;
                            Exception err = null;
                            boolean modified = false;
                            txEntry.oldValueOnPrimary(val != null);
                            for (T2<EntryProcessor<Object, Object, Object>, Object[]> t : txEntry.entryProcessors()) {
                                CacheInvokeEntry invokeEntry;
                                block33: {
                                    invokeEntry = new CacheInvokeEntry(key, val, txEntry.cached().version(), keepBinary, txEntry.cached());
                                    try {
                                        EntryProcessor processor = (EntryProcessor)t.get1();
                                        procRes = processor.process(invokeEntry, (Object[])t.get2());
                                        val = cacheCtx.toCacheObject(invokeEntry.getValue(true));
                                        if (val == null) break block33;
                                        cacheCtx.validateKeyAndValue(key, val);
                                    }
                                    catch (Exception e) {
                                        err = e;
                                        break;
                                    }
                                }
                                modified |= invokeEntry.modified();
                            }
                            if (modified) {
                                val = cacheCtx.toCacheObject(cacheCtx.unwrapTemporary(val));
                            }
                            GridCacheOperation gridCacheOperation = modified ? (val == null ? GridCacheOperation.DELETE : GridCacheOperation.UPDATE) : (op = GridCacheOperation.NOOP);
                            if (op == GridCacheOperation.NOOP && expiry != null) {
                                long ttl = CU.toTtl(expiry.getExpiryForAccess());
                                txEntry.ttl(ttl);
                                if (ttl == -2L) {
                                    op = GridCacheOperation.DELETE;
                                }
                            }
                            txEntry.entryProcessorCalculatedValue(new T2<GridCacheOperation, CacheObject>(op, op == GridCacheOperation.NOOP ? null : val));
                            if (this.retVal) {
                                if (err != null || procRes != null) {
                                    this.ret.addEntryProcessResult(txEntry.context(), key, null, procRes, err, keepBinary);
                                } else {
                                    this.ret.invokeResult(true);
                                }
                            }
                        } else if (this.retVal) {
                            this.ret.value(cacheCtx, val, keepBinary);
                        }
                    }
                    if (hasFilters && !cacheCtx.isAll(cached, txEntry.filters())) {
                        if (expiry != null) {
                            txEntry.ttl(CU.toTtl(expiry.getExpiryForAccess()));
                        }
                        txEntry.op(GridCacheOperation.NOOP);
                        if (this.filterFailedKeys == null) {
                            this.filterFailedKeys = new ArrayList<IgniteTxKey>();
                        }
                        this.filterFailedKeys.add(cached.txKey());
                        this.ret.success(false);
                    } else {
                        this.ret.success(txEntry.op() != GridCacheOperation.DELETE || cached.hasValue());
                    }
                }
                if (!(sndOldVal = !cacheCtx.isLocal() && !cacheCtx.topology().rebalanceFinished(this.tx.topologyVersion()))) continue;
                if (oldVal == null && !readOld) {
                    oldVal = cached.innerGet(null, this.tx, false, false, false, this.tx.subjectId(), null, null, null, true);
                }
                if (oldVal != null) {
                    oldVal.prepareMarshal(cacheCtx.cacheObjectContext());
                }
                txEntry.oldValue(oldVal);
            }
            catch (IgniteCheckedException e) {
                U.error(log, "Failed to get result value for cache entry: " + cached, e);
            }
            catch (GridCacheEntryRemovedException e) {
                assert (false) : "Got entry removed exception while holding transactional lock on entry [e=" + e + ", cached=" + cached + ']';
            }
            finally {
                this.cctx.database().checkpointReadUnlock();
            }
        }
    }

    public void onError(Throwable t) {
        this.onDone(null, t);
    }

    public void onResult(UUID nodeId, GridDhtTxPrepareResponse res) {
        if (this.isDone()) {
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("DHT prepare fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
            return;
        }
        MiniFuture mini = this.miniFuture(res.miniId());
        if (mini != null) {
            assert (mini.node().id().equals(nodeId));
            mini.onResult(res);
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("DHT prepare fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(int miniId) {
        GridDhtTxPrepareFuture gridDhtTxPrepareFuture = this;
        synchronized (gridDhtTxPrepareFuture) {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || (mini = (MiniFuture)fut).futureId() != miniId) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    private void readyLocks() {
        if (log.isDebugEnabled()) {
            log.debug("Marking all local candidates as ready: " + this);
        }
        this.readyLocks(this.req.writes());
        if (this.tx.serializable() && this.tx.optimistic()) {
            this.readyLocks(this.req.reads());
        }
        this.locksReady = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readyLocks(Iterable<IgniteTxEntry> checkEntries) {
        block5: for (IgniteTxEntry txEntry : checkEntries) {
            GridCacheContext<?, ?> cacheCtx = txEntry.context();
            if (cacheCtx.isLocal()) continue;
            GridDistributedCacheEntry entry = (GridDistributedCacheEntry)txEntry.cached();
            if (entry == null) {
                entry = (GridDistributedCacheEntry)cacheCtx.cache().entryEx(txEntry.key(), this.tx.topologyVersion());
                txEntry.cached(entry);
            }
            if (this.tx.optimistic() && txEntry.explicitVersion() == null) {
                GridDhtTxPrepareFuture gridDhtTxPrepareFuture = this;
                synchronized (gridDhtTxPrepareFuture) {
                    this.lockKeys.add(txEntry.txKey());
                }
            }
            while (true) {
                try {
                    assert (txEntry.explicitVersion() == null || entry.lockedBy(txEntry.explicitVersion()));
                    CacheLockCandidates owners = entry.readyLock(this.tx.xidVersion());
                    if (!log.isDebugEnabled()) continue block5;
                    log.debug("Current lock owners for entry [owner=" + owners + ", entry=" + entry + ']');
                    continue block5;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (log.isDebugEnabled()) {
                        log.debug("Got removed entry in future onAllReplies method (will retry): " + txEntry);
                    }
                    entry = (GridDistributedCacheEntry)cacheCtx.cache().entryEx(txEntry.key(), this.tx.topologyVersion());
                    txEntry.cached(entry);
                    continue;
                }
                break;
            }
        }
    }

    private boolean mapIfLocked() {
        if (this.checkLocks()) {
            if (!MAPPED_UPD.compareAndSet(this, 0, 1)) {
                return false;
            }
            if (this.forceKeysFut == null || this.forceKeysFut.isDone() && this.forceKeysFut.error() == null) {
                this.prepare0();
            } else {
                this.forceKeysFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> f) {
                        try {
                            f.get();
                            GridDhtTxPrepareFuture.this.prepare0();
                        }
                        catch (IgniteCheckedException e) {
                            GridDhtTxPrepareFuture.this.onError(e);
                        }
                        finally {
                            GridDhtTxPrepareFuture.this.cctx.txContextReset();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onDone(GridNearTxPrepareResponse res0, Throwable err) {
        assert (err != null || this.initialized() && !this.hasPending()) : "On done called for prepare future that has pending mini futures: " + this;
        ERR_UPD.compareAndSet(this, null, err);
        if (this.tx.optimistic()) {
            this.tx.clearPrepareFuture(this);
        }
        if (this.tx.onePhaseCommit() && this.tx.commitOnPrepare()) {
            assert (this.last);
            Throwable prepErr = this.err;
            final GridNearTxPrepareResponse res = this.createPrepareResponse(prepErr);
            this.onComplete(res);
            if (this.tx.commitOnPrepare()) {
                if (this.tx.markFinalizing(IgniteInternalTx.FinalizationStatus.USER_FINISH)) {
                    IgniteInternalFuture<IgniteInternalTx> fut = null;
                    CIX1<IgniteInternalFuture<IgniteInternalTx>> resClo = new CIX1<IgniteInternalFuture<IgniteInternalTx>>(){

                        @Override
                        public void applyx(IgniteInternalFuture<IgniteInternalTx> fut) {
                            if (res.error() == null && fut.error() != null) {
                                res.error(fut.error());
                            }
                            if (REPLIED_UPD.compareAndSet(GridDhtTxPrepareFuture.this, 0, 1)) {
                                GridDhtTxPrepareFuture.this.sendPrepareResponse(res);
                            }
                        }
                    };
                    if (prepErr == null) {
                        try {
                            fut = this.tx.commitAsync();
                        }
                        catch (Error | RuntimeException e) {
                            IgniteTxHeuristicCheckedException hEx = new IgniteTxHeuristicCheckedException("Commit produced a runtime exception: " + CU.txString(this.tx), e);
                            res.error(hEx);
                            this.tx.systemInvalidate(true);
                            try {
                                fut = this.tx.rollbackAsync();
                                fut.listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)resClo);
                            }
                            catch (Throwable e1) {
                                e.addSuppressed(e1);
                            }
                            throw e;
                        }
                    }
                    if (!this.cctx.kernalContext().isStopping()) {
                        try {
                            fut = this.tx.rollbackAsync();
                        }
                        catch (Throwable e) {
                            err.addSuppressed(e);
                            fut = null;
                        }
                    }
                    if (fut != null) {
                        fut.listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)resClo);
                    }
                }
            } else if (REPLIED_UPD.compareAndSet(this, 0, 1)) {
                this.sendPrepareResponse(res);
            }
            return true;
        }
        if (REPLIED_UPD.compareAndSet(this, 0, 1)) {
            GridNearTxPrepareResponse res = this.createPrepareResponse(this.err);
            try {
                this.sendPrepareResponse(res);
            }
            finally {
                this.onComplete(res);
            }
            return true;
        }
        try {
            if (err != null) {
                this.get();
            }
        }
        catch (IgniteInterruptedException e) {
            this.onError(new IgniteCheckedException("Got interrupted while waiting for replies to be sent.", e));
        }
        catch (IgniteCheckedException igniteCheckedException) {
            // empty catch block
        }
        return false;
    }

    private void sendPrepareResponse(GridNearTxPrepareResponse res) {
        if (!this.tx.nearNodeId().equals(this.cctx.localNodeId())) {
            Throwable err = this.err;
            if (err != null && err instanceof IgniteFutureCancelledException) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT prepare fut, skip send response [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + this.tx.nearNodeId() + ", err=" + err + ", res=" + res + ']');
                }
                return;
            }
            try {
                this.cctx.io().send(this.tx.nearNodeId(), (GridCacheMessage)res, this.tx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT prepare fut, sent response [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + this.tx.nearNodeId() + ", res=" + res + ']');
                }
            }
            catch (ClusterTopologyCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Failed to send prepare response, node left [txId=" + this.tx.nearXidVersion() + "," + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + this.tx.nearNodeId() + ", res=" + res + ']');
                }
            }
            catch (IgniteCheckedException e) {
                U.error(msgLog, "Failed to send prepare response [txId=" + this.tx.nearXidVersion() + "," + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + this.tx.nearNodeId() + ", res=" + res, ", tx=" + this.tx + ']', e);
            }
        }
    }

    private GridNearTxPrepareResponse createPrepareResponse(@Nullable Throwable prepErr) {
        assert (F.isEmpty(this.tx.invalidPartitions()));
        GridNearTxPrepareResponse res = new GridNearTxPrepareResponse(-1, this.tx.nearXidVersion(), this.tx.colocated() ? this.tx.xid() : this.tx.nearFutureId(), this.nearMiniId, this.tx.xidVersion(), this.tx.writeVersion(), this.ret, prepErr, null, this.tx.onePhaseCommit(), this.tx.activeCachesDeploymentEnabled());
        if (prepErr == null) {
            if (this.tx.needReturnValue() || this.tx.nearOnOriginatingNode() || this.tx.hasInterceptor()) {
                this.addDhtValues(res);
            }
            GridCacheVersion min = this.tx.minVersion();
            if (this.tx.needsCompletedVersions()) {
                IgnitePair<Collection<GridCacheVersion>> versPair = this.cctx.tm().versions(min);
                res.completedVersions((Collection)versPair.get1(), (Collection)versPair.get2());
            }
            res.pending(this.localDhtPendingVersions(this.tx.writeEntries(), min));
            this.tx.implicitSingleResult(this.ret);
        }
        res.filterFailedKeys(this.filterFailedKeys);
        return res;
    }

    private void addDhtValues(GridNearTxPrepareResponse res) {
        CacheObject val0;
        GridCacheVersion dhtVer;
        GridCacheEntryEx entry;
        GridCacheContext<?, ?> cacheCtx;
        IgniteTxEntry txEntry;
        if (!F.isEmpty(this.req.writes())) {
            block4: for (IgniteTxEntry igniteTxEntry : this.req.writes()) {
                txEntry = this.tx.entry(igniteTxEntry.txKey());
                assert (txEntry != null) : "Missing tx entry for key [tx=" + this.tx + ", key=" + igniteTxEntry.txKey() + ']';
                cacheCtx = txEntry.context();
                while (true) {
                    try {
                        entry = txEntry.cached();
                        dhtVer = entry.version();
                        val0 = entry.valueBytes();
                        if (val0 == null) continue block4;
                        res.addOwnedValue(txEntry.txKey(), dhtVer, val0);
                        continue block4;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        txEntry.cached(cacheCtx.cache().entryEx(txEntry.key(), this.tx.topologyVersion()));
                        continue;
                    }
                    break;
                }
            }
        }
        block6: for (Map.Entry entry2 : this.dhtVerMap.entrySet()) {
            txEntry = this.tx.entry((IgniteTxKey)entry2.getKey());
            if (res.hasOwnedValue((IgniteTxKey)entry2.getKey())) continue;
            assert (txEntry != null) : entry2;
            cacheCtx = txEntry.context();
            while (true) {
                try {
                    entry = txEntry.cached();
                    dhtVer = entry.version();
                    if (entry2.getValue() != null && ((GridCacheVersion)entry2.getValue()).equals(dhtVer)) continue block6;
                    val0 = entry.valueBytes();
                    res.addOwnedValue(txEntry.txKey(), dhtVer, val0);
                    continue block6;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    txEntry.cached(cacheCtx.cache().entryEx(txEntry.key(), this.tx.topologyVersion()));
                    continue;
                }
                break;
            }
        }
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    private boolean onComplete(@Nullable GridNearTxPrepareResponse res) {
        if (this.last || this.tx.isSystemInvalidate()) {
            this.tx.state(TransactionState.PREPARED);
        }
        if (super.onDone(res, res == null ? this.err : null)) {
            this.cctx.mvcc().removeVersionedFuture(this);
            if (this.timeoutObj != null) {
                this.cctx.time().removeTimeoutObject(this.timeoutObj);
            }
            return true;
        }
        return false;
    }

    public void complete() {
        GridNearTxPrepareResponse res = new GridNearTxPrepareResponse();
        res.error(this.err != null ? this.err : new IgniteCheckedException("Failed to prepare transaction."));
        this.onComplete(res);
    }

    public void prepare(GridNearTxPrepareRequest req) {
        boolean ser;
        assert (req != null);
        if (this.tx.empty()) {
            this.tx.setRollbackOnly();
            this.onDone((GridNearTxPrepareResponse)null);
        }
        this.req = req;
        boolean bl = ser = this.tx.serializable() && this.tx.optimistic();
        if (!F.isEmpty(req.writes()) || ser && !F.isEmpty(req.reads())) {
            Map<Integer, Collection<KeyCacheObject>> forceKeys = null;
            for (IgniteTxEntry entry : req.writes()) {
                forceKeys = this.checkNeedRebalanceKeys(entry, forceKeys);
            }
            if (ser) {
                for (IgniteTxEntry entry : req.reads()) {
                    forceKeys = this.checkNeedRebalanceKeys(entry, forceKeys);
                }
            }
            this.forceKeysFut = this.forceRebalanceKeys(forceKeys);
        }
        this.readyLocks();
        if (this.timeoutObj != null && !this.isDone()) {
            this.cctx.time().addTimeoutObject(this.timeoutObj);
        }
        this.mapIfLocked();
    }

    private Map<Integer, Collection<KeyCacheObject>> checkNeedRebalanceKeys(IgniteTxEntry e, Map<Integer, Collection<KeyCacheObject>> map) {
        if (this.retVal || !F.isEmpty(e.entryProcessors()) || !F.isEmpty(e.filters()) || e.entryReadVersion() != null) {
            Collection<KeyCacheObject> keys;
            if (map == null) {
                map = new HashMap<Integer, Collection<KeyCacheObject>>();
            }
            if ((keys = map.get(e.cacheId())) == null) {
                keys = new ArrayList<KeyCacheObject>();
                map.put(e.cacheId(), keys);
            }
            keys.add(e.key());
        }
        return map;
    }

    private IgniteInternalFuture<Object> forceRebalanceKeys(Map<Integer, Collection<KeyCacheObject>> keysMap) {
        if (F.isEmpty(keysMap)) {
            return null;
        }
        GridCompoundFuture compFut = null;
        GridDhtFuture<Object> lastForceFut = null;
        for (Map.Entry<Integer, Collection<KeyCacheObject>> entry : keysMap.entrySet()) {
            if (lastForceFut != null && compFut == null) {
                compFut = new GridCompoundFuture();
                compFut.add(lastForceFut);
            }
            int cacheId = entry.getKey();
            Collection<KeyCacheObject> keys = entry.getValue();
            GridCacheContext<?, ?> ctx = this.cctx.cacheContext(cacheId);
            lastForceFut = ctx.group().preloader().request(ctx, keys, this.tx.topologyVersion());
            if (compFut == null || lastForceFut == null) continue;
            compFut.add(lastForceFut);
        }
        if (compFut != null) {
            compFut.markInitialized();
            return compFut;
        }
        return lastForceFut;
    }

    @Nullable
    private IgniteCheckedException checkReadConflict(Iterable<IgniteTxEntry> entries) throws IgniteCheckedException {
        block3: {
            try {
                for (IgniteTxEntry entry : entries) {
                    GridCacheVersion serReadVer = entry.entryReadVersion();
                    if (serReadVer == null) continue;
                    entry.cached().unswap();
                    if (entry.cached().checkSerializableReadVersion(serReadVer)) continue;
                    return this.versionCheckError(entry);
                }
            }
            catch (GridCacheEntryRemovedException ignore) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("Got removed exception on entry with dht local candidate: " + entries));
            }
        }
        return null;
    }

    private IgniteTxOptimisticCheckedException versionCheckError(IgniteTxEntry entry) {
        StringBuilder msg = new StringBuilder("Failed to prepare transaction, read/write conflict [");
        GridCacheContext<?, ?> cctx = entry.context();
        try {
            Object key = cctx.unwrapBinaryIfNeeded(entry.key(), entry.keepBinary(), false);
            assert (key != null) : entry.key();
            if (S.INCLUDE_SENSITIVE) {
                msg.append("key=").append(key.toString()).append(", keyCls=").append(key.getClass().getName());
            }
        }
        catch (Exception e) {
            msg.append("key=<failed to get key: ").append(e.toString()).append(">");
        }
        try {
            Object val;
            GridCacheEntryEx entryEx = entry.cached();
            CacheObject cacheVal = entryEx != null ? entryEx.rawGet() : null;
            Object object = val = cacheVal != null ? cctx.unwrapBinaryIfNeeded(cacheVal, entry.keepBinary(), false) : null;
            if (val != null) {
                if (S.INCLUDE_SENSITIVE) {
                    msg.append(", val=").append(val.toString()).append(", valCls=").append(val.getClass().getName());
                }
            } else {
                msg.append(", val=null");
            }
        }
        catch (Exception e) {
            msg.append(", val=<failed to get value: ").append(e.toString()).append(">");
        }
        msg.append(", cache=").append(cctx.name()).append(", thread=").append(Thread.currentThread()).append("]");
        return new IgniteTxOptimisticCheckedException(msg.toString());
    }

    private void prepare0() {
        try {
            if (this.tx.serializable() && this.tx.optimistic()) {
                IgniteCheckedException err0;
                try {
                    err0 = this.checkReadConflict(this.req.writes());
                    if (err0 == null) {
                        err0 = this.checkReadConflict(this.req.reads());
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(log, "Failed to check entry version: " + e, e);
                    err0 = e;
                }
                if (err0 != null) {
                    ERR_UPD.compareAndSet(this, null, err0);
                    try {
                        this.tx.rollbackAsync();
                    }
                    catch (Throwable e) {
                        err0.addSuppressed(e);
                    }
                    GridNearTxPrepareResponse res = this.createPrepareResponse(this.err);
                    this.onDone(res, res.error());
                    return;
                }
            }
            this.onEntriesLocked();
            this.tx.writeVersion(this.cctx.versions().next(this.tx.topologyVersion()));
            if (!F.isEmpty(this.req.writes())) {
                for (IgniteTxEntry write : this.req.writes()) {
                    this.map(this.tx.entry(write.txKey()));
                }
            }
            if (!F.isEmpty(this.req.reads())) {
                for (IgniteTxEntry read : this.req.reads()) {
                    this.map(this.tx.entry(read.txKey()));
                }
            }
            if (this.isDone()) {
                return;
            }
            if (this.last) {
                this.sendPrepareRequests();
            }
        }
        finally {
            this.markInitialized();
        }
    }

    private void sendPrepareRequests() {
        if (this.tx.onePhaseCommit() && !this.tx.nearMap().isEmpty()) {
            for (GridDistributedTxMapping nearMapping : this.tx.nearMap().values()) {
                if (this.tx.dhtMap().containsKey(nearMapping.primary().id())) continue;
                this.tx.onePhaseCommit(false);
                break;
            }
        }
        int miniId = 0;
        assert (this.tx.transactionNodes() != null);
        long timeout = this.timeoutObj != null ? this.timeoutObj.timeout : 0L;
        for (GridDistributedTxMapping dhtMapping : this.tx.dhtMap().values()) {
            assert (!dhtMapping.empty());
            ClusterNode n = dhtMapping.primary();
            assert (!n.isLocal());
            GridDistributedTxMapping nearMapping = this.tx.nearMap().get(n.id());
            Collection<IgniteTxEntry> nearWrites = nearMapping == null ? null : nearMapping.writes();
            Collection<IgniteTxEntry> dhtWrites = dhtMapping.writes();
            if (F.isEmpty(dhtWrites) && F.isEmpty(nearWrites)) continue;
            if (this.tx.remainingTime() == -1L) {
                return;
            }
            MiniFuture fut = new MiniFuture(n.id(), ++miniId, dhtMapping, nearMapping);
            this.add(fut);
            assert (this.req.transactionNodes() != null);
            GridDhtTxPrepareRequest req = new GridDhtTxPrepareRequest(this.futId, fut.futureId(), this.tx.topologyVersion(), this.tx, timeout, dhtWrites, nearWrites, this.req.transactionNodes(), this.tx.nearXidVersion(), true, this.tx.onePhaseCommit(), this.tx.subjectId(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled(), this.tx.storeWriteThrough(), this.retVal);
            int idx = 0;
            for (IgniteTxEntry entry : dhtWrites) {
                try {
                    List<ClusterNode> owners;
                    GridDhtCacheEntry cached = (GridDhtCacheEntry)entry.cached();
                    GridCacheContext cacheCtx = cached.context();
                    req.invalidateNearEntry(idx, !this.tx.nearNodeId().equals(n.id()) && cached.readerId(n.id()) != null);
                    if (!cached.isNewLocked() || (owners = cacheCtx.topology().owners(cached.partition(), this.tx != null ? this.tx.topologyVersion() : cacheCtx.affinity().affinityTopologyVersion())).contains(this.cctx.localNode())) break;
                    req.markKeyForPreload(idx);
                    break;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    assert (false) : "Got removed exception on entry with dht local candidate: " + entry;
                    ++idx;
                }
            }
            if (!F.isEmpty(nearWrites)) {
                Iterator<IgniteTxEntry> iterator = nearWrites.iterator();
                while (iterator.hasNext()) {
                    IgniteTxEntry entry;
                    entry = iterator.next();
                    try {
                        if (entry.explicitVersion() != null) break;
                        GridCacheMvccCandidate added = entry.cached().candidate(this.version());
                        assert (added != null) : "Missing candidate for cache entry:" + entry;
                        assert (added.dhtLocal());
                        if (added.ownerVersion() == null) break;
                        req.owned(entry.txKey(), added.ownerVersion());
                        break;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        assert (false) : "Got removed exception on entry with dht local candidate: " + entry;
                    }
                }
            }
            assert (req.transactionNodes() != null);
            try {
                this.cctx.io().send(n, (GridCacheMessage)req, this.tx.ioPolicy());
                if (!msgLog.isDebugEnabled()) continue;
                msgLog.debug("DHT prepare fut, sent request dht [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ']');
            }
            catch (ClusterTopologyCheckedException ignored) {
                fut.onNodeLeft();
            }
            catch (IgniteCheckedException e) {
                if (!this.cctx.kernalContext().isStopping()) {
                    if (msgLog.isDebugEnabled()) {
                        msgLog.debug("DHT prepare fut, failed to send request dht [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ']');
                    }
                    fut.onResult(e);
                    continue;
                }
                if (!msgLog.isDebugEnabled()) continue;
                msgLog.debug("DHT prepare fut, failed to send request dht, ignore [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ", err=" + e + ']');
            }
        }
        for (GridDistributedTxMapping nearMapping : this.tx.nearMap().values()) {
            if (this.tx.dhtMap().containsKey(nearMapping.primary().id())) continue;
            if (this.tx.remainingTime() == -1L) {
                return;
            }
            MiniFuture fut = new MiniFuture(nearMapping.primary().id(), ++miniId, null, nearMapping);
            this.add(fut);
            GridDhtTxPrepareRequest req = new GridDhtTxPrepareRequest(this.futId, fut.futureId(), this.tx.topologyVersion(), this.tx, timeout, null, nearMapping.writes(), this.tx.transactionNodes(), this.tx.nearXidVersion(), true, this.tx.onePhaseCommit(), this.tx.subjectId(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled(), this.tx.storeWriteThrough(), this.retVal);
            for (IgniteTxEntry entry : nearMapping.entries()) {
                if (!CU.writes().apply(entry)) continue;
                try {
                    if (entry.explicitVersion() != null) break;
                    GridCacheMvccCandidate added = entry.cached().candidate(this.version());
                    assert (added != null) : "Null candidate for non-group-lock entry [added=" + added + ", entry=" + entry + ']';
                    assert (added.dhtLocal()) : "Got non-dht-local candidate for prepare future[added=" + added + ", entry=" + entry + ']';
                    if (added == null || added.ownerVersion() == null) break;
                    req.owned(entry.txKey(), added.ownerVersion());
                    break;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    assert (false) : "Got removed exception on entry with dht local candidate: " + entry;
                }
            }
            assert (req.transactionNodes() != null);
            try {
                this.cctx.io().send(nearMapping.primary(), (GridCacheMessage)req, this.tx.ioPolicy());
                if (!msgLog.isDebugEnabled()) continue;
                msgLog.debug("DHT prepare fut, sent request near [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearMapping.primary().id() + ']');
            }
            catch (ClusterTopologyCheckedException ignored) {
                fut.onNodeLeft();
            }
            catch (IgniteCheckedException e) {
                if (!this.cctx.kernalContext().isStopping()) {
                    if (msgLog.isDebugEnabled()) {
                        msgLog.debug("DHT prepare fut, failed to send request near [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearMapping.primary().id() + ']');
                    }
                    fut.onResult(e);
                    continue;
                }
                if (!msgLog.isDebugEnabled()) continue;
                msgLog.debug("DHT prepare fut, failed to send request near, ignore [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearMapping.primary().id() + ", err=" + e + ']');
            }
        }
    }

    private void map(IgniteTxEntry entry) {
        if (entry.cached().isLocal()) {
            return;
        }
        GridDhtCacheEntry cached = (GridDhtCacheEntry)entry.cached();
        GridCacheContext<?, ?> cacheCtx = entry.context();
        GridDhtCacheAdapter<?, ?> dht = cacheCtx.isNear() ? cacheCtx.near().dht() : cacheCtx.dht();
        ExpiryPolicy expiry = cacheCtx.expiryForTxEntry(entry);
        if (expiry != null && (entry.op() == GridCacheOperation.READ || entry.op() == GridCacheOperation.NOOP)) {
            entry.op(GridCacheOperation.NOOP);
            entry.ttl(CU.toTtl(expiry.getExpiryForAccess()));
        }
        while (true) {
            try {
                List<ClusterNode> dhtNodes = dht.topology().nodes(cached.partition(), this.tx.topologyVersion());
                assert (!dhtNodes.isEmpty() && dhtNodes.get(0).id().equals(this.cctx.localNodeId())) : "localNode = " + this.cctx.localNodeId() + ", dhtNodes = " + dhtNodes;
                if (log.isDebugEnabled()) {
                    log.debug("Mapping entry to DHT nodes [nodes=" + U.toShortString(dhtNodes) + ", entry=" + entry + ']');
                }
                for (int i = 1; i < dhtNodes.size(); ++i) {
                    ClusterNode node = dhtNodes.get(i);
                    this.addMapping(entry, node, this.dhtMap);
                }
                Collection<UUID> readers = cached.readers();
                if (!F.isEmpty(readers)) {
                    for (UUID readerId : readers) {
                        ClusterNode readerNode;
                        if (readerId.equals(this.tx.nearNodeId()) || (readerNode = this.cctx.discovery().node(readerId)) == null || this.canSkipNearReader(dht, readerNode, dhtNodes)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("Mapping entry to near node [node=" + readerNode + ", entry=" + entry + ']');
                        }
                        this.addMapping(entry, readerNode, this.nearMap);
                    }
                    break;
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Entry has no near readers: " + entry);
            }
            catch (GridCacheEntryRemovedException ignore) {
                cached = dht.entryExx(entry.key(), this.tx.topologyVersion());
                entry.cached(cached);
                continue;
            }
            break;
        }
    }

    private boolean canSkipNearReader(GridDhtCacheAdapter<?, ?> dhtCache, ClusterNode readerNode, List<ClusterNode> dhtNodes) {
        int limit = Math.min(dhtCache.configuration().getBackups() + 1, dhtNodes.size());
        for (int i = 0; i < limit; ++i) {
            if (!dhtNodes.get(i).id().equals(readerNode.id())) continue;
            return true;
        }
        return false;
    }

    private void addMapping(IgniteTxEntry entry, ClusterNode n, Map<UUID, GridDistributedTxMapping> globalMap) {
        GridDistributedTxMapping global = globalMap.get(n.id());
        if (global == null) {
            global = new GridDistributedTxMapping(n);
            globalMap.put(n.id(), global);
        }
        global.add(entry);
    }

    private Collection<GridCacheVersion> localDhtPendingVersions(Iterable<IgniteTxEntry> entries, GridCacheVersion baseVer) {
        GridLeanSet<GridCacheVersion> lessPending = new GridLeanSet<GridCacheVersion>(5);
        for (IgniteTxEntry entry : entries) {
            try {
                for (GridCacheMvccCandidate cand : entry.cached().localCandidates(new GridCacheVersion[0])) {
                    if (!cand.version().isLess(baseVer)) continue;
                    lessPending.add(cand.version());
                }
            }
            catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
            }
        }
        return lessPending;
    }

    @Override
    public void addDiagnosticRequest(IgniteDiagnosticPrepareContext req) {
        if (!this.isDone()) {
            for (IgniteInternalFuture fut : this.futures()) {
                MiniFuture f;
                if (fut.isDone() || !(fut instanceof MiniFuture) || (f = (MiniFuture)fut).node().isLocal()) continue;
                GridCacheVersion dhtVer = this.tx.xidVersion();
                GridCacheVersion nearVer = this.tx.nearXidVersion();
                req.remoteTxInfo(f.nodeId, dhtVer, nearVer, "GridDhtTxPrepareFuture waiting for response [node=" + f.nodeId + ", topVer=" + this.tx.topologyVersion() + ", dhtVer=" + dhtVer + ", nearVer=" + nearVer + ", futId=" + this.futId + ", miniId=" + f.futId + ", tx=" + this.tx + ']');
                return;
            }
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                return "[node=" + ((MiniFuture)f).node().id() + ", loc=" + ((MiniFuture)f).node().isLocal() + ", done=" + f.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridDhtTxPrepareFuture.class, this, "xid", (Object)this.tx.xidVersion(), "innerFuts", futs, "super", super.toString());
    }

    private class PrepareTimeoutObject
    extends GridTimeoutObjectAdapter {
        private final long timeout;

        PrepareTimeoutObject(long timeout) {
            super(timeout);
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout() {
            GridDhtTxPrepareFuture gridDhtTxPrepareFuture = GridDhtTxPrepareFuture.this;
            synchronized (gridDhtTxPrepareFuture) {
                GridDhtTxPrepareFuture.this.clear();
                GridDhtTxPrepareFuture.this.lockKeys.clear();
            }
            GridDhtTxPrepareFuture.this.onError(new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + GridDhtTxPrepareFuture.this.tx.timeout() + ", tx=" + GridDhtTxPrepareFuture.this.tx + ']'));
        }

        public String toString() {
            return S.toString(PrepareTimeoutObject.class, this);
        }
    }

    private class MiniFuture
    extends GridFutureAdapter<IgniteInternalTx> {
        private final int futId;
        private UUID nodeId;
        @GridToStringInclude
        private GridDistributedTxMapping dhtMapping;
        @GridToStringInclude
        private GridDistributedTxMapping nearMapping;

        MiniFuture(UUID nodeId, int futId, GridDistributedTxMapping dhtMapping, GridDistributedTxMapping nearMapping) {
            assert (dhtMapping == null || nearMapping == null || dhtMapping.primary().equals(nearMapping.primary()));
            this.nodeId = nodeId;
            this.futId = futId;
            this.dhtMapping = dhtMapping;
            this.nearMapping = nearMapping;
        }

        int futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.dhtMapping != null ? this.dhtMapping.primary() : this.nearMapping.primary();
        }

        void onResult(Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
            }
            this.onDone(e);
        }

        void onNodeLeft() {
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("DHT prepare fut, mini future node left [txId=" + GridDhtTxPrepareFuture.this.tx.nearXidVersion() + ", dhtTxId=" + GridDhtTxPrepareFuture.this.tx.xidVersion() + ", node=" + this.node().id() + ']');
            }
            if (GridDhtTxPrepareFuture.this.tx != null) {
                GridDhtTxPrepareFuture.this.tx.removeMapping(this.nodeId);
            }
            this.onDone(GridDhtTxPrepareFuture.this.tx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResult(GridDhtTxPrepareResponse res) {
            if (res.error() != null) {
                GridDhtTxPrepareFuture.this.onError(res.error());
            } else {
                if (this.nearMapping != null && !F.isEmpty(res.nearEvicted())) {
                    block9: for (IgniteTxEntry entry : this.nearMapping.entries()) {
                        if (!res.nearEvicted().contains(entry.txKey())) continue;
                        while (true) {
                            try {
                                GridDhtCacheEntry cached = (GridDhtCacheEntry)entry.cached();
                                cached.removeReader(this.nearMapping.primary().id(), res.messageId());
                                continue block9;
                            }
                            catch (GridCacheEntryRemovedException ignore) {
                                GridCacheEntryEx e = entry.context().cache().peekEx(entry.key());
                                if (e == null) continue block9;
                                entry.cached(e);
                                continue;
                            }
                            break;
                        }
                    }
                    this.nearMapping.evictReaders(res.nearEvicted());
                }
                if (!F.isEmpty(res.invalidPartitionsByCacheId())) {
                    Map<Integer, int[]> invalidPartsMap = res.invalidPartitionsByCacheId();
                    Iterator<IgniteTxEntry> it = this.dhtMapping.entries().iterator();
                    while (it.hasNext()) {
                        IgniteTxEntry entry = it.next();
                        int[] invalidParts = invalidPartsMap.get(entry.cacheId());
                        if (invalidParts == null || !F.contains(invalidParts, entry.cached().partition())) continue;
                        it.remove();
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Removed mapping for entry from dht mapping [key=" + entry.key() + ", tx=" + GridDhtTxPrepareFuture.this.tx + ", dhtMapping=" + this.dhtMapping + ']');
                    }
                    if (this.dhtMapping.empty()) {
                        GridDhtTxPrepareFuture.this.dhtMap.remove(this.nodeId);
                        if (log.isDebugEnabled()) {
                            log.debug("Removed mapping for node entirely because all partitions are invalid [nodeId=" + this.nodeId + ", tx=" + GridDhtTxPrepareFuture.this.tx + ']');
                        }
                    }
                }
                AffinityTopologyVersion topVer = GridDhtTxPrepareFuture.this.tx.topologyVersion();
                boolean rec = GridDhtTxPrepareFuture.this.cctx.gridEvents().isRecordable(84);
                block12: for (GridCacheEntryInfo info : res.preloadEntries()) {
                    GridCacheContext cacheCtx = GridDhtTxPrepareFuture.this.cctx.cacheContext(info.cacheId());
                    GridCacheAdapter cache0 = cacheCtx.cache();
                    if (cache0.isNear()) {
                        cache0 = ((GridNearCacheAdapter)cache0).dht();
                    }
                    while (true) {
                        GridCacheEntryEx entry = cache0.entryEx(info.key());
                        GridDrType drType = cacheCtx.isDrEnabled() ? GridDrType.DR_PRELOAD : GridDrType.DR_NONE;
                        GridDhtTxPrepareFuture.this.cctx.database().checkpointReadLock();
                        try {
                            if (!entry.initialValue(info.value(), info.version(), info.ttl(), info.expireTime(), true, topVer, drType, false)) continue block12;
                            if (rec && !entry.isInternal()) {
                                cacheCtx.events().addEvent(entry.partition(), entry.key(), GridDhtTxPrepareFuture.this.cctx.localNodeId(), (IgniteUuid)null, null, 84, info.value(), true, null, false, null, null, null, false);
                            }
                            if (!GridDhtTxPrepareFuture.this.retVal || GridDhtTxPrepareFuture.this.invoke) continue block12;
                            GridDhtTxPrepareFuture.this.ret.value(cacheCtx, info.value(), false);
                            continue block12;
                        }
                        catch (IgniteCheckedException e) {
                            this.onDone(e);
                            return;
                        }
                        catch (GridCacheEntryRemovedException ignore) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Failed to set entry initial value (entry is obsolete, will retry): " + entry);
                            continue;
                        }
                        finally {
                            GridDhtTxPrepareFuture.this.cctx.database().checkpointReadUnlock();
                            continue;
                        }
                        break;
                    }
                }
                this.onDone(GridDhtTxPrepareFuture.this.tx);
            }
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", this.isCancelled(), "err", this.error());
        }
    }
}

