/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.util.typedef.internal.GPC;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridDhtPartitionsEvictor {
    private static final int SHOW_EVICTION_PROGRESS_FREQ_MS = 120000;
    private final GridCacheSharedContext<?, ?> ctx;
    private final CacheGroupContext grp;
    private final IgniteLogger log;
    private final ConcurrentHashMap<Integer, GridDhtLocalPartition> evictionQueue = new ConcurrentHashMap();
    private final AtomicBoolean evictionRunning = new AtomicBoolean();

    public GridDhtPartitionsEvictor(CacheGroupContext grp) {
        assert (grp != null);
        this.grp = grp;
        this.ctx = grp.shared();
        this.log = this.ctx.logger(this.getClass());
    }

    public void evictPartitionAsync(GridDhtLocalPartition part) {
        this.evictionQueue.putIfAbsent(part.id(), part);
        if (this.evictionRunning.compareAndSet(false, true)) {
            this.ctx.kernalContext().closure().callLocalSafe(new GPC<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() {
                    boolean locked = true;
                    long nextShowProgressTime = U.currentTimeMillis() + 120000L;
                    while (locked || !GridDhtPartitionsEvictor.this.evictionQueue.isEmpty()) {
                        if (!locked && !GridDhtPartitionsEvictor.this.evictionRunning.compareAndSet(false, true)) {
                            return false;
                        }
                        try {
                            for (GridDhtLocalPartition part : GridDhtPartitionsEvictor.this.evictionQueue.values()) {
                                if (U.currentTimeMillis() >= nextShowProgressTime) {
                                    if (GridDhtPartitionsEvictor.this.log.isInfoEnabled()) {
                                        GridDhtPartitionsEvictor.this.log.info("Eviction in progress [grp=" + GridDhtPartitionsEvictor.this.grp.cacheOrGroupName() + ", remainingCnt=" + GridDhtPartitionsEvictor.this.evictionQueue.size() + "]");
                                    }
                                    nextShowProgressTime = U.currentTimeMillis() + 120000L;
                                }
                                try {
                                    boolean success = part.tryClear();
                                    if (!success) continue;
                                    GridDhtPartitionsEvictor.this.evictionQueue.remove(part.id());
                                    if (part.state() != GridDhtPartitionState.EVICTED || !part.markForDestroy()) continue;
                                    part.destroy();
                                }
                                catch (Throwable ex) {
                                    if (GridDhtPartitionsEvictor.this.ctx.kernalContext().isStopping()) {
                                        LT.warn(GridDhtPartitionsEvictor.this.log, ex, "Partition eviction failed (current node is stopping).", false, true);
                                        GridDhtPartitionsEvictor.this.evictionQueue.clear();
                                        Boolean bl = true;
                                        if (!GridDhtPartitionsEvictor.this.evictionQueue.isEmpty()) {
                                            if (GridDhtPartitionsEvictor.this.ctx.kernalContext().isStopping()) {
                                                GridDhtPartitionsEvictor.this.evictionQueue.clear();
                                                locked = false;
                                            } else {
                                                locked = true;
                                            }
                                        } else {
                                            boolean res = GridDhtPartitionsEvictor.this.evictionRunning.compareAndSet(true, false);
                                            assert (res);
                                            locked = false;
                                        }
                                        return bl;
                                    }
                                    LT.error(GridDhtPartitionsEvictor.this.log, ex, "Partition eviction failed, this can cause grid hang.");
                                }
                            }
                        }
                        finally {
                            if (!GridDhtPartitionsEvictor.this.evictionQueue.isEmpty()) {
                                if (GridDhtPartitionsEvictor.this.ctx.kernalContext().isStopping()) {
                                    GridDhtPartitionsEvictor.this.evictionQueue.clear();
                                    locked = false;
                                    continue;
                                }
                                locked = true;
                                continue;
                            }
                            boolean res = GridDhtPartitionsEvictor.this.evictionRunning.compareAndSet(true, false);
                            assert (res);
                            locked = false;
                        }
                    }
                    return true;
                }
            }, true);
        }
    }
}

