/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFuture;
import org.apache.ignite.internal.client.GridClientFutureListener;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.jdk.GridClientJdkMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientOptimizedMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientZipOptimizedMarshaller;
import org.apache.ignite.internal.client.router.impl.GridRouterClientImpl;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.client.message.GridClientPingPacket;
import org.apache.ignite.internal.processors.rest.client.message.GridClientResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridRouterRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridRouterResponse;
import org.apache.ignite.internal.util.nio.GridNioServerListener;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginProvider;
import org.jetbrains.annotations.Nullable;

public abstract class GridTcpRouterNioListenerAdapter
implements GridNioServerListener<GridClientMessage> {
    private static final Collection<Short> SUPP_VERS = new HashSet<Short>();
    private final IgniteLogger log;
    private final GridRouterClientImpl client;
    protected final Map<Byte, GridClientMarshaller> marshMap;

    public GridTcpRouterNioListenerAdapter(IgniteLogger log, GridRouterClientImpl client) {
        this.log = log;
        this.client = client;
        this.marshMap = new HashMap<Byte, GridClientMarshaller>();
        List<PluginProvider> providers = U.allPluginProviders();
        GridClientOptimizedMarshaller optdMarsh = new GridClientOptimizedMarshaller(providers);
        this.marshMap.put((byte)1, optdMarsh);
        this.marshMap.put((byte)3, new GridClientZipOptimizedMarshaller(optdMarsh, providers));
        this.marshMap.put((byte)2, new GridClientJdkMarshaller());
        this.init();
    }

    protected abstract void init();

    @Override
    public void onConnected(GridNioSession ses) {
    }

    @Override
    public void onDisconnected(GridNioSession ses, @Nullable Exception e) {
        if (e != null) {
            if (e instanceof RuntimeException) {
                U.error(this.log, "Failed to process request from remote client: " + ses, e);
            } else {
                U.warn(this.log, "Closed client session due to exception [ses=" + ses + ", err=" + e.getMessage() + ']');
            }
        }
    }

    @Override
    public void onMessageSent(GridNioSession ses, GridClientMessage msg) {
    }

    @Override
    public void onMessage(final GridNioSession ses, GridClientMessage msg) {
        if (msg instanceof GridRouterRequest) {
            GridRouterRequest routerMsg = (GridRouterRequest)msg;
            final UUID clientId = routerMsg.clientId();
            final long reqId = routerMsg.requestId();
            try {
                this.client.forwardMessage(routerMsg, routerMsg.destinationId(), (Byte)ses.meta(GridNioSessionMetaKey.MARSHALLER_ID.ordinal())).listen(new GridClientFutureListener(){

                    public void onDone(GridClientFuture fut) {
                        try {
                            GridRouterResponse res = (GridRouterResponse)fut.get();
                            res.requestId(reqId);
                            ses.send(res);
                        }
                        catch (GridClientException e) {
                            ses.send(GridTcpRouterNioListenerAdapter.this.makeFailureResponse(e, clientId, reqId));
                        }
                    }
                });
            }
            catch (GridClientException e) {
                ses.send(this.makeFailureResponse(e, clientId, reqId));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                U.warn(this.log, "Message forwarding was interrupted (will ignore last message): " + e.getMessage(), "Message forwarding was interrupted.");
            }
        } else if (msg instanceof GridClientHandshakeRequest) {
            GridClientHandshakeRequest hs = (GridClientHandshakeRequest)msg;
            short ver = hs.version();
            if (!SUPP_VERS.contains(ver)) {
                U.error(this.log, "Client protocol version is not supported [ses=" + ses + ", ver=" + ver + ", supported=" + SUPP_VERS + ']');
                ses.close();
            } else {
                byte marshId = hs.marshallerId();
                GridClientMarshaller marsh = this.marshMap.get(marshId);
                if (marsh == null) {
                    U.error(this.log, "Client marshaller ID is invalid. Note that .NET and C++ clients are supported only in enterprise edition [ses=" + ses + ", marshId=" + marshId + ']');
                    ses.close();
                } else {
                    ses.addMeta(GridNioSessionMetaKey.MARSHALLER_ID.ordinal(), marshId);
                    ses.addMeta(GridNioSessionMetaKey.MARSHALLER.ordinal(), marsh);
                    ses.send(GridClientHandshakeResponse.OK);
                }
            }
        } else if (msg instanceof GridClientPingPacket) {
            ses.send(GridClientPingPacket.PING_MESSAGE);
        } else {
            throw new IllegalArgumentException("Unsupported input message: " + msg);
        }
    }

    @Override
    public void onFailure(FailureType failureType, Throwable failure) {
    }

    @Override
    public void onSessionWriteTimeout(GridNioSession ses) {
        U.warn(this.log, "Closing NIO session because of write timeout.");
        ses.close();
    }

    @Override
    public void onSessionIdleTimeout(GridNioSession ses) {
        U.warn(this.log, "Closing NIO session because of idle.");
        ses.close();
    }

    private GridClientResponse makeFailureResponse(GridClientException e, UUID clientId, Long reqId) {
        U.error(this.log, "Failed to process message on router.", e);
        GridClientResponse res = new GridClientResponse();
        res.clientId(clientId);
        res.requestId(reqId);
        res.successStatus(1);
        res.errorMessage("Failed to process message on router [exception=" + e.getClass().getSimpleName() + ", message=" + e.getMessage() + ']');
        return res;
    }

    static {
        SUPP_VERS.add((short)1);
    }
}

