/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class GridClientThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolCtr = new AtomicInteger(1);
    private final AtomicInteger threadCtr = new AtomicInteger(1);
    private final String prefix;
    private final boolean daemon;

    public GridClientThreadFactory(String name, boolean daemon) {
        this.daemon = daemon;
        this.prefix = "ignite-client-" + name + "-" + poolCtr.getAndIncrement() + "-";
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        Thread thread = new Thread(r, this.prefix + this.threadCtr.incrementAndGet());
        if (this.daemon) {
            thread.setDaemon(true);
        }
        return thread;
    }
}

