/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.streams;

import java.nio.ByteBuffer;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;

public class BinaryByteBufferInputStream
implements BinaryInputStream {
    private ByteBuffer buf;

    public static BinaryByteBufferInputStream create(ByteBuffer buf) {
        return new BinaryByteBufferInputStream(buf);
    }

    BinaryByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public byte readByte() {
        this.ensureHasData(1);
        return this.buf.get();
    }

    @Override
    public byte[] readByteArray(int cnt) {
        this.ensureHasData(cnt);
        byte[] data = new byte[cnt];
        this.buf.get(data);
        return data;
    }

    @Override
    public int read(byte[] arr, int off, int cnt) {
        this.ensureHasData(cnt);
        return 0;
    }

    @Override
    public boolean readBoolean() {
        this.ensureHasData(1);
        return false;
    }

    @Override
    public boolean[] readBooleanArray(int cnt) {
        this.ensureHasData(cnt);
        boolean[] res = new boolean[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.get() != 0;
        }
        return res;
    }

    @Override
    public short readShort() {
        this.ensureHasData(2);
        return this.buf.getShort();
    }

    @Override
    public short[] readShortArray(int cnt) {
        this.ensureHasData(2 * cnt);
        short[] res = new short[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getShort();
        }
        return res;
    }

    @Override
    public char readChar() {
        this.ensureHasData(2);
        return this.buf.getChar();
    }

    @Override
    public char[] readCharArray(int cnt) {
        this.ensureHasData(2 * cnt);
        char[] res = new char[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getChar();
        }
        return res;
    }

    @Override
    public int readInt() {
        this.ensureHasData(4);
        return this.buf.getInt();
    }

    @Override
    public int[] readIntArray(int cnt) {
        this.ensureHasData(4 * cnt);
        int[] res = new int[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getInt();
        }
        return res;
    }

    @Override
    public float readFloat() {
        this.ensureHasData(4);
        return this.buf.getFloat();
    }

    @Override
    public float[] readFloatArray(int cnt) {
        this.ensureHasData(4 * cnt);
        float[] res = new float[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getFloat();
        }
        return res;
    }

    @Override
    public long readLong() {
        this.ensureHasData(8);
        return this.buf.getLong();
    }

    @Override
    public long[] readLongArray(int cnt) {
        this.ensureHasData(8 * cnt);
        long[] res = new long[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getLong();
        }
        return res;
    }

    @Override
    public double readDouble() {
        this.ensureHasData(8);
        return this.buf.getDouble();
    }

    @Override
    public double[] readDoubleArray(int cnt) {
        this.ensureHasData(8 * cnt);
        double[] res = new double[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getDouble();
        }
        return res;
    }

    @Override
    public int remaining() {
        return this.buf.remaining();
    }

    @Override
    public byte readBytePositioned(int pos) {
        int oldPos = this.buf.position();
        this.buf.position(pos);
        this.ensureHasData(1);
        byte res = this.buf.get();
        this.buf.position(oldPos);
        return res;
    }

    @Override
    public short readShortPositioned(int pos) {
        int oldPos = this.buf.position();
        this.buf.position(pos);
        this.ensureHasData(2);
        short res = this.buf.getShort();
        this.buf.position(oldPos);
        return res;
    }

    @Override
    public int readIntPositioned(int pos) {
        int oldPos = this.buf.position();
        this.buf.position(pos);
        this.ensureHasData(4);
        byte res = this.buf.get();
        this.buf.position(oldPos);
        return res;
    }

    @Override
    public int position() {
        return this.buf.position();
    }

    @Override
    public void position(int pos) {
        this.buf.position(pos);
    }

    @Override
    public long rawOffheapPointer() {
        return 0L;
    }

    @Override
    public int capacity() {
        return this.buf.capacity();
    }

    @Override
    public byte[] array() {
        return this.buf.array();
    }

    @Override
    public byte[] arrayCopy() {
        return this.buf.array();
    }

    @Override
    public long offheapPointer() {
        return 0L;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    private void ensureHasData(int cnt) {
        if (this.buf.remaining() < cnt) {
            throw new BinaryObjectException("Not enough data to read the value [requiredBytes=" + cnt + ", remainingBytes=" + this.buf.remaining() + ']');
        }
    }
}

