/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spark.impl.optimization;

import org.apache.ignite.spark.impl.optimization.SupportedExpressions;
import org.apache.spark.sql.catalyst.expressions.Ascii;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.ConcatWs;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Lower;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace;
import org.apache.spark.sql.catalyst.expressions.SoundEx;
import org.apache.spark.sql.catalyst.expressions.StringInstr;
import org.apache.spark.sql.catalyst.expressions.StringLPad;
import org.apache.spark.sql.catalyst.expressions.StringLocate;
import org.apache.spark.sql.catalyst.expressions.StringRPad;
import org.apache.spark.sql.catalyst.expressions.StringRepeat;
import org.apache.spark.sql.catalyst.expressions.StringSpace;
import org.apache.spark.sql.catalyst.expressions.StringTranslate;
import org.apache.spark.sql.catalyst.expressions.StringTrim;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.Upper;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;

public final class StringExpressions$
implements SupportedExpressions {
    public static final StringExpressions$ MODULE$;

    static {
        new StringExpressions$();
    }

    @Override
    public boolean apply(Expression expr, Function1<Expression, Object> checkChild) {
        boolean bl;
        boolean bl2 = false;
        Substring substring = null;
        Expression expression = expr;
        if (expression instanceof Ascii) {
            Ascii ascii = (Ascii)expression;
            Expression child = ascii.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Length) {
            Length length = (Length)expression;
            Expression child = length.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Concat) {
            Concat concat = (Concat)expression;
            Seq children2 = concat.children();
            bl = children2.forall(checkChild);
        } else if (expression instanceof ConcatWs) {
            ConcatWs concatWs = (ConcatWs)expression;
            Seq children3 = concatWs.children();
            bl = children3.forall(checkChild);
        } else if (expression instanceof StringInstr) {
            StringInstr stringInstr = (StringInstr)expression;
            Expression str = stringInstr.str();
            Expression substr = stringInstr.substr();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)substr));
        } else if (expression instanceof Lower) {
            Lower lower = (Lower)expression;
            Expression child = lower.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Upper) {
            Upper upper = (Upper)expression;
            Expression child = upper.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof StringLocate) {
            StringLocate stringLocate = (StringLocate)expression;
            Expression substr = stringLocate.substr();
            Expression str = stringLocate.str();
            Expression start = stringLocate.start();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)substr)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)start));
        } else if (expression instanceof StringLPad) {
            StringLPad stringLPad = (StringLPad)expression;
            Expression str = stringLPad.str();
            Expression len = stringLPad.len();
            Expression pad = stringLPad.pad();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)len)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)pad));
        } else if (expression instanceof StringRPad) {
            StringRPad stringRPad = (StringRPad)expression;
            Expression str = stringRPad.str();
            Expression len = stringRPad.len();
            Expression pad = stringRPad.pad();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)len)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)pad));
        } else if (expression instanceof StringTrimLeft) {
            StringTrimLeft stringTrimLeft = (StringTrimLeft)expression;
            Expression child = stringTrimLeft.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof StringTrimRight) {
            StringTrimRight stringTrimRight = (StringTrimRight)expression;
            Expression child = stringTrimRight.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof StringTrim) {
            StringTrim stringTrim = (StringTrim)expression;
            Expression child = stringTrim.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof RegExpReplace) {
            RegExpReplace regExpReplace = (RegExpReplace)expression;
            Expression subject = regExpReplace.subject();
            Expression regexp = regExpReplace.regexp();
            Expression rep = regExpReplace.rep();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)subject)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)regexp)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)rep));
        } else if (expression instanceof StringRepeat) {
            StringRepeat stringRepeat = (StringRepeat)expression;
            Expression str = stringRepeat.str();
            Expression times = stringRepeat.times();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)times));
        } else if (expression instanceof SoundEx) {
            SoundEx soundEx = (SoundEx)expression;
            Expression child = soundEx.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof StringSpace) {
            StringSpace stringSpace = (StringSpace)expression;
            Expression child = stringSpace.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Substring) {
            bl2 = true;
            substring = (Substring)expression;
            Expression str = substring.str();
            Expression pos = substring.pos();
            Expression len = substring.len();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)pos)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)len));
        } else if (bl2) {
            Expression str = substring.str();
            Expression pos = substring.pos();
            Expression len = substring.len();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)pos)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)len));
        } else if (expression instanceof StringTranslate) {
            StringTranslate stringTranslate = (StringTranslate)expression;
            Expression str = stringTranslate.srcExpr();
            Expression strMatch = stringTranslate.matchingExpr();
            Expression strReplace = stringTranslate.replaceExpr();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)strMatch)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)strReplace));
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public Option<String> toString(Expression expr, Function1<Expression, String> childToString, boolean useQualifier, boolean useAlias) {
        Some some;
        Expression expression = expr;
        if (expression instanceof Ascii) {
            Ascii ascii = (Ascii)expression;
            Expression child = ascii.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ASCII(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Length) {
            Length length = (Length)expression;
            Expression child = length.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(LENGTH(", ") AS INTEGER)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Concat) {
            Concat concat = (Concat)expression;
            Seq children2 = concat.children();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONCAT(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)children2.map((Function1)new Serializable(childToString){
                public static final long serialVersionUID = 0L;
                private final Function1 childToString$1;

                public final String apply(Expression x$1) {
                    return (String)this.childToString$1.apply((Object)x$1);
                }
                {
                    this.childToString$1 = childToString$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        } else if (expression instanceof ConcatWs) {
            ConcatWs concatWs = (ConcatWs)expression;
            Seq children3 = concatWs.children();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONCAT_WS(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)children3.map((Function1)new Serializable(childToString){
                public static final long serialVersionUID = 0L;
                private final Function1 childToString$1;

                public final String apply(Expression x$2) {
                    return (String)this.childToString$1.apply((Object)x$2);
                }
                {
                    this.childToString$1 = childToString$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        } else if (expression instanceof StringInstr) {
            StringInstr stringInstr = (StringInstr)expression;
            Expression str = stringInstr.str();
            Expression substr = stringInstr.substr();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POSITION(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)substr), childToString.apply((Object)str)})));
        } else if (expression instanceof Lower) {
            Lower lower = (Lower)expression;
            Expression child = lower.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOWER(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Upper) {
            Upper upper = (Upper)expression;
            Expression child = upper.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPPER(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof StringLocate) {
            StringLocate stringLocate = (StringLocate)expression;
            Expression substr = stringLocate.substr();
            Expression str = stringLocate.str();
            Expression start = stringLocate.start();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOCATE(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)substr), childToString.apply((Object)str), childToString.apply((Object)start)})));
        } else if (expression instanceof StringLPad) {
            StringLPad stringLPad = (StringLPad)expression;
            Expression str = stringLPad.str();
            Expression len = stringLPad.len();
            Expression pad = stringLPad.pad();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LPAD(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)str), childToString.apply((Object)len), childToString.apply((Object)pad)})));
        } else if (expression instanceof StringRPad) {
            StringRPad stringRPad = (StringRPad)expression;
            Expression str = stringRPad.str();
            Expression len = stringRPad.len();
            Expression pad = stringRPad.pad();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RPAD(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)str), childToString.apply((Object)len), childToString.apply((Object)pad)})));
        } else if (expression instanceof StringTrimLeft) {
            StringTrimLeft stringTrimLeft = (StringTrimLeft)expression;
            Expression child = stringTrimLeft.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LTRIM(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof StringTrimRight) {
            StringTrimRight stringTrimRight = (StringTrimRight)expression;
            Expression child = stringTrimRight.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RTRIM(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof StringTrim) {
            StringTrim stringTrim = (StringTrim)expression;
            Expression child = stringTrim.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRIM(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof RegExpReplace) {
            RegExpReplace regExpReplace = (RegExpReplace)expression;
            Expression subject = regExpReplace.subject();
            Expression regexp = regExpReplace.regexp();
            Expression rep = regExpReplace.rep();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REGEXP_REPLACE(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)subject), childToString.apply((Object)regexp), childToString.apply((Object)rep)})));
        } else if (expression instanceof StringRepeat) {
            StringRepeat stringRepeat = (StringRepeat)expression;
            Expression str = stringRepeat.str();
            Expression times = stringRepeat.times();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REPEAT(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)str), childToString.apply((Object)times)})));
        } else if (expression instanceof SoundEx) {
            SoundEx soundEx = (SoundEx)expression;
            Expression child = soundEx.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SOUND_EX(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof StringSpace) {
            StringSpace stringSpace = (StringSpace)expression;
            Expression child = stringSpace.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPACE(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Substring) {
            Substring substring = (Substring)expression;
            Expression str = substring.str();
            Expression pos = substring.pos();
            Expression len = substring.len();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SUBSTR(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)str), childToString.apply((Object)pos), childToString.apply((Object)len)})));
        } else if (expression instanceof StringTranslate) {
            StringTranslate stringTranslate = (StringTranslate)expression;
            Expression str = stringTranslate.srcExpr();
            Expression strMatch = stringTranslate.matchingExpr();
            Expression strReplace = stringTranslate.replaceExpr();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRANSLATE(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)str), childToString.apply((Object)strMatch), childToString.apply((Object)strReplace)})));
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    private StringExpressions$() {
        MODULE$ = this;
    }
}

