/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.mqtt;

import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.stream.StreamAdapter;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttStreamer<K, V>
extends StreamAdapter<MqttMessage, K, V>
implements MqttCallback {
    private IgniteLogger log;
    private MqttClient client;
    private String brokerUrl;
    private String topic;
    private Integer qualityOfService;
    private List<String> topics;
    private List<Integer> qualitiesOfService;
    private String clientId;
    private MqttClientPersistence persistence;
    private MqttConnectOptions connectOptions;
    private Integer disconnectQuiesceTimeout;
    private boolean disconnectForcibly;
    private Integer disconnectForciblyTimeout;
    private WaitStrategy retryWaitStrategy = WaitStrategies.fibonacciWait();
    private StopStrategy retryStopStrategy = StopStrategies.neverStop();
    private MqttConnectionRetrier connectionRetrier;
    private boolean blockUntilConnected;
    private volatile boolean stopped = true;
    private String cachedLogValues;

    public void start() throws IgniteException {
        if (!this.stopped) {
            throw new IgniteException("Attempted to start an already started MQTT Streamer");
        }
        this.topics = this.topics == null ? new ArrayList() : this.topics;
        this.qualitiesOfService = this.qualitiesOfService == null ? new ArrayList() : this.qualitiesOfService;
        try {
            HashMap<String, Object> logValues = new HashMap<String, Object>();
            A.notNull((Object)this.getStreamer(), (String)"streamer");
            A.notNull((Object)this.getIgnite(), (String)"ignite");
            A.ensure((this.getSingleTupleExtractor() != null || this.getMultipleTupleExtractor() != null ? 1 : 0) != 0, (String)"tuple extractor missing");
            A.ensure((this.getSingleTupleExtractor() == null || this.getMultipleTupleExtractor() == null ? 1 : 0) != 0, (String)"cannot provide both single and multiple tuple extractor");
            A.notNullOrEmpty((String)this.brokerUrl, (String)"broker URL");
            if (this.clientId == null || this.clientId.length() == 0) {
                this.clientId = MqttClient.generateClientId();
            }
            if (this.topic != null && this.topic.length() > 0 && !this.topics.isEmpty() && this.topics.size() != 1 && !this.topics.get(0).equals(this.topic)) {
                throw new IllegalArgumentException("Cannot specify both a single topic and a list at the same time.");
            }
            if (this.qualityOfService != null && !this.qualitiesOfService.isEmpty() && this.qualitiesOfService.size() != 1 && !this.qualitiesOfService.get(0).equals(this.qualityOfService)) {
                throw new IllegalArgumentException("Cannot specify both a single QoS and a list at the same time.");
            }
            if (this.disconnectForcibly && this.disconnectQuiesceTimeout != null) {
                A.notNull((Object)this.disconnectForciblyTimeout, (String)"disconnect timeout cannot be null when disconnecting forcibly with quiesce");
            }
            if (!this.topics.isEmpty()) {
                for (String t : this.topics) {
                    A.notNullOrEmpty((String)t, (String)"topic in list of topics");
                }
                A.ensure((this.qualitiesOfService.isEmpty() || this.qualitiesOfService.size() == this.topics.size() ? 1 : 0) != 0, (String)"qualities of service must be either empty or have the same size as topics list");
                logValues.put("topics", this.topics);
            } else {
                this.topics.add(this.topic);
                if (this.qualityOfService != null) {
                    this.qualitiesOfService.add(this.qualityOfService);
                }
                logValues.put("topic", this.topic);
            }
            logValues.put("brokerUrl", this.brokerUrl);
            logValues.put("clientId", this.clientId);
            this.cachedLogValues = "[" + Joiner.on((String)", ").withKeyValueSeparator("=").join(logValues) + "]";
            this.log = this.getIgnite().log();
            this.client = this.persistence == null ? new MqttClient(this.brokerUrl, this.clientId) : new MqttClient(this.brokerUrl, this.clientId, this.persistence);
            this.client.setCallback((MqttCallback)this);
            this.stopped = false;
            Retryer retrier = RetryerBuilder.newBuilder().retryIfResult((Predicate)new Predicate<Void>(){

                public boolean apply(Void v) {
                    return !MqttStreamer.this.client.isConnected() && !MqttStreamer.this.stopped;
                }
            }).retryIfException().retryIfRuntimeException().withWaitStrategy(this.retryWaitStrategy).withStopStrategy(this.retryStopStrategy).build();
            this.connectionRetrier = new MqttConnectionRetrier((Retryer<Void>)retrier);
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting MQTT Streamer " + this.cachedLogValues);
            }
            this.connectionRetrier.connect();
        }
        catch (Exception e) {
            throw new IgniteException("Failed to initialize MQTT Streamer.", (Throwable)e);
        }
    }

    public void stop() throws IgniteException {
        if (this.stopped) {
            throw new IgniteException("Failed to stop MQTT Streamer (already stopped).");
        }
        this.connectionRetrier.stop();
        try {
            if (this.disconnectForcibly) {
                if (this.disconnectQuiesceTimeout == null && this.disconnectForciblyTimeout == null) {
                    this.client.disconnectForcibly();
                } else if (this.disconnectForciblyTimeout != null && this.disconnectQuiesceTimeout == null) {
                    this.client.disconnectForcibly((long)this.disconnectForciblyTimeout.intValue());
                } else {
                    this.client.disconnectForcibly((long)this.disconnectQuiesceTimeout.intValue(), (long)this.disconnectForciblyTimeout.intValue());
                }
            } else if (this.disconnectQuiesceTimeout == null) {
                this.client.disconnect();
            } else {
                this.client.disconnect((long)this.disconnectQuiesceTimeout.intValue());
            }
            this.client.close();
            this.stopped = true;
        }
        catch (Exception e) {
            throw new IgniteException("Failed to stop Exception while stopping MQTT Streamer.", (Throwable)e);
        }
    }

    public void connectionLost(Throwable throwable) {
        if (this.stopped) {
            return;
        }
        this.log.warning(String.format("MQTT Connection to broker was lost [brokerUrl=%s, type=%s, err=%s]", this.brokerUrl, throwable.getClass(), throwable.getMessage()));
        this.connectionRetrier.connect();
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        if (this.getMultipleTupleExtractor() != null) {
            Map entries = this.getMultipleTupleExtractor().extract((Object)message);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Adding cache entries: " + entries);
            }
            this.getStreamer().addData(entries);
        } else {
            Map.Entry entry = this.getSingleTupleExtractor().extract((Object)message);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Adding cache entry: " + entry);
            }
            this.getStreamer().addData(entry);
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setQualityOfService(Integer qualityOfService) {
        this.qualityOfService = qualityOfService;
    }

    public Integer getQualityOfService() {
        return this.qualityOfService;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setQualitiesOfService(List<Integer> qualitiesOfService) {
        this.qualitiesOfService = qualitiesOfService;
    }

    public List<Integer> getQualitiesOfService() {
        return this.qualitiesOfService;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public MqttClientPersistence getPersistence() {
        return this.persistence;
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }

    public MqttConnectOptions getConnectOptions() {
        return this.connectOptions;
    }

    public void setConnectOptions(MqttConnectOptions connectOptions) {
        this.connectOptions = connectOptions;
    }

    public void setDisconnectForcibly(boolean disconnectForcibly) {
        this.disconnectForcibly = disconnectForcibly;
    }

    public boolean isDisconnectForcibly() {
        return this.disconnectForcibly;
    }

    public void setDisconnectQuiesceTimeout(Integer disconnectQuiesceTimeout) {
        this.disconnectQuiesceTimeout = disconnectQuiesceTimeout;
    }

    public Integer getDisconnectQuiesceTimeout() {
        return this.disconnectQuiesceTimeout;
    }

    public void setDisconnectForciblyTimeout(Integer disconnectForciblyTimeout) {
        this.disconnectForciblyTimeout = disconnectForciblyTimeout;
    }

    public Integer getDisconnectForciblyTimeout() {
        return this.disconnectForciblyTimeout;
    }

    public void setRetryWaitStrategy(WaitStrategy retryWaitStrategy) {
        this.retryWaitStrategy = retryWaitStrategy;
    }

    public WaitStrategy getRetryWaitStrategy() {
        return this.retryWaitStrategy;
    }

    public void setRetryStopStrategy(StopStrategy retryStopStrategy) {
        this.retryStopStrategy = retryStopStrategy;
    }

    public StopStrategy getRetryStopStrategy() {
        return this.retryStopStrategy;
    }

    public void setBlockUntilConnected(boolean blockUntilConnected) {
        this.blockUntilConnected = blockUntilConnected;
    }

    public boolean isBlockUntilConnected() {
        return this.blockUntilConnected;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    private class MqttConnectionRetrier {
        private final Retryer<Void> retrier;
        private final ExecutorService exec = Executors.newSingleThreadExecutor();

        public MqttConnectionRetrier(Retryer<Void> retrier) {
            this.retrier = retrier;
        }

        public void connect() {
            Retryer.RetryerCallable callable = this.retrier.wrap((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (MqttStreamer.this.client.isConnected()) {
                        return null;
                    }
                    if (MqttStreamer.this.stopped) {
                        return null;
                    }
                    if (MqttStreamer.this.connectOptions == null) {
                        MqttStreamer.this.client.connect();
                    } else {
                        MqttStreamer.this.client.connect(MqttStreamer.this.connectOptions);
                    }
                    if (MqttStreamer.this.qualitiesOfService.isEmpty()) {
                        MqttStreamer.this.client.subscribe(MqttStreamer.this.topics.toArray(new String[0]));
                    } else {
                        int[] qoses = new int[MqttStreamer.this.qualitiesOfService.size()];
                        for (int i = 0; i < MqttStreamer.this.qualitiesOfService.size(); ++i) {
                            qoses[i] = (Integer)MqttStreamer.this.qualitiesOfService.get(i);
                        }
                        MqttStreamer.this.client.subscribe(MqttStreamer.this.topics.toArray(new String[0]), qoses);
                    }
                    if (MqttStreamer.this.log.isInfoEnabled()) {
                        MqttStreamer.this.log.info("MQTT Streamer (re-)connected and subscribed " + MqttStreamer.this.cachedLogValues);
                    }
                    return null;
                }
            });
            Future result = this.exec.submit(callable);
            if (MqttStreamer.this.blockUntilConnected) {
                try {
                    result.get();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void stop() {
            this.exec.shutdownNow();
        }
    }
}

