/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.camel;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ServiceStatus;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.stream.StreamAdapter;

public class CamelStreamer<K, V>
extends StreamAdapter<Exchange, K, V>
implements Processor {
    private IgniteLogger log;
    private CamelContext camelCtx;
    private String endpointUri;
    private Endpoint endpoint;
    private Consumer consumer;
    private Processor resProc;

    public void start() throws IgniteException {
        A.notNullOrEmpty((String)this.endpointUri, (String)"endpoint URI must be provided");
        A.ensure((this.getSingleTupleExtractor() != null || this.getMultipleTupleExtractor() != null ? 1 : 0) != 0, (String)"tuple extractor missing");
        if (this.camelCtx == null) {
            this.camelCtx = new DefaultCamelContext();
        }
        if (this.camelCtx.getStatus() == ServiceStatus.Started || this.camelCtx.getStatus() == ServiceStatus.Starting) {
            throw new IgniteException("Failed to start Camel streamer (CamelContext already started or starting).");
        }
        this.log = this.getIgnite().log();
        try {
            this.endpoint = CamelContextHelper.getMandatoryEndpoint((CamelContext)this.camelCtx, (String)this.endpointUri);
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)e);
            throw new IgniteException("Failed to start Camel streamer [errMsg=" + e.getMessage() + ']');
        }
        try {
            this.consumer = this.endpoint.createConsumer((Processor)this);
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)e);
            throw new IgniteException("Failed to start Camel streamer [errMsg=" + e.getMessage() + ']');
        }
        try {
            ServiceHelper.startServices((Object[])new Object[]{this.camelCtx, this.endpoint, this.consumer});
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)e);
            try {
                ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.camelCtx, this.endpoint, this.consumer});
                this.consumer = null;
                this.endpoint = null;
            }
            catch (Exception e1) {
                throw new IgniteException("Failed to start Camel streamer; failed to stop the context, endpoint or consumer during rollback of failed initialization [errMsg=" + e.getMessage() + ", stopErrMsg=" + e1.getMessage() + ']');
            }
            throw new IgniteException("Failed to start Camel streamer [errMsg=" + e.getMessage() + ']');
        }
        U.log((IgniteLogger)this.log, (Object)("Started Camel streamer consuming from endpoint URI: " + this.endpointUri));
    }

    public void stop() throws IgniteException {
        if (this.camelCtx.getStatus() == ServiceStatus.Stopped || this.camelCtx.getStatus() == ServiceStatus.Stopping) {
            throw new IgniteException("Failed to stop Camel streamer (CamelContext already stopped or stopping).");
        }
        try {
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.camelCtx, this.endpoint, this.consumer});
        }
        catch (Exception e) {
            throw new IgniteException("Failed to stop Camel streamer [errMsg=" + e.getMessage() + ']');
        }
        U.log((IgniteLogger)this.log, (Object)("Stopped Camel streamer, formerly consuming from endpoint URI: " + this.endpointUri));
    }

    public void process(Exchange exchange) throws Exception {
        if (this.getMultipleTupleExtractor() == null) {
            Map.Entry entry = this.getSingleTupleExtractor().extract((Object)exchange);
            this.getStreamer().addData(entry);
        } else {
            Map entries = this.getMultipleTupleExtractor().extract((Object)exchange);
            this.getStreamer().addData(entries);
        }
        if (this.resProc != null) {
            this.resProc.process(exchange);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelCtx;
    }

    public void setCamelContext(CamelContext camelCtx) {
        this.camelCtx = camelCtx;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public Processor getResponseProcessor() {
        return this.resProc;
    }

    public void setResponseProcessor(Processor resProc) {
        this.resProc = resProc;
    }
}

