/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.Channel;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Preconditions;
import scala.Tuple2;

public class OneForOneStreamManager
extends StreamManager {
    private static final Logger logger = LoggerFactory.getLogger(OneForOneStreamManager.class);
    private final AtomicLong nextStreamId = new AtomicLong((long)new Random().nextInt(Integer.MAX_VALUE) * 1000L);
    private final ConcurrentHashMap<Long, StreamState> streams = new ConcurrentHashMap();

    @Override
    public void registerChannel(Channel channel, long streamId) {
        if (this.streams.containsKey(streamId)) {
            this.streams.get((Object)Long.valueOf((long)streamId)).associatedChannel = channel;
        }
    }

    @Override
    public ManagedBuffer getChunk(long streamId, int chunkIndex) {
        StreamState state = this.streams.get(streamId);
        if (chunkIndex != state.curChunk) {
            throw new IllegalStateException(String.format("Received out-of-order chunk index %s (expected %s)", chunkIndex, state.curChunk));
        }
        if (!state.buffers.hasNext()) {
            throw new IllegalStateException(String.format("Requested chunk index beyond end %s", chunkIndex));
        }
        ++state.curChunk;
        ManagedBuffer nextChunk = state.buffers.next();
        if (!state.buffers.hasNext()) {
            logger.trace("Removing stream id {}", (Object)streamId);
            this.streams.remove(streamId);
        }
        return nextChunk;
    }

    @Override
    public ManagedBuffer openStream(String streamChunkId) {
        Tuple2<Long, Integer> streamIdAndChunkId = OneForOneStreamManager.parseStreamChunkId(streamChunkId);
        return this.getChunk((Long)streamIdAndChunkId._1, (Integer)streamIdAndChunkId._2);
    }

    public static String genStreamChunkId(long streamId, int chunkId) {
        return String.format("%d_%d", streamId, chunkId);
    }

    public static Tuple2<Long, Integer> parseStreamChunkId(String streamChunkId) {
        String[] array = streamChunkId.split("_");
        assert (array.length == 2) : "Stream id and chunk index should be specified when open stream for fetching block.";
        long streamId = Long.valueOf(array[0]);
        int chunkIndex = Integer.valueOf(array[1]);
        return new Tuple2((Object)streamId, (Object)chunkIndex);
    }

    @Override
    public void connectionTerminated(Channel channel) {
        for (Map.Entry<Long, StreamState> entry : this.streams.entrySet()) {
            StreamState state = entry.getValue();
            if (state.associatedChannel != channel) continue;
            this.streams.remove(entry.getKey());
            while (state.buffers.hasNext()) {
                state.buffers.next().release();
            }
        }
    }

    @Override
    public void checkAuthorization(TransportClient client, long streamId) {
        if (client.getClientId() != null) {
            StreamState state = this.streams.get(streamId);
            Preconditions.checkArgument(state != null, "Unknown stream ID.");
            if (!client.getClientId().equals(state.appId)) {
                throw new SecurityException(String.format("Client %s not authorized to read stream %d (app %s).", client.getClientId(), streamId, state.appId));
            }
        }
    }

    public long registerStream(String appId, Iterator<ManagedBuffer> buffers) {
        long myStreamId = this.nextStreamId.getAndIncrement();
        this.streams.put(myStreamId, new StreamState(appId, buffers));
        return myStreamId;
    }

    private static class StreamState {
        final String appId;
        final Iterator<ManagedBuffer> buffers;
        Channel associatedChannel = null;
        int curChunk = 0;

        StreamState(String appId, Iterator<ManagedBuffer> buffers) {
            this.appId = appId;
            this.buffers = Preconditions.checkNotNull(buffers);
        }
    }
}

