/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.upload.model;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.yardstick.upload.StreamerParams;
import org.jetbrains.annotations.Nullable;

public class QueryFactory {
    public static final String DROP_TABLE_IF_EXISTS = "DROP TABLE IF EXISTS test_upload;";
    public static final String COUNT = "SELECT COUNT(id) FROM test_upload;";
    public static final String TURN_OFF_WAL = "ALTER TABLE test_upload NOLOGGING";
    public static final String TURN_ON_WAL = "ALTER TABLE test_upload LOGGING";
    public static final String TURN_OFF_STREAMING = "SET STREAMING OFF";
    private int valFieldsCnt = 10;
    private String createTable = this.newCreateTableQuery();
    private String insert = this.newInsertQuery();

    private String newCreateTableQuery() {
        StringBuilder create = new StringBuilder("CREATE TABLE test_upload (id LONG PRIMARY KEY");
        for (int vi = 1; vi <= this.valFieldsCnt; ++vi) {
            create.append(", val_").append(vi);
            if (vi % 2 == 1) {
                create.append(" VARCHAR(255)");
                continue;
            }
            create.append(" LONG");
        }
        create.append(");");
        return create.toString();
    }

    private String newInsertQuery() {
        StringBuilder insert = new StringBuilder("INSERT INTO test_upload VALUES (?");
        for (int vi = 1; vi <= this.valFieldsCnt; ++vi) {
            insert.append(", ?");
        }
        insert.append(");");
        return insert.toString();
    }

    public String createTable() {
        return this.createTable;
    }

    public String insert() {
        return this.insert;
    }

    public String copyFrom(String csvFilePath, @Nullable Long packetSize) {
        String pSizeExpr = "";
        if (packetSize != null) {
            pSizeExpr = " packet_size " + packetSize;
        }
        return "COPY FROM '" + csvFilePath + "' " + "INTO test_upload " + this.attributes() + " " + "FORMAT CSV" + pSizeExpr + ";";
    }

    private String attributes() {
        StringBuilder attrs = new StringBuilder("(id");
        for (int vi = 1; vi <= this.valFieldsCnt; ++vi) {
            attrs.append(", val_").append(vi);
        }
        attrs.append(')');
        return attrs.toString();
    }

    public void setRandomInsertArgs(PreparedStatement stmt, long id) throws SQLException {
        stmt.setLong(1, id);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int vi = 1; vi <= this.valFieldsCnt; ++vi) {
            int qryIdx = vi + 1;
            long nextVal = rnd.nextLong();
            if (vi % 2 == 1) {
                stmt.setLong(qryIdx, nextVal);
                continue;
            }
            stmt.setString(qryIdx, String.valueOf(nextVal));
        }
    }

    public String randomCsvLine(long id) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        StringBuilder line = new StringBuilder().append(id);
        for (int vi = 1; vi <= this.valFieldsCnt; ++vi) {
            line.append(',');
            if (vi % 2 == 1) {
                line.append(rnd.nextLong());
                continue;
            }
            line.append('\"').append(rnd.nextLong()).append('\"');
        }
        return line.toString();
    }

    public String turnOnStreaming(StreamerParams p) {
        StringBuilder cmd = new StringBuilder("SET STREAMING ON");
        if (p.streamerLocalBatchSize() != null) {
            cmd.append(" BATCH_SIZE ").append(p.streamerLocalBatchSize());
        }
        if (p.streamerAllowOverwrite() != null) {
            String val = p.streamerAllowOverwrite() != false ? "ON" : "OFF";
            cmd.append(" ALLOW_OVERWRITE ").append(val);
        }
        if (p.streamerPerNodeParallelOperations() != null) {
            cmd.append(" PER_NODE_PARALLEL_OPERATIONS ").append(p.streamerPerNodeParallelOperations());
        }
        if (p.streamerPerNodeBufferSize() != null) {
            cmd.append(" PER_NODE_BUFFER_SIZE ").append(p.streamerPerNodeBufferSize());
        }
        cmd.append(" ORDERED ").append(p.streamerOrdered() ? "ON" : "OFF");
        return cmd.append(';').toString();
    }
}

