/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.upload;

import java.util.HashMap;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.yardstick.upload.AbstractNativeBenchmark;
import org.apache.ignite.yardstick.upload.model.Values10;

public class NativeStreamerBenchmark
extends AbstractNativeBenchmark {
    @Override
    protected void upload(String cacheName, long insertsCnt) {
        try (IgniteDataStreamer streamer = this.ignite().dataStreamer(cacheName);){
            Integer batchSize;
            if (this.args.upload.streamerPerNodeBufferSize() != null) {
                streamer.perNodeBufferSize(this.args.upload.streamerPerNodeBufferSize().intValue());
            }
            if (this.args.upload.streamerPerNodeParallelOperations() != null) {
                streamer.perNodeParallelOperations(this.args.upload.streamerPerNodeParallelOperations().intValue());
            }
            if (this.args.upload.streamerAllowOverwrite() != null) {
                streamer.allowOverwrite(this.args.upload.streamerAllowOverwrite().booleanValue());
            }
            if ((batchSize = this.args.upload.streamerLocalBatchSize()) == null) {
                for (long i = 1L; i <= insertsCnt; ++i) {
                    streamer.addData((Object)i, (Object)new Values10());
                }
            } else {
                HashMap<Long, Values10> buf = new HashMap<Long, Values10>(batchSize);
                for (long i = 1L; i <= insertsCnt; ++i) {
                    buf.put(i, new Values10());
                    if (i % (long)batchSize.intValue() != 0L && i != insertsCnt) continue;
                    streamer.addData(buf);
                    buf.clear();
                }
            }
        }
    }
}

