/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.upload;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.ignite.yardstick.jdbc.AbstractJdbcBenchmark;
import org.apache.ignite.yardstick.upload.model.QueryFactory;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class AbstractUploadBenchmark
extends AbstractJdbcBenchmark {
    long insertRowsCnt;
    long warmupRowsCnt;
    protected QueryFactory queries = new QueryFactory();

    @Override
    public final void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.insertRowsCnt = this.args.upload.uploadRowsCnt();
        this.warmupRowsCnt = this.args.upload.warmupRowsCnt();
        this.init();
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"Starting custom warmup");
        if (this.args.upload.disableWal()) {
            this.executeUpdate("ALTER TABLE test_upload NOLOGGING");
        }
        try (Connection warmupConn = this.uploadConnection();){
            if (this.args.upload.useStreaming()) {
                AbstractUploadBenchmark.executeUpdateOn(warmupConn, this.queries.turnOnStreaming(this.args.upload));
            }
            this.warmup(warmupConn);
            if (this.args.upload.useStreaming()) {
                AbstractUploadBenchmark.executeUpdateOn(warmupConn, "SET STREAMING OFF");
            }
        }
        if (this.args.upload.disableWal()) {
            this.executeUpdate("ALTER TABLE test_upload LOGGING");
        }
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"Custom warmup finished");
        this.dropAndCreate();
    }

    protected void init() {
    }

    protected abstract void warmup(Connection var1) throws Exception;

    @Override
    protected void setupData() throws Exception {
        this.dropAndCreate();
    }

    protected abstract void upload(Connection var1) throws Exception;

    public final boolean test(Map<Object, Object> ctx) throws Exception {
        if (this.args.upload.disableWal()) {
            this.executeUpdate("ALTER TABLE test_upload NOLOGGING");
        }
        try (Connection uploadConn = this.uploadConnection();){
            if (this.args.upload.useStreaming()) {
                AbstractUploadBenchmark.executeUpdateOn(uploadConn, this.queries.turnOnStreaming(this.args.upload));
            }
            this.upload(uploadConn);
            if (this.args.upload.useStreaming()) {
                AbstractUploadBenchmark.executeUpdateOn(uploadConn, "SET STREAMING OFF");
            }
        }
        if (this.args.upload.disableWal()) {
            this.executeUpdate("ALTER TABLE test_upload LOGGING");
        }
        return true;
    }

    private void dropAndCreate() throws SQLException {
        this.executeUpdate("DROP TABLE IF EXISTS test_upload;");
        this.executeUpdate(this.queries.createTable());
    }

    /*
     * Exception decompiling
     */
    public long count() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"Tearing down");
        try {
            long cnt = this.count();
            if (cnt != this.insertRowsCnt) {
                String msg = "Rows count is incorrect: [actual=" + cnt + ", expected=" + this.insertRowsCnt + "]";
                BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("TearDown: " + msg));
                throw new RuntimeException(msg);
            }
            BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Test table contains " + cnt + " rows."));
        }
        finally {
            super.tearDown();
        }
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"TearDown successfully finished.");
    }

    private int executeUpdate(String updQry) throws SQLException {
        return AbstractUploadBenchmark.executeUpdateOn((Connection)this.conn.get(), updQry);
    }

    private static int executeUpdateOn(Connection c, String updQry) throws SQLException {
        try (PreparedStatement update = c.prepareStatement(updQry);){
            int n = update.executeUpdate();
            return n;
        }
    }

    private Connection uploadConnection() throws SQLException {
        String urlParams = "";
        List<String> rawParams = this.args.upload.uploadJdbcParams();
        if (!rawParams.isEmpty()) {
            String kvList = String.join((CharSequence)"&", rawParams);
            urlParams = "?" + kvList;
        }
        return this.connection(this.url + urlParams);
    }
}

